/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.pig.util.SqlQueryToColumnInfoFunction;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.ColumnInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SqlQueryToColumnInfoFunctionTest
extends BaseConnectionlessQueryTest {
    private Configuration configuration;
    private SqlQueryToColumnInfoFunction function;

    @Before
    public void setUp() throws SQLException {
        this.configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)this.configuration.get("hbase.zookeeper.quorum")).thenReturn((Object)SqlQueryToColumnInfoFunctionTest.getUrl());
        this.function = new SqlQueryToColumnInfoFunction(this.configuration);
    }

    @Test
    public void testValidSelectQuery() throws SQLException {
        String ddl = "CREATE TABLE EMPLOYEE   (id integer not null, name varchar, age integer,location varchar   CONSTRAINT pk PRIMARY KEY (id))\n";
        SqlQueryToColumnInfoFunctionTest.createTestTable((String)SqlQueryToColumnInfoFunctionTest.getUrl(), (String)ddl);
        String selectQuery = "SELECT name as a ,age AS b,UPPER(location) AS c FROM EMPLOYEE";
        ColumnInfo NAME_COLUMN = new ColumnInfo("A", 12);
        ColumnInfo AGE_COLUMN = new ColumnInfo("B", 4);
        ColumnInfo LOCATION_COLUMN = new ColumnInfo("C", 12);
        ImmutableList expectedColumnInfos = ImmutableList.of((Object)NAME_COLUMN, (Object)AGE_COLUMN, (Object)LOCATION_COLUMN);
        List actualColumnInfos = this.function.apply("SELECT name as a ,age AS b,UPPER(location) AS c FROM EMPLOYEE");
        Assert.assertEquals((Object)expectedColumnInfos, (Object)actualColumnInfos);
    }
}

