/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.pig.util.QuerySchemaParserFunction;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class QuerySchemaParserFunctionTest
extends BaseConnectionlessQueryTest {
    private Configuration configuration;
    private QuerySchemaParserFunction function;

    @Before
    public void setUp() throws SQLException {
        this.configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)this.configuration.get("hbase.zookeeper.quorum")).thenReturn((Object)QuerySchemaParserFunctionTest.getUrl());
        this.function = new QuerySchemaParserFunction(this.configuration);
    }

    @Test(expected=RuntimeException.class)
    public void testSelectQuery() {
        String selectQuery = "SELECT col1 FROM test";
        this.function.apply("SELECT col1 FROM test");
        Assert.fail((String)"Should fail as the table [test] doesn't exist");
    }

    @Test
    public void testValidSelectQuery() throws SQLException {
        String ddl = "CREATE TABLE EMPLOYEE   (id integer not null, name varchar, age integer,location varchar   CONSTRAINT pk PRIMARY KEY (id))\n";
        QuerySchemaParserFunctionTest.createTestTable((String)QuerySchemaParserFunctionTest.getUrl(), (String)ddl);
        String selectQuery = "SELECT name,age,location FROM EMPLOYEE";
        Pair pair = this.function.apply("SELECT name,age,location FROM EMPLOYEE");
        Assert.assertEquals((Object)pair.getFirst(), (Object)"EMPLOYEE");
        Assert.assertEquals((Object)pair.getSecond(), (Object)String.join((CharSequence)",", "NAME", "AGE", "LOCATION"));
    }

    @Test(expected=RuntimeException.class)
    public void testUpsertQuery() throws SQLException {
        String ddl = "CREATE TABLE EMPLOYEE   (id integer not null, name varchar, age integer,location varchar   CONSTRAINT pk PRIMARY KEY (id))\n";
        QuerySchemaParserFunctionTest.createTestTable((String)QuerySchemaParserFunctionTest.getUrl(), (String)ddl);
        String upsertQuery = "UPSERT INTO EMPLOYEE (ID, NAME) VALUES (?, ?)";
        this.function.apply("UPSERT INTO EMPLOYEE (ID, NAME) VALUES (?, ?)");
        Assert.fail((String)" Function call successful despite passing an UPSERT query");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAggregationQuery() throws SQLException {
        String ddl = "CREATE TABLE EMPLOYEE   (id integer not null, name varchar, age integer,location varchar   CONSTRAINT pk PRIMARY KEY (id))\n";
        QuerySchemaParserFunctionTest.createTestTable((String)QuerySchemaParserFunctionTest.getUrl(), (String)ddl);
        String selectQuery = "SELECT MAX(ID) FROM EMPLOYEE";
        this.function.apply("SELECT MAX(ID) FROM EMPLOYEE");
        Assert.fail((String)" Function call successful despite passing an aggreagate query");
    }
}

