/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.pig.util.PhoenixPigSchemaUtil;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.pig.ResourceSchema;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PhoenixPigSchemaUtilTest {
    private static final ColumnInfo ID_COLUMN = new ColumnInfo("ID", -5);
    private static final ColumnInfo NAME_COLUMN = new ColumnInfo("NAME", 12);
    private static final ColumnInfo LOCATION_COLUMN = new ColumnInfo("LOCATION", 2003);

    @Test
    public void testSchema() throws SQLException, IOException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.get("phoenix.select.schema.type")).thenReturn((Object)PhoenixConfigurationUtil.SchemaType.TABLE.name());
        ResourceSchema actual = PhoenixPigSchemaUtil.getResourceSchema((Configuration)configuration, (PhoenixPigSchemaUtil.Dependencies)new PhoenixPigSchemaUtil.Dependencies(){

            List<ColumnInfo> getSelectColumnMetadataList(Configuration configuration) throws SQLException {
                return new ArrayList<ColumnInfo>(Arrays.asList(ID_COLUMN, NAME_COLUMN));
            }
        });
        ResourceSchema.ResourceFieldSchema[] fields = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName("ID").setType((byte)15), new ResourceSchema.ResourceFieldSchema().setName("NAME").setType((byte)55)};
        ResourceSchema expected = new ResourceSchema().setFields(fields);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test(expected=IllegalDataException.class)
    public void testUnSupportedTypes() throws SQLException, IOException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.get("phoenix.select.schema.type")).thenReturn((Object)PhoenixConfigurationUtil.SchemaType.TABLE.name());
        PhoenixPigSchemaUtil.getResourceSchema((Configuration)configuration, (PhoenixPigSchemaUtil.Dependencies)new PhoenixPigSchemaUtil.Dependencies(){

            List<ColumnInfo> getSelectColumnMetadataList(Configuration configuration) throws SQLException {
                return new ArrayList<ColumnInfo>(Arrays.asList(ID_COLUMN, LOCATION_COLUMN));
            }
        });
        Assert.fail((String)"We currently don't support Array type yet. WIP!!");
    }
}

