/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.udf;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.pig.BasePigIT;
import org.apache.phoenix.pig.udf.ReserveNSequence;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ReserveNSequenceTestIT
extends BasePigIT {
    private static final String CREATE_SEQUENCE_SYNTAX = "CREATE SEQUENCE %s START WITH %s INCREMENT BY %s MINVALUE %s MAXVALUE %s CACHE %s";
    private static final String SEQUENCE_NAME = "my_schema.my_sequence";
    private static final long MAX_VALUE = 10L;
    private static UDFContext udfContext;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createSequence(this.conn);
        this.createUdfContext();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        udfContext.reset();
        this.dropSequence(this.conn);
        super.tearDown();
    }

    @Test
    public void testReserve() throws Exception {
        this.doTest(new UDFTestProperties(1L));
    }

    @Test
    public void testReserveN() throws Exception {
        this.doTest(new UDFTestProperties(5L));
    }

    @Test
    public void testReserveNwithPreviousAllocations() throws Exception {
        UDFTestProperties props = new UDFTestProperties(5L);
        props.setCurrentValue(4L);
        this.doTest(props);
    }

    @Test
    public void testReserveWithZero() throws Exception {
        UDFTestProperties props = new UDFTestProperties(0L);
        props.setExceptionExpected(true);
        props.setExceptionClass(IllegalArgumentException.class);
        props.setErrorMessage("Number of Sequences to Reserve should be greater than 0");
        this.doTest(props);
    }

    @Test
    public void testReserveWithNegativeNumber() throws Exception {
        UDFTestProperties props = new UDFTestProperties(-1L);
        props.setExceptionExpected(true);
        props.setExceptionClass(IllegalArgumentException.class);
        props.setErrorMessage("Number of Sequences to Reserve should be greater than 0");
        this.doTest(props);
    }

    @Test
    public void testReserveMaxLimit() throws Exception {
        UDFTestProperties props = new UDFTestProperties(10L);
        props.setExceptionExpected(true);
        props.setExceptionClass(IOException.class);
        props.setErrorMessage("Reached MAXVALUE of sequence");
        this.doTest(props);
    }

    @Test
    public void testNoSequenceName() throws Exception {
        UDFTestProperties props = new UDFTestProperties(1L);
        props.setExceptionExpected(true);
        props.setSequenceName(null);
        props.setExceptionClass(NullPointerException.class);
        props.setErrorMessage("Sequence name should be not null");
        this.doTest(props);
    }

    @Test
    public void testSequenceNotExisting() throws Exception {
        UDFTestProperties props = new UDFTestProperties(1L);
        props.setExceptionExpected(true);
        props.setSequenceName("foo.bar");
        props.setExceptionClass(IOException.class);
        props.setErrorMessage("Sequence undefined");
        this.doTest(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTenantSequence() throws Exception {
        Properties tentantProps = new Properties();
        String tenantId = "TENANT";
        tentantProps.put("TenantId", tenantId);
        Connection tenantConn = DriverManager.getConnection(ReserveNSequenceTestIT.getUrl(), tentantProps);
        this.createSequence(tenantConn);
        try {
            UDFTestProperties props = new UDFTestProperties(3L);
            this.doTest(tenantConn, props);
            Assert.assertEquals((long)1L, (long)this.getNextSequenceValue(this.conn));
        }
        finally {
            this.dropSequence(tenantConn);
        }
    }

    @Test
    public void testMultipleTuples() throws Exception {
        Tuple tuple = this.tupleFactory.newTuple(2);
        tuple.set(0, (Object)2L);
        tuple.set(1, (Object)SEQUENCE_NAME);
        String tentantId = this.conn.getClientInfo("TenantId");
        ReserveNSequence udf = new ReserveNSequence(this.zkQuorum, tentantId);
        for (int i = 0; i < 2; ++i) {
            udf.exec(tuple);
        }
        long nextValue = this.getNextSequenceValue(this.conn);
        Assert.assertEquals((long)5L, (long)nextValue);
    }

    private void doTest(UDFTestProperties props) throws Exception {
        this.doTest(this.conn, props);
    }

    private void doTest(Connection conn, UDFTestProperties props) throws Exception {
        this.setCurrentValue(conn, props.getCurrentValue());
        Tuple tuple = this.tupleFactory.newTuple(3);
        tuple.set(0, (Object)props.getNumToReserve());
        tuple.set(1, (Object)props.getSequenceName());
        tuple.set(2, (Object)this.zkQuorum);
        Long result = null;
        try {
            String tenantId = conn.getClientInfo("TenantId");
            ReserveNSequence udf = new ReserveNSequence(this.zkQuorum, tenantId);
            result = udf.exec(tuple);
            this.validateReservedSequence(conn, props.getCurrentValue(), props.getNumToReserve(), result);
            udf.finish();
        }
        catch (Exception e) {
            if (props.isExceptionExpected()) {
                Assert.assertEquals((Object)props.getExceptionClass(), e.getClass());
                e.getMessage().contains(props.getErrorMessage());
            }
            throw e;
        }
    }

    private void createUdfContext() {
        udfContext = UDFContext.getUDFContext();
        udfContext.addJobConf(this.conf);
    }

    private void validateReservedSequence(Connection conn, Long currentValue, long count, Long result) throws SQLException {
        Long startIndex = currentValue + 1L;
        Assert.assertEquals((String)"Start index is incorrect", (Object)startIndex, (Object)result);
        long newNextSequenceValue = this.getNextSequenceValue(conn);
        Assert.assertEquals((long)(startIndex + count), (long)newNextSequenceValue);
    }

    private void createSequence(Connection conn) throws SQLException {
        conn.createStatement().execute(String.format(CREATE_SEQUENCE_SYNTAX, SEQUENCE_NAME, 1, 1, 1, 10L, 1));
        conn.commit();
    }

    private void setCurrentValue(Connection conn, long currentValue) throws SQLException {
        int i = 1;
        while ((long)i <= currentValue) {
            this.getNextSequenceValue(conn);
            ++i;
        }
    }

    private long getNextSequenceValue(Connection conn) throws SQLException {
        String ddl = "SELECT NEXT VALUE FOR " + SEQUENCE_NAME;
        ResultSet rs = conn.createStatement().executeQuery(ddl);
        Assert.assertTrue((boolean)rs.next());
        conn.commit();
        return rs.getLong(1);
    }

    private void dropSequence(Connection conn) throws Exception {
        String ddl = "DROP SEQUENCE " + SEQUENCE_NAME;
        conn.createStatement().execute(ddl);
        conn.commit();
    }

    private static class UDFTestProperties {
        private final Long numToReserve;
        private Long currentValue = 1L;
        private String sequenceName = "my_schema.my_sequence";
        private boolean exceptionExpected = false;
        private Class exceptionClass = null;
        private String errorMessage = null;

        public UDFTestProperties(long numToReserve) {
            this.numToReserve = numToReserve;
        }

        public Long getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(long currentValue) {
            this.currentValue = currentValue;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public boolean isExceptionExpected() {
            return this.exceptionExpected;
        }

        public void setExceptionExpected(boolean shouldThrowException) {
            this.exceptionExpected = shouldThrowException;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Long getNumToReserve() {
            return this.numToReserve;
        }

        public Class getExceptionClass() {
            return this.exceptionClass;
        }

        public void setExceptionClass(Class exceptionClass) {
            this.exceptionClass = exceptionClass;
        }
    }
}

