/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.pig.BasePigIT;
import org.apache.phoenix.pig.PhoenixHBaseStorage;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixHBaseStorerIT
extends BasePigIT {
    @Test
    public void testStorer() throws Exception {
        String tableName = "TABLE1";
        Statement stmt = this.conn.createStatement();
        stmt.execute("CREATE TABLE TABLE1 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR)");
        Storage.Data data = Storage.resetData((PigServer)this.pigServer);
        ArrayList list = Lists.newArrayList();
        int rows = 100;
        for (int i = 0; i < rows; ++i) {
            Tuple t = this.tupleFactory.newTuple();
            t.append((Object)i);
            t.append((Object)("a" + i));
            list.add(t);
        }
        data.set("in", "id:int, name:chararray", (Collection)list);
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        this.pigServer.registerQuery("Store A into 'hbase://TABLE1' using " + PhoenixHBaseStorage.class.getName() + "('" + this.zkQuorum + "', '-batchSize 1000');");
        if (((ExecJob)this.pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)this.pigServer.executeBatch().get(0)).getException());
        }
        ResultSet rs = stmt.executeQuery("SELECT id, name FROM table1 ORDER BY id");
        for (int i = 0; i < rows; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)i, (long)rs.getInt(1));
            Assert.assertEquals((Object)("a" + i), (Object)rs.getString(2));
        }
    }

    @Test
    public void testStorerForSpecificColumns() throws Exception {
        String tableName = SchemaUtil.getTableName((String)"TABLE2", (String)SchemaUtil.getEscapedArgument((String)"zo2"));
        Statement stmt = this.conn.createStatement();
        stmt.execute("CREATE TABLE " + tableName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, AGE INTEGER)");
        Storage.Data data = Storage.resetData((PigServer)this.pigServer);
        ArrayList list = Lists.newArrayList();
        int rows = 100;
        for (int i = 0; i < rows; ++i) {
            Tuple t = this.tupleFactory.newTuple();
            t.append((Object)i);
            t.append((Object)("a" + i));
            t.append((Object)(i * 2));
            list.add(t);
        }
        data.set("in", "id:int, name:chararray,age:int", (Collection)list);
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        this.pigServer.registerQuery("B = FOREACH A GENERATE id,name;");
        this.pigServer.registerQuery("Store B into 'hbase://" + tableName + "/ID,NAME' using " + PhoenixHBaseStorage.class.getName() + "('" + this.zkQuorum + "', '-batchSize 1000');");
        if (((ExecJob)this.pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)this.pigServer.executeBatch().get(0)).getException());
        }
        ResultSet rs = stmt.executeQuery("SELECT id, name,age FROM " + tableName + " ORDER BY id");
        for (int i = 0; i < rows; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)i, (long)rs.getInt(1));
            Assert.assertEquals((Object)("a" + i), (Object)rs.getString(2));
            Assert.assertEquals((long)0L, (long)rs.getInt(3));
        }
    }

    @Test
    public void testStoreWithBinaryDataTypes() throws Exception {
        String tableName = "TABLE3";
        Statement stmt = this.conn.createStatement();
        stmt.execute("CREATE TABLE TABLE3 (col1 BIGINT NOT NULL, col2 INTEGER , col3 FLOAT, col4 DOUBLE , col5 TINYINT ,   col6 BOOLEAN , col7 VARBINARY CONSTRAINT my_pk PRIMARY KEY (col1))");
        Storage.Data data = Storage.resetData((PigServer)this.pigServer);
        ArrayList list = Lists.newArrayList();
        int rows = 10;
        for (int i = 1; i <= rows; ++i) {
            Tuple t = this.tupleFactory.newTuple();
            t.append((Object)i);
            t.append((Object)new DataByteArray(Bytes.toBytes((int)(i * 5))));
            t.append((Object)new DataByteArray(Bytes.toBytes((float)((float)i * 10.0f))));
            t.append((Object)new DataByteArray(Bytes.toBytes((double)((double)i * 15.0))));
            t.append((Object)new DataByteArray(Bytes.toBytes((int)i)));
            t.append((Object)new DataByteArray(Bytes.toBytes((i % 2 == 0 ? 1 : 0) != 0)));
            t.append((Object)new DataByteArray(Bytes.toBytes((int)i)));
            list.add(t);
        }
        data.set("in", "col1:int,col2:bytearray,col3:bytearray,col4:bytearray,col5:bytearray,col6:bytearray,col7:bytearray ", (Collection)list);
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        this.pigServer.registerQuery("Store A into 'hbase://TABLE3' using " + PhoenixHBaseStorage.class.getName() + "('" + this.zkQuorum + "', '-batchSize 1000');");
        if (((ExecJob)this.pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)this.pigServer.executeBatch().get(0)).getException());
        }
        ResultSet rs = stmt.executeQuery(String.format("SELECT col1 , col2 , col3 , col4 , col5 , col6, col7  FROM %s ORDER BY col1", "TABLE3"));
        int count = 0;
        for (int i = 1; i <= rows; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)i, (long)rs.getInt(1));
            Assert.assertEquals((long)(i * 5), (long)rs.getInt(2));
            Assert.assertEquals((double)((float)i * 10.0f), (double)rs.getFloat(3), (double)0.0);
            Assert.assertEquals((double)((double)i * 15.0), (double)rs.getInt(4), (double)0.0);
            Assert.assertEquals((long)i, (long)rs.getInt(5));
            Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)rs.getBoolean(6));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])rs.getBytes(7));
            ++count;
        }
        Assert.assertEquals((long)rows, (long)count);
    }

    @Test
    public void testStoreWithDateTime() throws Exception {
        String tableName = "TABLE4";
        Statement stmt = this.conn.createStatement();
        stmt.execute("CREATE TABLE TABLE4 (col1 BIGINT NOT NULL, col2 DATE , col3 TIME,  col4 TIMESTAMP CONSTRAINT my_pk PRIMARY KEY (col1))");
        long now = System.currentTimeMillis();
        DateTime dt = new DateTime(now);
        Storage.Data data = Storage.resetData((PigServer)this.pigServer);
        ArrayList list = Lists.newArrayList();
        Tuple t = this.tupleFactory.newTuple();
        t.append((Object)1);
        t.append((Object)dt);
        t.append((Object)dt);
        t.append((Object)dt);
        list.add(t);
        data.set("in", "col1:int,col2:datetime,col3:datetime,col4:datetime", (Collection)list);
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        this.pigServer.registerQuery("Store A into 'hbase://TABLE4' using " + PhoenixHBaseStorage.class.getName() + "('" + this.zkQuorum + "', '-batchSize 1000');");
        if (((ExecJob)this.pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)this.pigServer.executeBatch().get(0)).getException());
        }
        ResultSet rs = stmt.executeQuery(String.format("SELECT col1 , col2 , col3 , col4 FROM %s ", "TABLE4"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)now, (long)rs.getDate(2).getTime());
        Assert.assertEquals((long)now, (long)rs.getTime(3).getTime());
        Assert.assertEquals((long)now, (long)rs.getTimestamp(4).getTime());
    }

    @Test
    public void testStoreForArray() throws Exception {
        String tableName = "TABLE5";
        Statement stmt = this.conn.createStatement();
        String ddl = "CREATE TABLE  TABLE5 ( ID INTEGER PRIMARY KEY, dbl double array[], a_varchar_array varchar array)";
        stmt.execute(ddl);
        Storage.Data data = Storage.resetData((PigServer)this.pigServer);
        data.set("in", new Tuple[]{Storage.tuple((Object[])new Object[]{1, Storage.tuple((Object[])new Object[]{2.2})}), Storage.tuple((Object[])new Object[]{2, Storage.tuple((Object[])new Object[]{2.4, 2.5})}), Storage.tuple((Object[])new Object[]{3, Storage.tuple((Object[])new Object[]{2.3})})});
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("A = LOAD 'in' USING mock.Storage() as (id:int, dbl:tuple());");
        this.pigServer.registerQuery("Store A into 'hbase://TABLE5/ID,DBL' using " + PhoenixHBaseStorage.class.getName() + "('" + this.zkQuorum + "', '-batchSize 1000');");
        if (((ExecJob)this.pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)this.pigServer.executeBatch().get(0)).getException());
        }
        ResultSet rs = stmt.executeQuery(String.format("SELECT id , dbl FROM %s where id = 2", "TABLE5"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Array expectedDoubleArr = this.conn.createArrayOf("DOUBLE", new Double[]{2.4, 2.5});
        Assert.assertEquals((Object)expectedDoubleArr, (Object)rs.getArray(2));
    }
}

