/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.BaseHBaseManagedTimeIT;
import org.apache.phoenix.end2end.Shadower;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.TupleFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class BasePigIT
extends BaseHBaseManagedTimeIT {
    protected TupleFactory tupleFactory;
    protected String zkQuorum;
    protected Connection conn;
    protected Configuration conf;
    protected PigServer pigServer;

    @BeforeClass
    @Shadower(classBeingShadowed=BaseHBaseManagedTimeIT.class)
    public static void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.jdbc.extra.arguments", "");
        BasePigIT.setUpTestDriver((ReadOnlyProps)new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void setUp() throws Exception {
        this.conf = BasePigIT.getTestClusterConfig();
        this.conf.set("phoenix.jdbc.extra.arguments", "");
        this.conf.set("CurrentSCN", Long.toString(System.currentTimeMillis() + 86400000L));
        this.pigServer = new PigServer(ExecType.LOCAL, this.conf);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(BasePigIT.getUrl(), props);
        this.zkQuorum = "localhost:" + BasePigIT.getZKClientPort((Configuration)this.conf);
        this.tupleFactory = TupleFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.pigServer != null) {
            this.pigServer.shutdown();
        }
    }
}

