/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.hive.util.PhoenixConnectionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixUtil.class);

    public static String getPhoenixType(String hiveTypeName) {
        if (hiveTypeName.startsWith("array")) {
            ArrayList<String> tokenList = new ArrayList<String>(Arrays.asList(hiveTypeName.split("[<>]")));
            return PhoenixUtil.getPhoenixType((String)tokenList.get(1)) + "[]";
        }
        if (hiveTypeName.startsWith("int")) {
            return "integer";
        }
        if (hiveTypeName.equals("string")) {
            return "varchar";
        }
        return hiveTypeName;
    }

    public static boolean existTable(Connection conn, String tableName) throws SQLException {
        boolean exist = false;
        DatabaseMetaData dbMeta = conn.getMetaData();
        String[] schemaInfo = PhoenixUtil.getTableSchema(tableName.toUpperCase());
        try (ResultSet rs = dbMeta.getTables(null, schemaInfo[0], schemaInfo[1], null);){
            exist = rs.next();
            if (LOG.isDebugEnabled()) {
                if (exist) {
                    LOG.debug(rs.getString("TABLE_NAME") + " table exist. ");
                } else {
                    LOG.debug("table " + tableName + " doesn't exist.");
                }
            }
        }
        return exist;
    }

    public static List<String> getPrimaryKeyColumnList(Connection conn, String tableName) throws SQLException {
        HashMap<Short, String> primaryKeyColumnInfoMap = new HashMap<Short, String>();
        DatabaseMetaData dbMeta = conn.getMetaData();
        String[] schemaInfo = PhoenixUtil.getTableSchema(tableName.toUpperCase());
        try (ResultSet rs = dbMeta.getPrimaryKeys(null, schemaInfo[0], schemaInfo[1]);){
            while (rs.next()) {
                primaryKeyColumnInfoMap.put(rs.getShort("KEY_SEQ"), rs.getString("COLUMN_NAME"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("PK-columns : " + primaryKeyColumnInfoMap);
            }
        }
        return new ArrayList<String>(primaryKeyColumnInfoMap.values());
    }

    public static List<String> getPrimaryKeyColumnList(Configuration config, String tableName) {
        List<String> pkColumnNameList = null;
        try (Connection conn = PhoenixConnectionUtil.getInputConnection(config, new Properties());){
            pkColumnNameList = PhoenixUtil.getPrimaryKeyColumnList(conn, tableName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return pkColumnNameList;
    }

    public static void createTable(Connection conn, String createTableStatement) throws SQLException {
        conn.createStatement().execute(createTableStatement);
    }

    public static void dropTable(Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("drop table " + tableName);
    }

    public static List<ColumnInfo> getColumnInfoList(Connection conn, String tableName) throws SQLException {
        List columnInfoList = null;
        try {
            columnInfoList = PhoenixRuntime.generateColumnInfo((Connection)conn, (String)tableName, null);
        }
        catch (TableNotFoundException e) {
            columnInfoList = Collections.emptyList();
        }
        return columnInfoList;
    }

    public static String[] getTableSchema(String tableName) {
        String[] schemaInfo = new String[2];
        String[] tokens = tableName.split("\\.");
        if (tokens.length == 2) {
            schemaInfo = tokens;
        } else {
            schemaInfo[1] = tokens[0];
        }
        return schemaInfo;
    }

    public static boolean isDisabledWal(MetaDataClient metaDataClient, String tableName) throws SQLException {
        String[] schemaInfo = PhoenixUtil.getTableSchema(tableName.toUpperCase());
        MetaDataProtocol.MetaDataMutationResult result = metaDataClient.updateCache(schemaInfo[0], schemaInfo[1]);
        PTable dataTable = result.getTable();
        return dataTable.isWALDisabled();
    }

    public static void alterTableForWalDisable(Connection conn, String tableName, boolean disableMode) throws SQLException {
        conn.createStatement().execute("alter table " + tableName + " set disable_wal=" + disableMode);
    }

    public static void flush(Connection conn, String tableName) throws SQLException {
        try (HBaseAdmin admin = ((PhoenixConnection)conn).getQueryServices().getAdmin();){
            admin.flush(TableName.valueOf((String)tableName));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static String constructDeleteStatement(Connection conn, String tableName) throws SQLException {
        StringBuilder deleteQuery = new StringBuilder("delete from ").append(tableName).append(" where ");
        List<String> primaryKeyColumnList = PhoenixUtil.getPrimaryKeyColumnList(conn, tableName);
        int limit = primaryKeyColumnList.size();
        for (int i = 0; i < limit; ++i) {
            String pkColumn = primaryKeyColumnList.get(i);
            deleteQuery.append(pkColumn).append("=").append("?");
            if (i + 1 == primaryKeyColumnList.size()) continue;
            deleteQuery.append(" and ");
        }
        return deleteQuery.toString();
    }

    public static void closeResource(Statement stmt) throws SQLException {
        if (stmt != null && !stmt.isClosed()) {
            stmt.close();
        }
    }

    public static void closeResource(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }
}

