/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMappingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnMappingUtils.class);

    public static Map<String, String> getColumnMappingMap(String columnMappings) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Column mappings : " + columnMappings);
        }
        if (columnMappings == null || columnMappings.length() == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info("phoenix.column.mapping not set. using field definition");
            }
            return Collections.emptyMap();
        }
        HashMap<String, String> columnMappingMap = new HashMap<String, String>();
        for (String item : columnMappings.split(",")) {
            String[] kv = item.trim().split(":");
            columnMappingMap.put(kv[0], kv[1].length() > 1 ? kv[1] : "");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Column mapping map : " + columnMappingMap);
        }
        return columnMappingMap;
    }

    public static Map<String, String> getReverseColumnMapping(String columnMapping) {
        LinkedHashMap<String, String> myNewHashMap = new LinkedHashMap<String, String>();
        Map<String, String> forward = ColumnMappingUtils.getColumnMappingMap(columnMapping);
        for (Map.Entry<String, String> entry : forward.entrySet()) {
            myNewHashMap.put(entry.getValue(), entry.getKey());
        }
        return myNewHashMap;
    }

    public static List<String> quoteColumns(List<String> readColumnList) {
        LinkedList<String> newList = new LinkedList<String>();
        for (String column : readColumnList) {
            newList.add("\"" + column + "\"");
        }
        return newList;
    }
}

