/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.JobConf;
import org.apache.phoenix.hive.constants.PhoenixStorageHandlerConstants;
import org.apache.phoenix.hive.ql.index.IndexSearchCondition;
import org.apache.phoenix.hive.util.ColumnMappingUtils;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.hive.util.PhoenixUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.CharMatcher;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixQueryBuilder.class);
    private static final String QUERY_TEMPLATE = "select $HINT$ $COLUMN_LIST$ from $TABLE_NAME$";
    private static final PhoenixQueryBuilder QUERY_BUILDER = new PhoenixQueryBuilder();
    private static final StrJoiner JOINER_COMMA = new StrJoiner(", ");
    private static final StrJoiner JOINER_AND = new StrJoiner(" and ");
    private static final StrJoiner JOINER_SPACE = new StrJoiner(" ");

    private PhoenixQueryBuilder() {
        if (LOG.isInfoEnabled()) {
            LOG.info("PhoenixQueryBuilder created");
        }
    }

    public static PhoenixQueryBuilder getInstance() {
        return QUERY_BUILDER;
    }

    private void addConditionColumnToReadColumn(List<String> readColumnList, List<String> conditionColumnList) {
        if (readColumnList.isEmpty()) {
            return;
        }
        for (String conditionColumn : conditionColumnList) {
            if (readColumnList.contains(conditionColumn)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Condition column " + conditionColumn + " does not exist in read-columns.");
            }
            readColumnList.add(conditionColumn);
        }
    }

    private String makeQueryString(JobConf jobConf, String tableName, List<String> readColumnList, String whereClause, String queryTemplate, String hints, Map<String, TypeInfo> columnTypeMap) throws IOException {
        StringBuilder sql = new StringBuilder();
        List<String> conditionColumnList = this.buildWhereClause(jobConf, sql, whereClause, columnTypeMap);
        readColumnList = PhoenixQueryBuilder.replaceColumns(jobConf, readColumnList);
        if (conditionColumnList.size() > 0) {
            this.addConditionColumnToReadColumn(readColumnList, conditionColumnList);
            sql.insert(0, queryTemplate.replace("$HINT$", hints).replace("$COLUMN_LIST$", this.getSelectColumns(jobConf, tableName, readColumnList)).replace("$TABLE_NAME$", tableName));
        } else {
            sql.append(queryTemplate.replace("$HINT$", hints).replace("$COLUMN_LIST$", this.getSelectColumns(jobConf, tableName, readColumnList)).replace("$TABLE_NAME$", tableName));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Input query : " + sql.toString());
        }
        return sql.toString();
    }

    private static String findReplacement(JobConf jobConf, String column) {
        Map<String, String> columnMappingMap = ColumnMappingUtils.getColumnMappingMap(jobConf.get("phoenix.column.mapping"));
        if (columnMappingMap != null && columnMappingMap.containsKey(column)) {
            return columnMappingMap.get(column);
        }
        return column;
    }

    private static List<String> replaceColumns(JobConf jobConf, List<String> columnList) {
        Map<String, String> columnMappingMap = ColumnMappingUtils.getColumnMappingMap(jobConf.get("phoenix.column.mapping"));
        if (columnMappingMap != null) {
            ArrayList<String> newList = new ArrayList<String>();
            for (String column : columnList) {
                if (columnMappingMap.containsKey(column)) {
                    newList.add(columnMappingMap.get(column));
                    continue;
                }
                newList.add(column);
            }
            return newList;
        }
        return null;
    }

    private String makeQueryString(JobConf jobConf, String tableName, List<String> readColumnList, List<IndexSearchCondition> searchConditions, String queryTemplate, String hints) throws IOException {
        StringBuilder query = new StringBuilder();
        List<String> conditionColumnList = this.buildWhereClause(jobConf, query, searchConditions);
        if (conditionColumnList.size() > 0) {
            readColumnList = PhoenixQueryBuilder.replaceColumns(jobConf, readColumnList);
            this.addConditionColumnToReadColumn(readColumnList, conditionColumnList);
            query.insert(0, queryTemplate.replace("$HINT$", hints).replace("$COLUMN_LIST$", this.getSelectColumns(jobConf, tableName, readColumnList)).replace("$TABLE_NAME$", tableName));
        } else {
            readColumnList = PhoenixQueryBuilder.replaceColumns(jobConf, readColumnList);
            query.append(queryTemplate.replace("$HINT$", hints).replace("$COLUMN_LIST$", this.getSelectColumns(jobConf, tableName, readColumnList)).replace("$TABLE_NAME$", tableName));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Input query : " + query.toString());
        }
        return query.toString();
    }

    private String getSelectColumns(JobConf jobConf, String tableName, List<String> readColumnList) throws IOException {
        String selectColumns = String.join((CharSequence)",", ColumnMappingUtils.quoteColumns(readColumnList));
        if ("".equals(selectColumns)) {
            selectColumns = "*";
        } else if (PhoenixStorageHandlerUtil.isTransactionalTable((Configuration)jobConf)) {
            List<String> pkColumnList = PhoenixUtil.getPrimaryKeyColumnList((Configuration)jobConf, tableName);
            StringBuilder pkColumns = new StringBuilder();
            for (String pkColumn : pkColumnList) {
                if (readColumnList.contains(pkColumn)) continue;
                pkColumns.append("\"").append(pkColumn).append("\",");
            }
            selectColumns = pkColumns.toString() + selectColumns;
        }
        return selectColumns;
    }

    public String buildQuery(JobConf jobConf, String tableName, List<String> readColumnList, String whereClause, Map<String, TypeInfo> columnTypeMap) throws IOException {
        String hints = this.getHint(jobConf, tableName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building query with columns : " + readColumnList + " table name : " + tableName + "  with where conditions : " + whereClause + "  hints : " + hints);
        }
        return this.makeQueryString(jobConf, tableName, new ArrayList<String>(readColumnList), whereClause, QUERY_TEMPLATE, hints, columnTypeMap);
    }

    public String buildQuery(JobConf jobConf, String tableName, List<String> readColumnList, List<IndexSearchCondition> searchConditions) throws IOException {
        String hints = this.getHint(jobConf, tableName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building query with columns : " + readColumnList + "  table name : " + tableName + " search conditions : " + searchConditions + "  hints : " + hints);
        }
        return this.makeQueryString(jobConf, tableName, new ArrayList<String>(readColumnList), searchConditions, QUERY_TEMPLATE, hints);
    }

    private String getHint(JobConf jobConf, String tableName) {
        String queryHint;
        StringBuilder hints = new StringBuilder("/*+ ");
        if (!jobConf.getBoolean("hbase.scan.cacheblock", Boolean.FALSE.booleanValue())) {
            hints.append("NO_CACHE ");
        }
        if ((queryHint = jobConf.get(tableName + ".query.hint")) != null) {
            hints.append(queryHint);
        }
        hints.append(" */");
        return hints.toString();
    }

    private List<String> buildWhereClause(JobConf jobConf, StringBuilder sql, String whereClause, Map<String, TypeInfo> columnTypeMap) throws IOException {
        if (whereClause == null || whereClause.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> conditionColumnList = new ArrayList<String>();
        sql.append(" where ");
        whereClause = StringUtils.replaceEach((String)whereClause, (String[])new String[]{"UDFToString"}, (String[])new String[]{"to_char"});
        for (String columnName : columnTypeMap.keySet()) {
            if (!whereClause.contains(columnName)) continue;
            String column = PhoenixQueryBuilder.findReplacement(jobConf, columnName);
            whereClause = whereClause.replaceAll("\\b" + columnName + "\\b", "\"" + column + "\"");
            conditionColumnList.add(column);
            if ("date".equals(columnTypeMap.get(columnName).getTypeName())) {
                whereClause = this.applyDateFunctionUsingRegex(whereClause, column);
                continue;
            }
            if (!"timestamp".equals(columnTypeMap.get(columnName).getTypeName())) continue;
            whereClause = this.applyTimestampFunctionUsingRegex(whereClause, column);
        }
        sql.append(whereClause);
        return conditionColumnList;
    }

    private String applyDateFunctionUsingRegex(String whereClause, String columnName) {
        whereClause = this.applyFunctionForCommonOperator(whereClause, columnName, true);
        whereClause = this.applyFunctionForBetweenOperator(whereClause, columnName, true);
        whereClause = this.applyFunctionForInOperator(whereClause, columnName, true);
        return whereClause;
    }

    private String applyTimestampFunctionUsingRegex(String whereClause, String columnName) {
        whereClause = this.applyFunctionForCommonOperator(whereClause, columnName, false);
        whereClause = this.applyFunctionForBetweenOperator(whereClause, columnName, false);
        whereClause = this.applyFunctionForInOperator(whereClause, columnName, false);
        return whereClause;
    }

    private String applyFunctionForCommonOperator(String whereClause, String columnName, boolean isDate) {
        String targetPattern = isDate ? "'?\\d{4}-\\d{2}-\\d{2}'?" : "'?\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.?\\d{0,9}'?";
        String pattern = StringUtils.replaceEach((String)"(\\(?\"?$columnName$\"?\\)?\\s*(=|>|<|<=|>=)\\s*($targetPattern$))", (String[])new String[]{"$columnName$", "$targetPattern$"}, (String[])new String[]{columnName, targetPattern});
        Matcher matcher = Pattern.compile(pattern).matcher(whereClause);
        while (matcher.find()) {
            String token = matcher.group(1);
            String datePart = matcher.group(3);
            String convertString = token.replace(datePart, this.applyFunction(isDate ? "to_date($value$)" : "TIMESTAMP$value$", datePart));
            whereClause = whereClause.replaceAll(StringUtils.replaceEach((String)token, (String[])new String[]{"(", ")"}, (String[])new String[]{"\\(", "\\)"}), convertString);
        }
        return whereClause;
    }

    private String applyFunctionForBetweenOperator(String whereClause, String columnName, boolean isDate) {
        String targetPattern = isDate ? "'?\\d{4}-\\d{2}-\\d{2}'?" : "'?\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.?\\d{0,9}'?";
        String pattern = StringUtils.replaceEach((String)"(\\(?\"?$columnName$\"?\\)?\\s*((?i)not)?\\s*(?i)between\\s*($targetPattern$)\\s*(?i)and\\s*($targetPattern$))", (String[])new String[]{"$columnName$", "$targetPattern$"}, (String[])new String[]{columnName, targetPattern});
        Matcher matcher = Pattern.compile(pattern).matcher(whereClause);
        while (matcher.find()) {
            String token = matcher.group(1);
            boolean isNot = matcher.group(2) != null;
            String fromDate = matcher.group(3);
            String toDate = matcher.group(4);
            String convertString = StringUtils.replaceEach((String)token, (String[])new String[]{fromDate, toDate}, (String[])new String[]{this.applyFunction(isDate ? "to_date($value$)" : "TIMESTAMP$value$", fromDate), this.applyFunction(isDate ? "to_date($value$)" : "TIMESTAMP$value$", toDate)});
            whereClause = whereClause.replaceAll(pattern, convertString);
        }
        return whereClause;
    }

    private String applyFunctionForInOperator(String whereClause, String columnName, boolean isDate) {
        String targetPattern = isDate ? "'?\\d{4}-\\d{2}-\\d{2}'?" : "'?\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.?\\d{0,9}'?";
        String pattern = StringUtils.replaceEach((String)"(\\(?\"?$columnName$\"?\\)?\\s*((?i)not)?\\s*(?i)in\\s*\\(($targetPattern$,?\\s*)+\\))", (String[])new String[]{"$columnName$", "$targetPattern$"}, (String[])new String[]{columnName, targetPattern});
        String itemPattern = "(" + targetPattern + ")";
        Matcher matcher = Pattern.compile(pattern).matcher(whereClause);
        while (matcher.find()) {
            String token = matcher.group(1);
            Matcher itemMatcher = Pattern.compile(itemPattern).matcher(token);
            while (itemMatcher.find()) {
                String item = itemMatcher.group(1);
                token = token.replace(item, this.applyFunction(isDate ? "to_date($value$)" : "TIMESTAMP$value$", item));
            }
            whereClause = whereClause.replaceAll(pattern, token);
        }
        return whereClause;
    }

    private String applyFunction(String pattern, String value) {
        if (!value.startsWith("'")) {
            value = "'" + value + "'";
        }
        return pattern.replace("$value$", value);
    }

    private String getCompareValueForDateAndTimestampFunction(String compareValue) {
        if (compareValue.startsWith("'")) {
            return compareValue;
        }
        return "'" + compareValue + "'";
    }

    private String applyDateFunction(String whereClause, String columnName) {
        StringBuilder whereCondition = new StringBuilder();
        Iterator iterator = Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings().split((CharSequence)whereClause).iterator();
        while (iterator.hasNext()) {
            String token = (String)iterator.next();
            if (this.isMyCondition(columnName, token)) {
                int rightBracketIndex;
                whereCondition.append(token);
                String comparator = (String)iterator.next();
                whereCondition.append(" ");
                whereCondition.append(comparator).append(" ");
                if ("between".equalsIgnoreCase(comparator)) {
                    whereCondition.append("to_date(").append(this.getCompareValueForDateAndTimestampFunction((String)iterator.next())).append(") ").append((String)iterator.next()).append(" ").append("to_date(");
                    String toCompareValue = (String)iterator.next();
                    if (toCompareValue.endsWith(")")) {
                        rightBracketIndex = toCompareValue.indexOf(")");
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(toCompareValue.substring(0, rightBracketIndex))).append(")").append(toCompareValue.substring(rightBracketIndex));
                    } else {
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(toCompareValue)).append(")");
                    }
                } else if ("in".equalsIgnoreCase(comparator)) {
                    while (iterator.hasNext()) {
                        String aToken = (String)iterator.next();
                        if (aToken.equals("(") || aToken.equals(",")) {
                            whereCondition.append(aToken);
                        } else {
                            int bracketIndex;
                            if (aToken.equals(")")) {
                                whereCondition.append(aToken);
                                break;
                            }
                            if (aToken.endsWith(")")) {
                                bracketIndex = aToken.indexOf(")");
                                whereCondition.append("to_date(").append(this.getCompareValueForDateAndTimestampFunction(aToken.substring(0, bracketIndex))).append(")").append(aToken.substring(bracketIndex));
                                break;
                            }
                            if (aToken.endsWith(",")) {
                                if (aToken.startsWith("(")) {
                                    bracketIndex = aToken.lastIndexOf("(");
                                    whereCondition.append(aToken.substring(0, bracketIndex + 1)).append("to_date(").append(this.getCompareValueForDateAndTimestampFunction(aToken.substring(bracketIndex + 1, aToken.length() - 1))).append("),");
                                } else {
                                    whereCondition.append("to_date(").append(this.getCompareValueForDateAndTimestampFunction(aToken.substring(0, aToken.length() - 1))).append("),");
                                }
                            }
                        }
                        whereCondition.append(" ");
                    }
                } else if (PhoenixStorageHandlerConstants.COMMON_COMPARATOR.contains(comparator)) {
                    String compareValue = this.getCompareValueForDateAndTimestampFunction((String)iterator.next());
                    whereCondition.append("to_date(");
                    if (compareValue.endsWith(")")) {
                        rightBracketIndex = compareValue.indexOf(")");
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(0, rightBracketIndex))).append(")").append(compareValue.substring(rightBracketIndex));
                    } else {
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(compareValue)).append(")");
                    }
                }
            } else {
                whereCondition.append(token);
            }
            whereCondition.append(" ");
        }
        return whereCondition.toString();
    }

    private String applyTimestampFunction(String whereClause, String columnName) {
        StringBuilder whereCondition = new StringBuilder();
        Iterator iterator = Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings().split((CharSequence)whereClause).iterator();
        while (iterator.hasNext()) {
            String token = (String)iterator.next();
            if (this.isMyCondition(columnName, token)) {
                int rightBracketIndex;
                whereCondition.append(token);
                String comparator = (String)iterator.next();
                whereCondition.append(" ");
                whereCondition.append(comparator).append(" ");
                if ("between".equalsIgnoreCase(comparator)) {
                    String fromCompareValue = (String)iterator.next() + " " + (String)iterator.next();
                    whereCondition.append("to_timestamp(").append(this.getCompareValueForDateAndTimestampFunction(fromCompareValue)).append(")");
                    whereCondition.append(" ").append((String)iterator.next()).append(" ");
                    whereCondition.append("to_timestamp(");
                    String toCompareValue = (String)iterator.next() + " " + (String)iterator.next();
                    if (toCompareValue.endsWith(")")) {
                        rightBracketIndex = toCompareValue.indexOf(")");
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(toCompareValue.substring(0, rightBracketIndex))).append(")").append(toCompareValue.substring(rightBracketIndex));
                    } else {
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(toCompareValue)).append(")");
                    }
                } else if ("in".equalsIgnoreCase(comparator)) {
                    while (iterator.hasNext()) {
                        String aToken = (String)iterator.next();
                        if (aToken.equals("(") || aToken.equals(",")) {
                            whereCondition.append(aToken);
                        } else {
                            if (aToken.equals(")")) {
                                whereCondition.append(aToken);
                                break;
                            }
                            String compareValue = aToken + " " + (String)iterator.next();
                            if (compareValue.startsWith("(")) {
                                int leftBracketIndex = compareValue.lastIndexOf("(");
                                whereCondition.append(compareValue.substring(0, leftBracketIndex + 1)).append("to_timestamp(");
                                if (compareValue.endsWith(")")) {
                                    int rightBracketIndex2 = compareValue.indexOf(")");
                                    whereCondition.append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(leftBracketIndex + 1, rightBracketIndex2))).append(")").append(compareValue.substring(rightBracketIndex2));
                                } else if (compareValue.endsWith(",")) {
                                    whereCondition.append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(leftBracketIndex + 1, compareValue.length() - 1))).append(")").append(",");
                                } else {
                                    whereCondition.append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(leftBracketIndex + 1))).append(")");
                                }
                            } else {
                                if (compareValue.endsWith(")")) {
                                    rightBracketIndex = compareValue.indexOf(")");
                                    whereCondition.append("to_timestamp(").append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(0, rightBracketIndex))).append(")").append(compareValue.substring(rightBracketIndex));
                                    break;
                                }
                                if (compareValue.endsWith(",")) {
                                    whereCondition.append("to_timestamp(").append(this.getCompareValueForDateAndTimestampFunction(compareValue.substring(0, compareValue.length() - 1))).append("),");
                                }
                            }
                        }
                        whereCondition.append(" ");
                    }
                } else if (PhoenixStorageHandlerConstants.COMMON_COMPARATOR.contains(comparator)) {
                    String timestampValue = (String)iterator.next() + " " + (String)iterator.next();
                    whereCondition.append("to_timestamp(");
                    if (timestampValue.endsWith(")")) {
                        int rightBracketIndex3 = timestampValue.indexOf(")");
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(timestampValue.substring(0, rightBracketIndex3))).append(")").append(timestampValue.substring(rightBracketIndex3));
                    } else {
                        whereCondition.append(this.getCompareValueForDateAndTimestampFunction(timestampValue)).append(")");
                    }
                }
            } else {
                whereCondition.append(token);
            }
            whereCondition.append(" ");
        }
        return whereCondition.toString();
    }

    private boolean isMyCondition(String columnName, String token) {
        boolean itsMine = false;
        if (columnName.equals(token)) {
            itsMine = true;
        } else if (token.startsWith("(") && token.substring(token.lastIndexOf("(") + 1).equals(columnName)) {
            itsMine = true;
        } else if (token.startsWith("(") && token.endsWith(")") && token.substring(token.lastIndexOf("(") + 1, token.indexOf(")")).equals(columnName)) {
            itsMine = true;
        }
        return itsMine;
    }

    protected List<String> buildWhereClause(JobConf jobConf, StringBuilder sql, List<IndexSearchCondition> conditions) throws IOException {
        if (conditions == null || conditions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> columns = new ArrayList<String>();
        sql.append(" where ");
        Iterator<IndexSearchCondition> iter = conditions.iterator();
        this.appendExpression(jobConf, sql, iter.next(), columns);
        while (iter.hasNext()) {
            sql.append(" and ");
            this.appendExpression(jobConf, sql, iter.next(), columns);
        }
        return columns;
    }

    private void appendExpression(JobConf jobConf, StringBuilder sql, IndexSearchCondition condition, List<String> columns) {
        Expression expr = this.findExpression(condition);
        if (expr != null) {
            sql.append(expr.buildExpressionStringFrom(jobConf, condition));
            String column = condition.getColumnDesc().getColumn();
            String rColumn = PhoenixQueryBuilder.findReplacement(jobConf, column);
            if (rColumn != null) {
                column = rColumn;
            }
            columns.add(column);
        }
    }

    private Expression findExpression(IndexSearchCondition condition) {
        for (Expression exp : Expression.values()) {
            if (!exp.isFor(condition)) continue;
            return exp;
        }
        return null;
    }

    static /* synthetic */ StrJoiner access$000() {
        return JOINER_AND;
    }

    static /* synthetic */ StrJoiner access$200() {
        return JOINER_COMMA;
    }

    private static enum Expression {
        EQUAL("UDFOPEqual", "="),
        GREATER_THAN_OR_EQUAL_TO("UDFOPEqualOrGreaterThan", ">="),
        GREATER_THAN("UDFOPGreaterThan", ">"),
        LESS_THAN_OR_EQUAL_TO("UDFOPEqualOrLessThan", "<="),
        LESS_THAN("UDFOPLessThan", "<"),
        NOT_EQUAL("UDFOPNotEqual", "!="),
        BETWEEN("GenericUDFBetween", "between", PhoenixQueryBuilder.access$000(), true){

            @Override
            public boolean checkCondition(IndexSearchCondition condition) {
                return condition.getConstantDescs() != null;
            }
        }
        ,
        IN("GenericUDFIn", "in", PhoenixQueryBuilder.access$200(), true){

            @Override
            public boolean checkCondition(IndexSearchCondition condition) {
                return condition.getConstantDescs() != null;
            }

            @Override
            public String createConstants(String typeName, ExprNodeConstantDesc[] desc) {
                return "(" + super.createConstants(typeName, desc) + ")";
            }
        }
        ,
        IS_NULL("GenericUDFOPNull", "is null"){

            @Override
            public boolean checkCondition(IndexSearchCondition condition) {
                return true;
            }
        }
        ,
        IS_NOT_NULL("GenericUDFOPNotNull", "is not null"){

            @Override
            public boolean checkCondition(IndexSearchCondition condition) {
                return true;
            }
        };

        private final String hiveCompOp;
        private final String sqlCompOp;
        private final StrJoiner joiner;
        private final boolean supportNotOperator;
        private static final String SINGLE_QUOTATION = "'";
        private static List<ConstantStringWrapper> WRAPPERS;

        private Expression(String hiveCompOp, String sqlCompOp) {
            this(hiveCompOp, sqlCompOp, null, null);
        }

        private Expression(String hiveCompOp, String sqlCompOp, StrJoiner joiner, String joiner2) {
            this(hiveCompOp, sqlCompOp, joiner, false);
        }

        private Expression(String hiveCompOp, String sqlCompOp, StrJoiner joiner, boolean supportNotOp) {
            this.hiveCompOp = hiveCompOp;
            this.sqlCompOp = sqlCompOp;
            this.joiner = joiner;
            this.supportNotOperator = supportNotOp;
        }

        public boolean checkCondition(IndexSearchCondition condition) {
            return condition.getConstantDesc().getValue() != null;
        }

        public boolean isFor(IndexSearchCondition condition) {
            return condition.getComparisonOp().endsWith(this.hiveCompOp) && this.checkCondition(condition);
        }

        public String buildExpressionStringFrom(JobConf jobConf, IndexSearchCondition condition) {
            String type = condition.getColumnDesc().getTypeString();
            String column = condition.getColumnDesc().getColumn();
            String rColumn = PhoenixQueryBuilder.findReplacement(jobConf, column);
            if (rColumn != null) {
                column = rColumn;
            }
            return String.join((CharSequence)" ", "\"" + column + "\"", this.getSqlCompOpString(condition), this.joiner != null ? this.createConstants(type, condition.getConstantDescs()) : this.createConstant(type, condition.getConstantDesc()));
        }

        public String getSqlCompOpString(IndexSearchCondition condition) {
            return this.supportNotOperator ? (condition.isNot() ? "not " : "") + this.sqlCompOp : this.sqlCompOp;
        }

        public String createConstant(String typeName, ExprNodeConstantDesc constantDesc) {
            if (constantDesc == null) {
                return "";
            }
            return this.createConstantString(typeName, String.valueOf(constantDesc.getValue()));
        }

        public String createConstants(String typeName, ExprNodeConstantDesc[] constantDesc) {
            if (constantDesc == null) {
                return "";
            }
            ArrayList<String> constants = new ArrayList<String>();
            for (ExprNodeConstantDesc s : constantDesc) {
                constants.add(this.createConstantString(typeName, String.valueOf(s.getValue())));
            }
            return this.joiner.join(constants);
        }

        private String createConstantString(String typeName, String value) {
            for (ConstantStringWrapper wrapper : WRAPPERS) {
                value = wrapper.apply(typeName, value);
            }
            return value;
        }

        static {
            WRAPPERS = new ArrayList<ConstantStringWrapper>(Arrays.asList(new ConstantStringWrapper(new ArrayList<String>(Arrays.asList("string", "char", "varchar", "date", "timestamp")), SINGLE_QUOTATION, SINGLE_QUOTATION), new ConstantStringWrapper("date", "to_date(", ")"), new ConstantStringWrapper("timestamp", "to_timestamp(", ")")));
        }

        private static class ConstantStringWrapper {
            private List<String> types;
            private String prefix;
            private String postfix;

            ConstantStringWrapper(String type, String prefix, String postfix) {
                this(new ArrayList<String>(Arrays.asList(type)), prefix, postfix);
            }

            ConstantStringWrapper(List<String> types, String prefix, String postfix) {
                this.types = types;
                this.prefix = prefix;
                this.postfix = postfix;
            }

            public String apply(String typeName, String value) {
                boolean hasMatch = false;
                for (String type : this.types) {
                    if (!typeName.startsWith(type)) continue;
                    hasMatch = true;
                    break;
                }
                return hasMatch ? this.prefix + value + this.postfix : value;
            }
        }
    }

    private static class StrJoiner {
        private String delimiter;

        StrJoiner(String delimiter) {
            this.delimiter = delimiter;
        }

        public String join(List<String> list) {
            return String.join((CharSequence)this.delimiter, list);
        }
    }
}

