/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.ppd;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.phoenix.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.phoenix.hive.ql.index.IndexSearchCondition;
import org.apache.phoenix.hive.ql.index.PredicateAnalyzerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixPredicateDecomposer {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixPredicateDecomposer.class);
    private List<String> columnNameList;
    private boolean calledPPD;
    private List<IndexSearchCondition> searchConditionList;

    public static PhoenixPredicateDecomposer create(List<String> columnNameList) {
        return new PhoenixPredicateDecomposer(columnNameList);
    }

    private PhoenixPredicateDecomposer(List<String> columnNameList) {
        this.columnNameList = columnNameList;
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(ExprNodeDesc predicate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("predicate - " + predicate.toString());
        }
        IndexPredicateAnalyzer analyzer = PredicateAnalyzerFactory.createPredicateAnalyzer(this.columnNameList, this.getFieldValidator());
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = new HiveStoragePredicateHandler.DecomposedPredicate();
        ArrayList<IndexSearchCondition> conditions = new ArrayList<IndexSearchCondition>();
        decomposed.residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, conditions);
        if (!conditions.isEmpty()) {
            decomposed.pushedPredicate = analyzer.translateSearchConditions(conditions);
            try {
                this.searchConditionList = conditions;
                this.calledPPD = true;
            }
            catch (Exception e) {
                LOG.warn("Failed to decompose predicates", (Throwable)e);
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("decomposed predicate - residualPredicate: " + decomposed.residualPredicate + ", pushedPredicate: " + decomposed.pushedPredicate);
        }
        return decomposed;
    }

    public List<IndexSearchCondition> getSearchConditionList() {
        return this.searchConditionList;
    }

    public boolean isCalledPPD() {
        return this.calledPPD;
    }

    protected IndexPredicateAnalyzer.FieldValidator getFieldValidator() {
        return null;
    }
}

