/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.phoenix.hive.objectinspector.AbstractPhoenixObjectInspector;

public class PhoenixStringObjectInspector
extends AbstractPhoenixObjectInspector<Text>
implements StringObjectInspector {
    private boolean escaped;
    private byte escapeChar;

    public PhoenixStringObjectInspector(boolean escaped, byte escapeChar) {
        super(TypeInfoFactory.stringTypeInfo);
        this.escaped = escaped;
        this.escapeChar = escapeChar;
    }

    public Object copyObject(Object o) {
        return o == null ? null : new String((String)o);
    }

    @Override
    public String getPrimitiveJavaObject(Object o) {
        return (String)o;
    }

    public Text getPrimitiveWritableObject(Object o) {
        Text value = null;
        if (o != null) {
            try {
                value = new Text((String)o);
            }
            catch (Exception e) {
                this.logExceptionMessage(o, "STRING");
            }
        }
        return value;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }
}

