/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.phoenix.hive.objectinspector.PhoenixBinaryObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixBooleanObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixByteObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixCharObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixDateObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixDecimalObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixDoubleObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixFloatObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixIntObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixListObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixLongObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixShortObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixStringObjectInspector;
import org.apache.phoenix.hive.objectinspector.PhoenixTimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixObjectInspectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixObjectInspectorFactory.class);

    private PhoenixObjectInspectorFactory() {
    }

    public static LazySimpleStructObjectInspector createStructObjectInspector(TypeInfo type, LazySerDeParameters serdeParams) {
        StructTypeInfo structTypeInfo = (StructTypeInfo)type;
        ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
        ArrayList fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
        for (int i = 0; i < fieldTypeInfos.size(); ++i) {
            fieldObjectInspectors.add(PhoenixObjectInspectorFactory.createObjectInspector((TypeInfo)fieldTypeInfos.get(i), serdeParams));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector((List)fieldNames, fieldObjectInspectors, null, (byte)serdeParams.getSeparators()[1], (LazyObjectInspectorParameters)serdeParams, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    public static ObjectInspector createObjectInspector(TypeInfo type, LazySerDeParameters serdeParams) {
        Object oi = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Type : " + type);
        }
        block0 : switch (type.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        oi = new PhoenixBooleanObjectInspector();
                        break block0;
                    }
                    case BYTE: {
                        oi = new PhoenixByteObjectInspector();
                        break block0;
                    }
                    case SHORT: {
                        oi = new PhoenixShortObjectInspector();
                        break block0;
                    }
                    case INT: {
                        oi = new PhoenixIntObjectInspector();
                        break block0;
                    }
                    case LONG: {
                        oi = new PhoenixLongObjectInspector();
                        break block0;
                    }
                    case FLOAT: {
                        oi = new PhoenixFloatObjectInspector();
                        break block0;
                    }
                    case DOUBLE: {
                        oi = new PhoenixDoubleObjectInspector();
                        break block0;
                    }
                    case VARCHAR: 
                    case STRING: {
                        oi = new PhoenixStringObjectInspector(serdeParams.isEscaped(), serdeParams.getEscapeChar());
                        break block0;
                    }
                    case CHAR: {
                        oi = new PhoenixCharObjectInspector((PrimitiveTypeInfo)type);
                        break block0;
                    }
                    case DATE: {
                        oi = new PhoenixDateObjectInspector();
                        break block0;
                    }
                    case TIMESTAMP: {
                        oi = new PhoenixTimestampObjectInspector();
                        break block0;
                    }
                    case DECIMAL: {
                        oi = new PhoenixDecimalObjectInspector((PrimitiveTypeInfo)type);
                        break block0;
                    }
                    case BINARY: {
                        oi = new PhoenixBinaryObjectInspector();
                        break block0;
                    }
                }
                throw new RuntimeException("Hive internal error. not supported data type : " + type);
            }
            case LIST: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("List type started");
                }
                ObjectInspector listElementObjectInspector = PhoenixObjectInspectorFactory.createObjectInspector(((ListTypeInfo)type).getListElementTypeInfo(), serdeParams);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("List type ended");
                }
                oi = new PhoenixListObjectInspector(listElementObjectInspector, serdeParams.getSeparators()[0], (LazyObjectInspectorParameters)serdeParams);
                break;
            }
            default: {
                throw new RuntimeException("Hive internal error. not supported data type : " + type);
            }
        }
        return oi;
    }
}

