/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.phoenix.hive.objectinspector.AbstractPhoenixObjectInspector;

public class PhoenixFloatObjectInspector
extends AbstractPhoenixObjectInspector<FloatWritable>
implements FloatObjectInspector {
    public PhoenixFloatObjectInspector() {
        super(TypeInfoFactory.floatTypeInfo);
    }

    public Object copyObject(Object o) {
        return o == null ? null : new Float(((Float)o).floatValue());
    }

    public FloatWritable getPrimitiveWritableObject(Object o) {
        return new FloatWritable(this.get(o));
    }

    public float get(Object o) {
        Float value = null;
        if (o != null) {
            try {
                value = Float.valueOf(((Float)o).floatValue());
            }
            catch (Exception e) {
                this.logExceptionMessage(o, "LONG");
            }
        }
        return value.floatValue();
    }
}

