/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.hive.PhoenixRowKey;
import org.apache.phoenix.hive.util.ColumnMappingUtils;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.hive.util.PhoenixUtil;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixResultWritable
implements Writable,
DBWritable,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixResultWritable.class);
    private List<ColumnInfo> columnMetadataList;
    private List<Object> valueList;
    private Map<String, Object> rowMap = new HashMap<String, Object>();
    private Map<String, String> columnMap;
    private int columnCount = -1;
    private Configuration config;
    private boolean isTransactional;
    private Map<String, Object> rowKeyMap = new LinkedHashMap<String, Object>();
    private List<String> primaryKeyColumnList;

    public PhoenixResultWritable() {
    }

    public PhoenixResultWritable(Configuration config) throws IOException {
        this.setConf(config);
    }

    public PhoenixResultWritable(Configuration config, List<ColumnInfo> columnMetadataList) throws IOException {
        this(config);
        this.columnMetadataList = columnMetadataList;
        this.valueList = new ArrayList<Object>(columnMetadataList.size());
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.valueList.clear();
    }

    public void add(Object value) {
        this.valueList.add(value);
    }

    public void write(PreparedStatement statement) throws SQLException {
        ColumnInfo columnInfo = null;
        Object value = null;
        try {
            int limit = this.columnMetadataList.size();
            for (int i = 0; i < limit; ++i) {
                columnInfo = this.columnMetadataList.get(i);
                value = this.valueList.size() > i ? this.valueList.get(i) : null;
                if (value == null) {
                    statement.setNull(i + 1, columnInfo.getSqlType());
                    continue;
                }
                statement.setObject(i + 1, value, columnInfo.getSqlType());
            }
        }
        catch (RuntimeException | SQLException e) {
            LOG.error("[column-info, value] : " + columnInfo + ", " + value);
            throw e;
        }
    }

    public void delete(PreparedStatement statement) throws SQLException {
        ColumnInfo columnInfo = null;
        Object value = null;
        try {
            int limit = this.primaryKeyColumnList.size();
            for (int i = 0; i < limit; ++i) {
                columnInfo = this.columnMetadataList.get(i);
                value = this.valueList.size() > i ? this.valueList.get(i) : null;
                if (value == null) {
                    statement.setNull(i + 1, columnInfo.getSqlType());
                    continue;
                }
                statement.setObject(i + 1, value, columnInfo.getSqlType());
            }
        }
        catch (RuntimeException | SQLException e) {
            LOG.error("[column-info, value] : " + columnInfo + ", " + value);
            throw e;
        }
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        if (this.columnCount == -1) {
            this.columnCount = rsmd.getColumnCount();
        }
        this.rowMap.clear();
        for (int i = 0; i < this.columnCount; ++i) {
            Object value = resultSet.getObject(i + 1);
            String columnName = rsmd.getColumnName(i + 1);
            String mapName = this.columnMap.get(columnName);
            if (mapName != null) {
                columnName = mapName;
            }
            this.rowMap.put(columnName, value);
        }
        if (this.isTransactional) {
            this.rowKeyMap.clear();
            for (String pkColumn : this.primaryKeyColumnList) {
                this.rowKeyMap.put(pkColumn, this.rowMap.get(pkColumn));
            }
        }
    }

    public void readPrimaryKey(PhoenixRowKey rowKey) {
        rowKey.setRowKeyMap(this.rowKeyMap);
    }

    public List<ColumnInfo> getColumnMetadataList() {
        return this.columnMetadataList;
    }

    public void setColumnMetadataList(List<ColumnInfo> columnMetadataList) {
        this.columnMetadataList = columnMetadataList;
    }

    public Map<String, Object> getResultMap() {
        return this.rowMap;
    }

    public List<Object> getValueList() {
        return this.valueList;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        this.columnMap = ColumnMappingUtils.getReverseColumnMapping(this.config.get("phoenix.column.mapping", ""));
        this.isTransactional = PhoenixStorageHandlerUtil.isTransactionalTable(this.config);
        if (this.isTransactional) {
            this.primaryKeyColumnList = PhoenixUtil.getPrimaryKeyColumnList(this.config, this.config.get("phoenix.table.name"));
        }
    }

    public Configuration getConf() {
        return this.config;
    }
}

