/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.mapreduce;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.Progressable;
import org.apache.phoenix.hive.mapreduce.PhoenixRecordWriter;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixOutputFormat<T extends DBWritable>
implements OutputFormat<NullWritable, T>,
AcidOutputFormat<NullWritable, T> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixOutputFormat.class);

    public PhoenixOutputFormat() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PhoenixOutputFormat created");
        }
    }

    public RecordWriter<NullWritable, T> getRecordWriter(FileSystem ignored, JobConf jobConf, String name, Progressable progress) throws IOException {
        return this.createRecordWriter((Configuration)jobConf, new Properties());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get RecordWriter for finalOutPath : " + finalOutPath + ", valueClass : " + valueClass.getName() + ", isCompressed : " + isCompressed + ", tableProperties : " + tableProperties + ", progress : " + progress);
        }
        return this.createRecordWriter((Configuration)jobConf, new Properties());
    }

    public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get RecordWriter for  path : " + path + ", options : " + PhoenixStorageHandlerUtil.getOptionsValue(options));
        }
        return new PhoenixRecordWriter(path, options);
    }

    public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get RawRecordWriter for path : " + path + ", options : " + PhoenixStorageHandlerUtil.getOptionsValue(options));
        }
        return new PhoenixRecordWriter(path, options);
    }

    private PhoenixRecordWriter<T> createRecordWriter(Configuration config, Properties properties) {
        try {
            return new PhoenixRecordWriter(config, properties);
        }
        catch (SQLException e) {
            LOG.error("Error during PhoenixRecordWriter instantiation :" + e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

