/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PrimaryKeyData
implements Serializable {
    public static final PrimaryKeyData EMPTY = new PrimaryKeyData(Collections.emptyMap());
    private static final long serialVersionUID = 1L;
    private final HashMap<String, Object> data;

    public PrimaryKeyData(Map<String, Object> data) {
        this.data = data instanceof HashMap ? (HashMap<Object, Object>)data : new HashMap<String, Object>(Objects.requireNonNull(data));
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    public void serialize(OutputStream output) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(output);){
            oos.writeObject(this);
            oos.flush();
        }
    }

    public static PrimaryKeyData deserialize(InputStream input) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        try (LookAheadObjectInputStream ois = new LookAheadObjectInputStream(input);){
            Object obj = ois.readObject();
            if (obj instanceof PrimaryKeyData) {
                PrimaryKeyData primaryKeyData = (PrimaryKeyData)obj;
                return primaryKeyData;
            }
            try {
                throw new InvalidClassException(obj == null ? "null" : obj.getClass().getName(), "Disallowed serialized class");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static class LookAheadObjectInputStream
    extends ObjectInputStream {
        public LookAheadObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (!(desc.getName().equals(PrimaryKeyData.class.getName()) || desc.getName().startsWith("java.lang.") || desc.getName().startsWith("java.util.") || desc.getName().startsWith("java.sql."))) {
                throw new InvalidClassException(desc.getName(), "Expected an instance of PrimaryKeyData");
            }
            return super.resolveClass(desc);
        }
    }
}

