/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.compat.CompatUtil;
import org.apache.phoenix.compat.HiveCompatUtil;
import org.apache.phoenix.hive.mapreduce.PhoenixResultWritable;
import org.apache.phoenix.hive.util.PhoenixConnectionUtil;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.hive.util.PhoenixUtil;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixSerializer.class);
    private int columnCount = 0;
    private PhoenixResultWritable pResultWritable;

    public PhoenixSerializer(Configuration config, Properties tbl) throws SerDeException {
        String zNodeParent;
        int zooKeeperClientPort;
        String mapping = tbl.getProperty("phoenix.column.mapping", null);
        if (mapping != null) {
            config.set("phoenix.column.mapping", mapping);
        }
        String tableName = tbl.getProperty("phoenix.table.name");
        config.set("phoenix.table.name", tableName);
        config.set("phoenix.rowkeys", tbl.getProperty("phoenix.rowkeys"));
        String quorum = config.get("phoenix.zookeeper.quorum");
        if (quorum == null) {
            config.set("phoenix.zookeeper.quorum", tbl.getProperty("phoenix.zookeeper.quorum", "localhost"));
        }
        if ((zooKeeperClientPort = config.getInt("phoenix.zookeeper.client.port", 0)) == 0) {
            config.setInt("phoenix.zookeeper.client.port", Integer.parseInt(tbl.getProperty("phoenix.zookeeper.client.port", String.valueOf(2181))));
        }
        if ((zNodeParent = config.get("phoenix.zookeeper.znode.parent")) == null) {
            config.set("phoenix.zookeeper.znode.parent", tbl.getProperty("phoenix.zookeeper.znode.parent", "/hbase"));
        }
        try (Connection conn = PhoenixConnectionUtil.getInputConnection(config, tbl);){
            List<ColumnInfo> columnMetadata = PhoenixUtil.getColumnInfoList(conn, tableName);
            this.columnCount = columnMetadata.size();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Column-meta : " + columnMetadata);
            }
            this.pResultWritable = new PhoenixResultWritable(config, columnMetadata);
        }
        catch (IOException | SQLException e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public Writable serialize(Object values, ObjectInspector objInspector, DmlType dmlType) {
        this.pResultWritable.clear();
        StructObjectInspector structInspector = (StructObjectInspector)objInspector;
        List fieldList = structInspector.getAllStructFieldRefs();
        if (LOG.isTraceEnabled()) {
            LOG.trace("FieldList : " + fieldList + " values(" + values.getClass() + ") : " + values);
        }
        int fieldCount = this.columnCount;
        if (dmlType == DmlType.UPDATE || dmlType == DmlType.DELETE) {
            ++fieldCount;
        }
        block5: for (int i = 0; i < fieldCount && fieldList.size() > i; ++i) {
            StructField structField = (StructField)fieldList.get(i);
            if (LOG.isTraceEnabled()) {
                LOG.trace("structField[" + i + "] : " + structField);
            }
            if (structField == null) continue;
            Object fieldValue = structInspector.getStructFieldData(values, structField);
            ObjectInspector fieldOI = structField.getFieldObjectInspector();
            String fieldName = structField.getFieldName();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Field " + fieldName + "[" + i + "] : " + fieldValue + ", " + fieldOI);
            }
            Object value = null;
            switch (fieldOI.getCategory()) {
                case PRIMITIVE: {
                    value = ((PrimitiveObjectInspector)fieldOI).getPrimitiveJavaObject(fieldValue);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Field " + fieldName + "[" + i + "] : " + value + "(" + value.getClass() + ")");
                    }
                    if (value instanceof HiveDecimal) {
                        value = ((HiveDecimal)value).bigDecimalValue();
                    } else if (value instanceof HiveChar) {
                        value = ((HiveChar)value).getValue().trim();
                    } else if (CompatUtil.isPhoenix5()) {
                        value = HiveCompatUtil.getDateOrTimestampValue(value);
                    }
                    this.pResultWritable.add(value);
                    continue block5;
                }
                case LIST: {
                    continue block5;
                }
                case STRUCT: {
                    if (dmlType != DmlType.DELETE) continue block5;
                    List fieldValueList = ((StandardStructObjectInspector)fieldOI).getStructFieldsDataAsList(fieldValue);
                    Map<?, ?> primaryKeyMap = PhoenixStorageHandlerUtil.toMap(((BytesWritable)fieldValueList.get(3)).getBytes());
                    for (Object pkValue : primaryKeyMap.values()) {
                        this.pResultWritable.add(pkValue);
                    }
                    continue block5;
                }
                default: {
                    new SerDeException("Phoenix Unsupported column type: " + fieldOI.getCategory());
                }
            }
        }
        return this.pResultWritable;
    }

    public static enum DmlType {
        NONE,
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

