/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.hive.PhoenixRow;
import org.apache.phoenix.hive.PhoenixSerializer;
import org.apache.phoenix.hive.mapreduce.PhoenixResultWritable;
import org.apache.phoenix.hive.objectinspector.PhoenixObjectInspectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixSerDe.class);
    private PhoenixSerializer serializer;
    private ObjectInspector objectInspector;
    private LazySerDeParameters serdeParams;
    private PhoenixRow row;
    private Properties tableProperties;

    public PhoenixSerDe() throws SerDeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PhoenixSerDe created");
        }
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.tableProperties = tbl;
        if (LOG.isDebugEnabled()) {
            LOG.debug("SerDe initialize : " + tbl.getProperty("name"));
        }
        this.serdeParams = new LazySerDeParameters(conf, tbl, ((Object)((Object)this)).getClass().getName());
        this.objectInspector = this.createLazyPhoenixInspector(conf, tbl);
        String inOutWork = tbl.getProperty("in.out.work");
        if (inOutWork == null) {
            return;
        }
        this.serializer = new PhoenixSerializer(conf, tbl);
        this.row = new PhoenixRow(this.serdeParams.getColumnNames());
    }

    public Object deserialize(Writable result) throws SerDeException {
        if (!(result instanceof PhoenixResultWritable)) {
            throw new SerDeException(result.getClass().getName() + ": expects PhoenixResultWritable!");
        }
        return this.row.setResultRowMap(((PhoenixResultWritable)result).getResultMap());
    }

    public Class<? extends Writable> getSerializedClass() {
        return PhoenixResultWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        try {
            return this.serializer.serialize(obj, objInspector, PhoenixSerializer.DmlType.NONE);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Properties getTableProperties() {
        return this.tableProperties;
    }

    public LazySerDeParameters getSerdeParams() {
        return this.serdeParams;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    private ObjectInspector createLazyPhoenixInspector(Configuration conf, Properties tbl) throws SerDeException {
        List<String> columnNameList = Arrays.asList(tbl.getProperty("columns").split(","));
        ArrayList columnTypeList = TypeInfoUtils.getTypeInfosFromTypeString((String)tbl.getProperty("columns.types"));
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(columnTypeList.size());
        for (TypeInfo typeInfo : columnTypeList) {
            columnObjectInspectors.add(PhoenixObjectInspectorFactory.createObjectInspector(typeInfo, this.serdeParams));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columnNameList, columnObjectInspectors, null, (byte)this.serdeParams.getSeparators()[0], (LazyObjectInspectorParameters)this.serdeParams, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }
}

