/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.phoenix.hive.PhoenixSerializer;
import org.apache.phoenix.hive.mapreduce.PhoenixResultWritable;
import org.apache.phoenix.hive.util.PhoenixConnectionUtil;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.hive.util.PhoenixUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRecordUpdater
implements RecordUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixRecordUpdater.class);
    private final Connection conn;
    private final PreparedStatement pstmt;
    private final long batchSize;
    private long numRecords = 0L;
    private Configuration config;
    private String tableName;
    private MetaDataClient metaDataClient;
    private boolean restoreWalMode;
    private long rowCountDelta = 0L;
    private PhoenixSerializer phoenixSerializer;
    private ObjectInspector objInspector;
    private PreparedStatement pstmtForDelete;

    public PhoenixRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
        this.config = options.getConfiguration();
        this.tableName = this.config.get("phoenix.table.name");
        Properties props = new Properties();
        try {
            String walConfigName = this.tableName.toLowerCase() + ".disable.wal";
            boolean disableWal = this.config.getBoolean(walConfigName, false);
            if (disableWal) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(walConfigName + " is true. batch.mode will be set true.");
                }
                props.setProperty("batch.mode", "true");
            }
            this.conn = PhoenixConnectionUtil.getInputConnection(this.config, props);
            if (disableWal) {
                this.metaDataClient = new MetaDataClient((PhoenixConnection)this.conn);
                if (!PhoenixUtil.isDisabledWal(this.metaDataClient, this.tableName)) {
                    block13: {
                        try {
                            PhoenixUtil.alterTableForWalDisable(this.conn, this.tableName, true);
                        }
                        catch (ConcurrentTableMutationException e) {
                            if (!LOG.isWarnEnabled()) break block13;
                            LOG.warn("Concurrent modification of disableWAL");
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.tableName + "s wal disabled.");
                    }
                    this.restoreWalMode = true;
                }
            }
            this.batchSize = PhoenixConfigurationUtil.getBatchSize((Configuration)this.config);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Batch-size : " + this.batchSize);
            }
            String upsertQuery = QueryUtil.constructUpsertStatement((String)this.tableName, PhoenixUtil.getColumnInfoList(this.conn, this.tableName));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upsert-query : " + upsertQuery);
            }
            this.pstmt = this.conn.prepareStatement(upsertQuery);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        this.objInspector = options.getInspector();
        try {
            this.phoenixSerializer = new PhoenixSerializer(this.config, options.getTableProperties());
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public void insert(long currentTransaction, Object row) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Insert - currentTranscation : " + currentTransaction + ", row : " + PhoenixStorageHandlerUtil.toString(row));
        }
        PhoenixResultWritable pResultWritable = (PhoenixResultWritable)this.phoenixSerializer.serialize(row, this.objInspector, PhoenixSerializer.DmlType.INSERT);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data : " + pResultWritable.getValueList());
        }
        this.write(pResultWritable);
        ++this.rowCountDelta;
    }

    public void update(long currentTransaction, Object row) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update - currentTranscation : " + currentTransaction + ", row : " + PhoenixStorageHandlerUtil.toString(row));
        }
        PhoenixResultWritable pResultWritable = (PhoenixResultWritable)this.phoenixSerializer.serialize(row, this.objInspector, PhoenixSerializer.DmlType.UPDATE);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data : " + pResultWritable.getValueList());
        }
        this.write(pResultWritable);
    }

    public void delete(long currentTransaction, Object row) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delete - currentTranscation : " + currentTransaction + ", row : " + PhoenixStorageHandlerUtil.toString(row));
        }
        PhoenixResultWritable pResultWritable = (PhoenixResultWritable)this.phoenixSerializer.serialize(row, this.objInspector, PhoenixSerializer.DmlType.DELETE);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data : " + pResultWritable.getValueList());
        }
        if (this.pstmtForDelete == null) {
            try {
                String deleteQuery = PhoenixUtil.constructDeleteStatement(this.conn, this.tableName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delete query : " + deleteQuery);
                }
                this.pstmtForDelete = this.conn.prepareStatement(deleteQuery);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        this.delete(pResultWritable);
        --this.rowCountDelta;
    }

    private void delete(PhoenixResultWritable pResultWritable) throws IOException {
        try {
            pResultWritable.delete(this.pstmtForDelete);
            ++this.numRecords;
            this.pstmtForDelete.executeUpdate();
            if (this.numRecords % this.batchSize == 0L) {
                LOG.debug("Commit called on a batch of size : " + this.batchSize);
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new IOException("Exception while deleting to table.", e);
        }
    }

    private void write(PhoenixResultWritable pResultWritable) throws IOException {
        try {
            pResultWritable.write(this.pstmt);
            ++this.numRecords;
            this.pstmt.executeUpdate();
            if (this.numRecords % this.batchSize == 0L) {
                LOG.debug("Commit called on a batch of size : " + this.batchSize);
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new IOException("Exception while writing to table.", e);
        }
    }

    public void flush() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flush called");
        }
        try {
            this.conn.commit();
            if (LOG.isInfoEnabled()) {
                LOG.info("Written row : " + this.numRecords);
            }
        }
        catch (SQLException e) {
            LOG.error("SQLException while performing the commit for the task.");
            throw new IOException(e);
        }
    }

    public void close(boolean abort) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("abort : " + abort);
        }
        try {
            this.conn.commit();
            if (LOG.isInfoEnabled()) {
                LOG.info("Written row : " + this.numRecords);
            }
        }
        catch (SQLException e) {
            LOG.error("SQLException while performing the commit for the task.");
            throw new IOException(e);
        }
        finally {
            try {
                String autoFlushConfigName;
                boolean autoFlush;
                if (this.restoreWalMode && PhoenixUtil.isDisabledWal(this.metaDataClient, this.tableName)) {
                    block20: {
                        try {
                            PhoenixUtil.alterTableForWalDisable(this.conn, this.tableName, false);
                        }
                        catch (ConcurrentTableMutationException e) {
                            if (!LOG.isWarnEnabled()) break block20;
                            LOG.warn("Concurrent modification of disableWAL");
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.tableName + "s wal enabled.");
                    }
                }
                if (autoFlush = this.config.getBoolean(autoFlushConfigName = this.tableName.toLowerCase() + ".auto.flush", false)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("autoFlush is " + autoFlush);
                    }
                    PhoenixUtil.flush(this.conn, this.tableName);
                }
                PhoenixUtil.closeResource(this.pstmt);
                PhoenixUtil.closeResource(this.pstmtForDelete);
                PhoenixUtil.closeResource(this.conn);
            }
            catch (SQLException ex) {
                LOG.error("SQLException while closing the connection for the task.");
                throw new IOException(ex);
            }
        }
    }

    public SerDeStats getStats() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getStats called");
        }
        SerDeStats stats = new SerDeStats();
        stats.setRowCount(this.rowCountDelta);
        return stats;
    }

    public long getBufferedRowCount() {
        return this.numRecords;
    }
}

