/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.phoenix.hive.util.ColumnMappingUtils;
import org.apache.phoenix.hive.util.PhoenixConnectionUtil;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.hive.util.PhoenixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixMetaHook
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixMetaHook.class);
    private static final String EXTERNAL_TABLE_PURGE = "external.table.purge";

    public void preCreateTable(Table table) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Precreate table : " + table.getTableName());
        }
        try (Connection conn = PhoenixConnectionUtil.getConnection(table);){
            String tableType = table.getTableType();
            String tableName = PhoenixStorageHandlerUtil.getTargetTableName(table);
            if (TableType.EXTERNAL_TABLE.name().equals(tableType)) {
                if (!PhoenixUtil.existTable(conn, tableName)) {
                    PhoenixUtil.createTable(conn, this.createTableStatement(table));
                    Map tableParameterMap = table.getParameters();
                    tableParameterMap.put(EXTERNAL_TABLE_PURGE, "TRUE");
                    table.setParameters(tableParameterMap);
                }
            } else {
                if (TableType.MANAGED_TABLE.name().equals(tableType)) {
                    throw new MetaException("Only external table are supported for PhoenixStorageHandler");
                }
                throw new MetaException("Unsupported table Type: " + table.getTableType());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Phoenix table " + tableName + " was created");
            }
        }
        catch (SQLException e) {
            LOG.warn("error while creating table", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    private String createTableStatement(Table table) throws MetaException {
        Map tableParameterMap = table.getParameters();
        String tableName = PhoenixStorageHandlerUtil.getTargetTableName(table);
        StringBuilder ddl = new StringBuilder("create table ").append(tableName).append(" (\n");
        String phoenixRowKeys = (String)tableParameterMap.get("phoenix.rowkeys");
        StringBuilder realRowKeys = new StringBuilder();
        ArrayList<String> phoenixRowKeyList = new ArrayList<String>();
        for (String key : phoenixRowKeys.split(",")) {
            phoenixRowKeyList.add(key.trim());
        }
        Map<String, String> columnMappingMap = ColumnMappingUtils.getColumnMappingMap((String)tableParameterMap.get("phoenix.column.mapping"));
        List fieldSchemaList = table.getSd().getCols();
        int limit = fieldSchemaList.size();
        for (int i = 0; i < limit; ++i) {
            ArrayList<String> tokenList;
            String columnName;
            FieldSchema fieldSchema = (FieldSchema)fieldSchemaList.get(i);
            String fieldName = fieldSchema.getName();
            String fieldType = fieldSchema.getType();
            String columnType = PhoenixUtil.getPhoenixType(fieldType);
            String rowKeyName = this.getRowKeyMapping(fieldName, phoenixRowKeyList);
            if (rowKeyName != null) {
                columnName = columnMappingMap.get(fieldName);
                if (columnName != null) {
                    rowKeyName = columnName;
                }
                if ("binary".equals(columnType)) {
                    tokenList = new ArrayList<String>();
                    for (String name : rowKeyName.split("\\(|\\)")) {
                        tokenList.add(name.trim());
                    }
                    columnType = columnType + "(" + (String)tokenList.get(1) + ")";
                    rowKeyName = (String)tokenList.get(0);
                }
                ddl.append("  ").append("\"").append(rowKeyName).append("\"").append(" ").append(columnType).append(" not null,\n");
                realRowKeys.append("\"").append(rowKeyName).append("\",");
                continue;
            }
            columnName = columnMappingMap.get(fieldName);
            if (columnName == null) {
                columnName = fieldName;
            }
            if ("binary".equals(columnType)) {
                tokenList = new ArrayList();
                for (String name : columnName.split("\\(|\\)")) {
                    tokenList.add(name.trim());
                }
                columnType = columnType + "(" + (String)tokenList.get(1) + ")";
                columnName = (String)tokenList.get(0);
            }
            ddl.append("  ").append("\"").append(columnName).append("\"").append(" ").append(columnType).append(",\n");
        }
        ddl.append("  ").append("constraint pk_").append(PhoenixUtil.getTableSchema(tableName.toUpperCase())[1]).append(" primary key(").append((CharSequence)realRowKeys.deleteCharAt(realRowKeys.length() - 1)).append(")\n)\n");
        String tableOptions = (String)tableParameterMap.get("phoenix.table.options");
        if (tableOptions != null) {
            ddl.append(tableOptions);
        }
        String statement = ddl.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("DDL : " + statement);
        }
        return statement;
    }

    private String getRowKeyMapping(String rowKeyName, List<String> phoenixRowKeyList) {
        String rowKeyMapping = null;
        for (String phoenixRowKey : phoenixRowKeyList) {
            if (phoenixRowKey.equals(rowKeyName)) {
                rowKeyMapping = phoenixRowKey;
                break;
            }
            if (!phoenixRowKey.startsWith(rowKeyName + "(") || !phoenixRowKey.endsWith(")")) continue;
            rowKeyMapping = phoenixRowKey;
            break;
        }
        return rowKeyMapping;
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rollback for table : " + table.getTableName());
        }
        this.dropTableIfExist(table);
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit drop table : " + table.getTableName());
        }
        this.dropTableIfExist(table);
    }

    private void dropTableIfExist(Table table) throws MetaException {
        try (Connection conn = PhoenixConnectionUtil.getConnection(table);){
            String tableName = PhoenixStorageHandlerUtil.getTargetTableName(table);
            if (this.isExternalTablePurge(table) && PhoenixUtil.existTable(conn, tableName)) {
                PhoenixUtil.dropTable(conn, tableName);
            }
        }
        catch (SQLException e) {
            LOG.warn("error while dropping table", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    private boolean isExternalTablePurge(Table table) {
        if (table == null) {
            return false;
        }
        Map params = table.getParameters();
        if (params == null) {
            return false;
        }
        return this.isPropertyTrue(params, EXTERNAL_TABLE_PURGE);
    }

    private boolean isPropertyTrue(Map<String, String> tableParams, String prop) {
        return "TRUE".equalsIgnoreCase(tableParams.get(prop));
    }
}

