/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QTestProcessExecResult;
import org.apache.hadoop.hive.ql.QTestUtil;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.hive.HiveTestUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
@NotThreadSafe
public class BaseHivePhoenixStoreIT
extends BaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHivePhoenixStoreIT.class);
    protected static HiveTestUtil qt;
    protected static String hiveOutputDir;
    protected static String hiveLogDir;

    public static void setup(QTestUtil.MiniClusterType clusterType) throws Exception {
        System.clearProperty("test.build.data");
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("phoenix.schema.dropMetaData", Boolean.toString(true));
        serverProps.put("hive.metastore.schema.verification", "false");
        BaseHivePhoenixStoreIT.setUpTestDriver((ReadOnlyProps)new ReadOnlyProps(serverProps.entrySet().iterator()));
        String hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        if (null != hadoopConfDir && !hadoopConfDir.isEmpty()) {
            LOG.warn("WARNING: HADOOP_CONF_DIR is set in the environment which may cause issues with test execution via MiniDFSCluster");
        }
        hiveOutputDir = new Path(utility.getDataTestDir(), "hive_output").toString();
        File outputDir = new File(hiveOutputDir);
        outputDir.mkdirs();
        hiveLogDir = new Path(utility.getDataTestDir(), "hive_log").toString();
        File logDir = new File(hiveLogDir);
        logDir.mkdirs();
        Path testRoot = utility.getDataTestDir();
        String hiveBuildDataDir = new Path(utility.getDataTestDir(), "hive/build/data/").toString();
        File buildDataDir = new File(hiveBuildDataDir);
        buildDataDir.mkdirs();
        System.setProperty("test.build.data", hiveBuildDataDir.toString());
        System.setProperty("test.tmp.dir", testRoot.toString());
        System.setProperty("test.warehouse.dir", new Path(testRoot, "warehouse").toString());
        System.setProperty(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.toString(), "false");
        try {
            qt = new HiveTestUtil(hiveOutputDir, hiveLogDir, clusterType, "", "0.20", null, null, false);
            qt.createSources();
        }
        catch (Exception e) {
            LOG.error("Unexpected exception in setup: " + e.getMessage(), (Throwable)e);
            Assert.fail((String)("Unexpected exception in setup" + Throwables.getStackTraceAsString((Throwable)e)));
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseHivePhoenixStoreIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            stmt.execute("create table t(a integer primary key,b varchar)");
        }
    }

    protected void runTest(String fname, String fpath) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            LOG.info("Begin query: " + fname);
            qt.addFile(fpath);
            if (qt.shouldBeSkipped(fname)) {
                LOG.info("Test " + fname + " skipped");
                return;
            }
            qt.cliInit(fname);
            qt.clearTestSideEffects();
            int ecode = qt.executeClient(fname);
            if (ecode != 0) {
                qt.failed(ecode, fname, null);
                return;
            }
            QTestProcessExecResult result = qt.checkCliDriverResults(fname);
            if (result.getReturnCode() != 0) {
                qt.failedDiff(result.getReturnCode(), fname, result.getCapturedOutput());
            }
            qt.clearPostTestEffects();
        }
        catch (Throwable e) {
            qt.failed(new Exception(e), fname, null);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        LOG.info("Done query: " + fname + " elapsedTime=" + elapsedTime / 1000L + "s");
        Assert.assertTrue((String)"Test passed", (boolean)true);
    }

    protected void createFile(String content, String fullName) throws IOException {
        FileUtils.write((File)new File(fullName), (CharSequence)content);
    }

    @AfterClass
    public static synchronized void tearDownAfterClass() throws Exception {
        if (qt != null) {
            try {
                qt.shutdown();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception in setup", (Throwable)e);
            }
        }
    }
}

