/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import junit.framework.TestSuite;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.common.io.DigestPrintStream;
import org.apache.hadoop.hive.common.io.SortAndDigestPrintStream;
import org.apache.hadoop.hive.common.io.SortPrintStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QTestProcessExecResult;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.CuratorFrameworkSingleton;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.StreamPrinter;
import org.apache.logging.log4j.util.Strings;
import org.apache.phoenix.compat.CompatUtil;
import org.apache.phoenix.compat.HiveCompatUtil;
import org.apache.phoenix.compat.MyResult;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.tools.ant.BuildException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QTestUtil {
    public static final String UTF_8 = "UTF-8";
    public static final String HIVE_ROOT = QTestUtil.getHiveRoot();
    private static final String SECURITY_KEY_PROVIDER_URI_NAME = "dfs.encryption.key.provider.uri";
    private static final String CRLF = System.getProperty("line.separator");
    public static final String QTEST_LEAVE_FILES = "QTEST_LEAVE_FILES";
    private static final Logger LOG = LoggerFactory.getLogger((String)"QTestUtil");
    private static final String defaultInitScript = "q_test_init.sql";
    private static final String defaultCleanupScript = "q_test_cleanup.sql";
    private final String[] testOnlyCommands = new String[]{"crypto"};
    private static final String TEST_TMP_DIR_PROPERTY = "test.tmp.dir";
    private static final String BUILD_DIR_PROPERTY = "build.dir";
    public static final String PATH_HDFS_REGEX = "(hdfs://)([a-zA-Z0-9:/_\\-\\.=])+";
    public static final String PATH_HDFS_WITH_DATE_USER_GROUP_REGEX = "([a-z]+) ([a-z]+)([ ]+)([0-9]+) ([0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}) (hdfs://)([a-zA-Z0-9:/_\\-\\.=])+";
    private static String DEFAULT_DATABASE_NAME = HiveCompatUtil.getDefaultDatabaseName();
    private String testWarehouse;
    private final String testFiles;
    protected final String outDir;
    protected String overrideResultsDir;
    protected final String logDir;
    private final TreeMap<String, String> qMap;
    private final Set<String> qSkipSet;
    private final Set<String> qSortSet;
    private final Set<String> qSortQuerySet;
    private final Set<String> qHashQuerySet;
    private final Set<String> qSortNHashQuerySet;
    private final Set<String> qNoSessionReuseQuerySet;
    private final Set<String> qJavaVersionSpecificOutput;
    private static final String SORT_SUFFIX = ".sorted";
    private final Set<String> srcTables;
    private final Set<String> srcUDFs;
    private final MiniClusterType clusterType;
    private final FsType fsType;
    private ParseDriver pd;
    protected Hive db;
    protected QueryState queryState;
    protected HiveConf conf;
    private Object drv;
    private BaseSemanticAnalyzer sem;
    protected final boolean overWrite;
    private CliDriver cliDriver;
    private HadoopShims.MiniMrShim mr = null;
    private HadoopShims.MiniDFSShim dfs = null;
    private FileSystem fs;
    private HadoopShims.HdfsEncryptionShim hes = null;
    private String hadoopVer = null;
    private QTestSetup setup = null;
    private SparkSession sparkSession = null;
    private boolean isSessionStateStarted = false;
    private static final String javaVersion = QTestUtil.getJavaVersion();
    private final String initScript;
    private final String cleanupScript;
    static Pattern mapTok = Pattern.compile("(\\.?)(.*)_map_(.*)");
    static Pattern reduceTok = Pattern.compile("(.*)(reduce_[^\\.]*)((\\..*)?)");
    private static final Pattern SORT_BEFORE_DIFF = Pattern.compile("-- SORT_BEFORE_DIFF");
    private static final Pattern SORT_QUERY_RESULTS = Pattern.compile("-- SORT_QUERY_RESULTS");
    private static final Pattern HASH_QUERY_RESULTS = Pattern.compile("-- HASH_QUERY_RESULTS");
    private static final Pattern SORT_AND_HASH_QUERY_RESULTS = Pattern.compile("-- SORT_AND_HASH_QUERY_RESULTS");
    private static final Pattern NO_SESSION_REUSE = Pattern.compile("-- NO_SESSION_REUSE");
    private final Pattern[] planMask = this.toPattern(new String[]{".*file:.*", ".*pfile:.*", ".*/tmp/.*", ".*invalidscheme:.*", ".*lastUpdateTime.*", ".*lastAccessTime.*", ".*lastModifiedTime.*", ".*[Oo]wner.*", ".*CreateTime.*", ".*LastAccessTime.*", ".*Location.*", ".*LOCATION '.*", ".*transient_lastDdlTime.*", ".*last_modified_.*", ".*at org.*", ".*at sun.*", ".*at java.*", ".*at junit.*", ".*Caused by:.*", ".*LOCK_QUERYID:.*", ".*LOCK_TIME:.*", ".*grantTime.*", ".*[.][.][.] [0-9]* more.*", ".*job_[0-9_]*.*", ".*job_local[0-9_]*.*", ".*USING 'java -cp.*", "^Deleted.*", ".*DagName:.*", ".*DagId:.*", ".*Input:.*/data/files/.*", ".*Output:.*/data/files/.*", ".*total number of created files now is.*", ".*.hive-staging.*", ".*Warning.*", "pk_-?[0-9]*_[0-9]*_[0-9]*", "fk_-?[0-9]*_[0-9]*_[0-9]*", "uk_-?[0-9]*_[0-9]*_[0-9]*", "nn_-?[0-9]*_[0-9]*_[0-9]*", ".*at com\\.sun\\.proxy.*", ".*at com\\.jolbox.*", ".*at com\\.zaxxer.*", "org\\.apache\\.hadoop\\.hive\\.metastore\\.model\\.MConstraint@([0-9]|[a-z])*", "^Repair: Added partition to metastore.*"});
    private final Pattern[] partialReservedPlanMask = this.toPattern(new String[]{"data/warehouse/(.*?/)+\\.hive-staging"});
    private final PatternReplacementPair[] partialPlanMask;
    private final List<Pair<Pattern, String>> patternsWithMaskComments;
    private static String[] cachedQvFileList = null;
    private static ImmutableList<String> cachedDefaultQvFileList = null;
    private static Pattern qvSuffix = Pattern.compile("_[0-9]+.qv$", 2);

    public static Set<String> getSrcTables() {
        HashSet<String> srcTables = new HashSet<String>();
        String defaultTestSrcTables = "src,src1,srcbucket,srcbucket2,src_json,src_thrift,src_sequencefile,srcpart,alltypesorc,src_hbase,cbo_t1,cbo_t2,cbo_t3,src_cbo,part,lineitem,alltypesparquet";
        for (String srcTable : System.getProperty("test.src.tables", defaultTestSrcTables).trim().split(",")) {
            if ((srcTable = srcTable.trim()).isEmpty()) continue;
            srcTables.add(srcTable);
        }
        if (srcTables.isEmpty()) {
            throw new RuntimeException("Source tables cannot be empty");
        }
        return srcTables;
    }

    private Set<String> getSrcUDFs() {
        HashSet<String> srcUDFs = new HashSet<String>();
        String defaultTestSrcUDFs = "qtest_get_java_boolean";
        for (String srcUDF : System.getProperty("test.src.udfs", defaultTestSrcUDFs).trim().split(",")) {
            if ((srcUDF = srcUDF.trim()).isEmpty()) continue;
            srcUDFs.add(srcUDF);
        }
        if (srcUDFs.isEmpty()) {
            throw new RuntimeException("Source UDFs cannot be empty");
        }
        return srcUDFs;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public void copyDirectoryToLocal(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dest) throws Exception {
        FileSystem srcFs = src.getFileSystem((Configuration)this.conf);
        FileSystem destFs = dest.getFileSystem((Configuration)this.conf);
        if (srcFs.exists(src)) {
            FileStatus[] files;
            for (FileStatus file : files = srcFs.listStatus(src)) {
                String name = file.getPath().getName();
                org.apache.hadoop.fs.Path dfs_path = file.getPath();
                org.apache.hadoop.fs.Path local_path = new org.apache.hadoop.fs.Path(dest, name);
                if (this.srcTables.contains(name)) continue;
                if (file.isDirectory()) {
                    if (!destFs.exists(local_path)) {
                        destFs.mkdirs(local_path);
                    }
                    this.copyDirectoryToLocal(dfs_path, local_path);
                    continue;
                }
                srcFs.copyToLocalFile(dfs_path, local_path);
            }
        }
    }

    public void normalizeNames(File path) throws Exception {
        if (path.isDirectory()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                this.normalizeNames(file);
            }
        } else {
            Matcher m = reduceTok.matcher(path.getName());
            if (m.matches()) {
                String name = m.group(1) + "reduce" + m.group(3);
                path.renameTo(new File(path.getParent(), name));
            } else {
                m = mapTok.matcher(path.getName());
                if (m.matches()) {
                    String name = m.group(1) + "map_" + m.group(3);
                    path.renameTo(new File(path.getParent(), name));
                }
            }
        }
    }

    public String getOutputDirectory() {
        return this.outDir;
    }

    public String getLogDirectory() {
        return this.logDir;
    }

    private String getHadoopMainVersion(String input) {
        if (input == null) {
            return null;
        }
        Pattern p = Pattern.compile("^(\\d+\\.\\d+).*");
        Matcher m = p.matcher(input);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public void initConf() throws Exception {
        String vectorizationEnabled = System.getProperty("test.vectorization.enabled");
        if (vectorizationEnabled != null && vectorizationEnabled.equalsIgnoreCase("true")) {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        }
        this.conf.setVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL, "org.apache.hadoop.hive.metastore.VerifyingObjectStore");
        if (this.mr != null) {
            this.mr.setupConfiguration((Configuration)this.conf);
            this.setFsRelatedProperties(this.conf, this.fs.getScheme().equals("file"), this.fs);
        }
        this.conf.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, this.clusterType.name());
    }

    private void setFsRelatedProperties(HiveConf conf, boolean isLocalFs, FileSystem fs) {
        org.apache.hadoop.fs.Path userInstallPath;
        org.apache.hadoop.fs.Path jarPath;
        org.apache.hadoop.fs.Path warehousePath;
        String fsUriString = fs.getUri().toString();
        if (isLocalFs) {
            String buildDir = System.getProperty(BUILD_DIR_PROPERTY);
            Preconditions.checkState((boolean)Strings.isNotBlank((String)buildDir));
            org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(fsUriString, buildDir);
            org.apache.hadoop.fs.Path localFsRoot = new org.apache.hadoop.fs.Path(path, "localfs");
            warehousePath = new org.apache.hadoop.fs.Path(localFsRoot, "warehouse");
            jarPath = new org.apache.hadoop.fs.Path(localFsRoot, "jar");
            userInstallPath = new org.apache.hadoop.fs.Path(localFsRoot, "user_install");
        } else {
            warehousePath = new org.apache.hadoop.fs.Path(fsUriString, "/build/ql/test/data/warehouse/");
            jarPath = new org.apache.hadoop.fs.Path(new org.apache.hadoop.fs.Path(fsUriString, "/user"), "hive");
            userInstallPath = new org.apache.hadoop.fs.Path(fsUriString, "/user");
        }
        warehousePath = fs.makeQualified(warehousePath);
        jarPath = fs.makeQualified(jarPath);
        userInstallPath = fs.makeQualified(userInstallPath);
        conf.set("fs.defaultFS", fsUriString);
        conf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, warehousePath.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_JAR_DIRECTORY, jarPath.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_USER_INSTALL_DIR, userInstallPath.toString());
    }

    private void createRemoteDirs() {
        assert (this.fs != null);
        org.apache.hadoop.fs.Path warehousePath = this.fs.makeQualified(new org.apache.hadoop.fs.Path(this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE)));
        assert (warehousePath != null);
        org.apache.hadoop.fs.Path hiveJarPath = this.fs.makeQualified(new org.apache.hadoop.fs.Path(this.conf.getVar(HiveConf.ConfVars.HIVE_JAR_DIRECTORY)));
        assert (hiveJarPath != null);
        org.apache.hadoop.fs.Path userInstallPath = this.fs.makeQualified(new org.apache.hadoop.fs.Path(this.conf.getVar(HiveConf.ConfVars.HIVE_USER_INSTALL_DIR)));
        assert (userInstallPath != null);
        try {
            this.fs.mkdirs(warehousePath);
        }
        catch (IOException e) {
            LOG.error("Failed to create path={}. Continuing. Exception message={}", (Object)warehousePath, (Object)e.getMessage());
        }
        try {
            this.fs.mkdirs(hiveJarPath);
        }
        catch (IOException e) {
            LOG.error("Failed to create path={}. Continuing. Exception message={}", (Object)warehousePath, (Object)e.getMessage());
        }
        try {
            this.fs.mkdirs(userInstallPath);
        }
        catch (IOException e) {
            LOG.error("Failed to create path={}. Continuing. Exception message={}", (Object)warehousePath, (Object)e.getMessage());
        }
    }

    private String getKeyProviderURI() {
        String keyDir = HIVE_ROOT + "ql/target/";
        return "jceks://file" + new org.apache.hadoop.fs.Path(keyDir, "test.jks").toUri();
    }

    public QTestUtil(String outDir, String logDir, MiniClusterType clusterType, String confDir, String hadoopVer, String initScript, String cleanupScript, boolean withLlapIo) throws Exception {
        this(outDir, logDir, clusterType, confDir, hadoopVer, initScript, cleanupScript, withLlapIo, null);
    }

    public QTestUtil(String outDir, String logDir, MiniClusterType clusterType, String confDir, String hadoopVer, String initScript, String cleanupScript, boolean withLlapIo, FsType fsType) throws Exception {
        String dataDir;
        ArrayList<PatternReplacementPair> ppm = new ArrayList<PatternReplacementPair>();
        ppm.add(new PatternReplacementPair(Pattern.compile("\\{\"transactionid\":[1-9][0-9]*,\"bucketid\":"), "{\"transactionid\":### Masked txnid ###,\"bucketid\":"));
        ppm.add(new PatternReplacementPair(Pattern.compile("attempt_[0-9]+"), "attempt_#ID#"));
        ppm.add(new PatternReplacementPair(Pattern.compile("vertex_[0-9_]+"), "vertex_#ID#"));
        ppm.add(new PatternReplacementPair(Pattern.compile("task_[0-9_]+"), "task_#ID#"));
        this.partialPlanMask = ppm.toArray(new PatternReplacementPair[ppm.size()]);
        this.patternsWithMaskComments = new ArrayList<Pair<Pattern, String>>(){
            {
                this.add(QTestUtil.this.toPatternPair("(pblob|s3.?|swift|wasb.?).*hive-staging.*", "### BLOBSTORE_STAGING_PATH ###"));
                this.add(QTestUtil.this.toPatternPair(QTestUtil.PATH_HDFS_WITH_DATE_USER_GROUP_REGEX, "### USER ### ### GROUP ###$3$4 ### HDFS DATE ### $6### HDFS PATH ###"));
                this.add(QTestUtil.this.toPatternPair(QTestUtil.PATH_HDFS_REGEX, "$1### HDFS PATH ###"));
            }
        };
        LOG.info("Setting up QTestUtil with outDir=" + outDir + ", logDir=" + logDir + ", clusterType=" + (Object)((Object)clusterType) + ", confDir=" + confDir + ", hadoopVer=" + hadoopVer + ", initScript=" + initScript + ", cleanupScript=" + cleanupScript + ", withLlapIo=" + withLlapIo + ", fsType=" + (Object)((Object)fsType) + "");
        Preconditions.checkNotNull((Object)((Object)clusterType), (Object)"ClusterType cannot be null");
        this.fsType = fsType != null ? fsType : clusterType.getDefaultFsType();
        this.outDir = outDir;
        this.logDir = logDir;
        this.srcTables = QTestUtil.getSrcTables();
        this.srcUDFs = this.getSrcUDFs();
        MyResult result = HiveCompatUtil.doSetup((String)confDir);
        this.conf = result.getFirst();
        this.queryState = result.getSecond();
        this.hadoopVer = this.getHadoopMainVersion(hadoopVer);
        this.qMap = new TreeMap();
        this.qSkipSet = new HashSet<String>();
        this.qSortSet = new HashSet<String>();
        this.qSortQuerySet = new HashSet<String>();
        this.qHashQuerySet = new HashSet<String>();
        this.qSortNHashQuerySet = new HashSet<String>();
        this.qNoSessionReuseQuerySet = new HashSet<String>();
        this.qJavaVersionSpecificOutput = new HashSet<String>();
        this.clusterType = clusterType;
        HadoopShims shims = ShimLoader.getHadoopShims();
        this.setupFileSystem(shims);
        this.setup = new QTestSetup();
        this.setup.preTest(this.conf);
        this.setupMiniCluster(shims, confDir);
        this.initConf();
        if (withLlapIo && clusterType == MiniClusterType.none) {
            LOG.info("initializing llap IO");
            LlapProxy.initializeLlapIo((Configuration)this.conf);
        }
        if ((dataDir = this.conf.get("test.data.files")) == null) {
            dataDir = new File(".").getAbsolutePath() + "/data/files";
        }
        this.testFiles = dataDir;
        String scriptsDir = this.conf.get("test.data.scripts");
        if (scriptsDir == null) {
            scriptsDir = new File(".").getAbsolutePath() + "/data/scripts";
        }
        this.initScript = scriptsDir + File.separator + initScript;
        this.cleanupScript = scriptsDir + File.separator + cleanupScript;
        this.overWrite = "true".equalsIgnoreCase(System.getProperty("test.output.overwrite"));
        this.init();
    }

    private void setupFileSystem(HadoopShims shims) throws IOException {
        if (this.fsType == FsType.local) {
            this.fs = FileSystem.getLocal((Configuration)this.conf);
        } else if (this.fsType == FsType.hdfs || this.fsType == FsType.encrypted_hdfs) {
            int numDataNodes = 4;
            if (this.fsType == FsType.encrypted_hdfs) {
                this.conf.set(SECURITY_KEY_PROVIDER_URI_NAME, this.getKeyProviderURI());
                this.conf.setInt("fs.trash.interval", 50);
                this.dfs = shims.getMiniDfs((Configuration)this.conf, numDataNodes, true, null);
                this.fs = this.dfs.getFileSystem();
                this.hes = shims.createHdfsEncryptionShim(this.fs, (Configuration)this.conf);
                LOG.info("key provider is initialized");
            } else {
                this.dfs = shims.getMiniDfs((Configuration)this.conf, numDataNodes, true, null);
                this.fs = this.dfs.getFileSystem();
            }
        } else {
            throw new IllegalArgumentException("Unknown or unhandled fsType [" + (Object)((Object)this.fsType) + "]");
        }
    }

    private void setupMiniCluster(HadoopShims shims, String confDir) throws IOException {
        String uriString = this.fs.getUri().toString();
        if (this.clusterType.getCoreClusterType() == CoreClusterType.TEZ) {
            if (confDir != null && !confDir.isEmpty()) {
                this.conf.addResource(new URL("file://" + new File(confDir).toURI().getPath() + "/tez-site.xml"));
            }
            int numTrackers = 2;
            this.mr = EnumSet.of(MiniClusterType.llap_local, MiniClusterType.tez_local).contains((Object)this.clusterType) ? shims.getLocalMiniTezCluster((Configuration)this.conf, this.clusterType == MiniClusterType.llap_local) : shims.getMiniTezCluster((Configuration)this.conf, numTrackers, uriString, EnumSet.of(MiniClusterType.llap, MiniClusterType.llap_local).contains((Object)this.clusterType));
        } else if (this.clusterType == MiniClusterType.miniSparkOnYarn) {
            this.mr = shims.getMiniSparkCluster((Configuration)this.conf, 2, uriString, 1);
        } else if (this.clusterType == MiniClusterType.mr) {
            this.mr = shims.getMiniMrCluster((Configuration)this.conf, 2, uriString, 1);
        }
    }

    public void shutdown() throws Exception {
        if (System.getenv(QTEST_LEAVE_FILES) == null) {
            this.cleanUp();
        }
        if (CompatUtil.isPhoenix5() && this.clusterType.getCoreClusterType() == CoreClusterType.TEZ) {
            HiveCompatUtil.destroyTEZSession((SessionState)SessionState.get());
        }
        this.setup.tearDown();
        if (this.sparkSession != null) {
            try {
                SparkSessionManagerImpl.getInstance().closeSession(this.sparkSession);
            }
            catch (Exception ex) {
                LOG.error("Error closing spark session.", (Throwable)ex);
            }
            finally {
                this.sparkSession = null;
            }
        }
        if (this.mr != null) {
            this.mr.shutdown();
            this.mr = null;
        }
        FileSystem.closeAll();
        if (this.dfs != null) {
            this.dfs.shutdown();
            this.dfs = null;
        }
        Hive.closeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readEntireFileIntoString(File queryFile) throws IOException {
        StringWriter sw = new StringWriter();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(queryFile)), UTF_8);){
            IOUtils.copy((Reader)isr, (Writer)sw);
        }
        return sw.toString();
    }

    public void addFile(String queryFile) throws IOException {
        this.addFile(queryFile, false);
    }

    public void addFile(String queryFile, boolean partial) throws IOException {
        this.addFile(new File(queryFile));
    }

    public void addFile(File qf) throws IOException {
        this.addFile(qf, false);
    }

    public void addFile(File qf, boolean partial) throws IOException {
        String query = this.readEntireFileIntoString(qf);
        this.qMap.put(qf.getName(), query);
        if (partial) {
            return;
        }
        if (this.checkHadoopVersionExclude(qf.getName(), query)) {
            this.qSkipSet.add(qf.getName());
        }
        if (this.checkNeedJavaSpecificOutput(qf.getName(), query)) {
            this.qJavaVersionSpecificOutput.add(qf.getName());
        }
        if (this.matches(SORT_BEFORE_DIFF, query)) {
            this.qSortSet.add(qf.getName());
        } else if (this.matches(SORT_QUERY_RESULTS, query)) {
            this.qSortQuerySet.add(qf.getName());
        } else if (this.matches(HASH_QUERY_RESULTS, query)) {
            this.qHashQuerySet.add(qf.getName());
        } else if (this.matches(SORT_AND_HASH_QUERY_RESULTS, query)) {
            this.qSortNHashQuerySet.add(qf.getName());
        }
        if (this.matches(NO_SESSION_REUSE, query)) {
            this.qNoSessionReuseQuerySet.add(qf.getName());
        }
    }

    private boolean matches(Pattern pattern, String query) {
        Matcher matcher = pattern.matcher(query);
        return matcher.find();
    }

    private boolean checkHadoopVersionExclude(String fileName, String query) {
        Pattern pattern = Pattern.compile("-- (EX|IN)CLUDE_HADOOP_MAJOR_VERSIONS\\((.*)\\)");
        boolean excludeQuery = false;
        boolean includeQuery = false;
        HashSet<String> versionSet = new HashSet<String>();
        String hadoopVer = ShimLoader.getMajorVersion();
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            String prefix = matcher.group(1);
            if ("EX".equals(prefix)) {
                excludeQuery = true;
            } else {
                includeQuery = true;
            }
            String versions = matcher.group(2);
            for (String s : versions.split("\\,")) {
                s = s.trim();
                versionSet.add(s);
            }
        }
        if (matcher.find()) {
            String message = "QTestUtil: qfile " + fileName + " contains more than one reference to (EX|IN)CLUDE_HADOOP_MAJOR_VERSIONS";
            throw new UnsupportedOperationException(message);
        }
        if (excludeQuery && versionSet.contains(hadoopVer)) {
            System.out.println("QTestUtil: " + fileName + " EXCLUDE list contains Hadoop Version " + hadoopVer + ". Skipping...");
            return true;
        }
        if (includeQuery && !versionSet.contains(hadoopVer)) {
            System.out.println("QTestUtil: " + fileName + " INCLUDE list does not contain Hadoop Version " + hadoopVer + ". Skipping...");
            return true;
        }
        return false;
    }

    private boolean checkNeedJavaSpecificOutput(String fileName, String query) {
        Pattern pattern = Pattern.compile("-- JAVA_VERSION_SPECIFIC_OUTPUT");
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            System.out.println("Test is flagged to generate Java version specific output. Since we are using Java version " + javaVersion + ", we will generated Java " + javaVersion + " specific output file for query file " + fileName);
            return true;
        }
        return false;
    }

    private static String getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null) {
            throw new NullPointerException("No java version could be determined from system properties");
        }
        int pos = version.indexOf(46);
        pos = version.indexOf(46, pos + 1);
        return version.substring(0, pos);
    }

    public void clearPostTestEffects() throws Exception {
        this.setup.postTest(this.conf);
    }

    public void clearKeysCreatedInTests() {
        if (this.hes == null) {
            return;
        }
        try {
            for (String keyAlias : this.hes.getKeys()) {
                this.hes.deleteKey(keyAlias);
            }
        }
        catch (IOException e) {
            LOG.error("Fail to clean the keys created in test due to the error", (Throwable)e);
        }
    }

    public void clearUDFsCreatedDuringTests() throws Exception {
        if (System.getenv(QTEST_LEAVE_FILES) != null) {
            return;
        }
        for (String udfName : this.db.getFunctions(DEFAULT_DATABASE_NAME, ".*")) {
            if (this.srcUDFs.contains(udfName)) continue;
            this.db.dropFunction(DEFAULT_DATABASE_NAME, udfName);
        }
    }

    public void clearTablesCreatedDuringTests() throws Exception {
        Table tblObj;
        if (System.getenv(QTEST_LEAVE_FILES) != null) {
            return;
        }
        this.conf.set("hive.metastore.filter.hook", "org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl");
        this.db = Hive.get((HiveConf)this.conf);
        for (String dbName : this.db.getAllDatabases()) {
            SessionState.get().setCurrentDatabase(dbName);
            for (String tblName : this.db.getAllTables()) {
                tblObj = null;
                try {
                    tblObj = this.db.getTable(tblName);
                }
                catch (InvalidTableException e) {
                    LOG.warn("Trying to drop table " + e.getTableName() + ". But it does not exist.");
                    continue;
                }
                if (!tblObj.isMaterializedView()) continue;
                this.db.dropTable(dbName, tblName, true, true, this.fsType == FsType.encrypted_hdfs);
            }
        }
        for (String dbName : this.db.getAllDatabases()) {
            SessionState.get().setCurrentDatabase(dbName);
            for (String tblName : this.db.getAllTables()) {
                if (DEFAULT_DATABASE_NAME.equals(dbName) && this.srcTables.contains(tblName)) continue;
                tblObj = null;
                try {
                    tblObj = this.db.getTable(tblName);
                }
                catch (InvalidTableException e) {
                    LOG.warn("Trying to drop table " + e.getTableName() + ". But it does not exist.");
                    continue;
                }
                if (!tblObj.isMaterializedView()) continue;
                this.db.dropTable(dbName, tblName, true, true, this.fsType == FsType.encrypted_hdfs);
            }
            if (DEFAULT_DATABASE_NAME.equals(dbName)) continue;
            this.db.dropDatabase(dbName, true, true, true);
        }
        try {
            org.apache.hadoop.fs.Path p = new org.apache.hadoop.fs.Path(this.testWarehouse);
            FileSystem fileSystem = p.getFileSystem((Configuration)this.conf);
            if (fileSystem.exists(p)) {
                for (FileStatus status : fileSystem.listStatus(p)) {
                    if (!status.isDirectory() || this.srcTables.contains(status.getPath().getName())) continue;
                    fileSystem.delete(status.getPath(), true);
                }
            }
        }
        catch (IllegalArgumentException p) {
            // empty catch block
        }
        SessionState.get().setCurrentDatabase(DEFAULT_DATABASE_NAME);
        List roleNames = this.db.getAllRoleNames();
        for (String roleName : roleNames) {
            if ("PUBLIC".equalsIgnoreCase(roleName) || "ADMIN".equalsIgnoreCase(roleName)) continue;
            this.db.dropRole(roleName);
        }
    }

    public void clearTestSideEffects() throws Exception {
        if (System.getenv(QTEST_LEAVE_FILES) != null) {
            return;
        }
        if (CompatUtil.isPhoenix5()) {
            HiveCompatUtil.cleanupQueryResultCache();
        }
        this.conf = HiveCompatUtil.getHiveConf();
        this.initConf();
        this.initConfFromSetup();
        this.db = Hive.get((HiveConf)this.conf);
        this.clearTablesCreatedDuringTests();
        this.clearUDFsCreatedDuringTests();
        this.clearKeysCreatedInTests();
    }

    protected void initConfFromSetup() throws Exception {
        this.setup.preTest(this.conf);
    }

    public void cleanUp() throws Exception {
        this.cleanUp(null);
    }

    public void cleanUp(String tname) throws Exception {
        boolean canReuseSession;
        boolean bl = canReuseSession = tname == null || !this.qNoSessionReuseQuerySet.contains(tname);
        if (!this.isSessionStateStarted) {
            this.startSessionState(canReuseSession);
        }
        if (System.getenv(QTEST_LEAVE_FILES) != null) {
            return;
        }
        this.clearTablesCreatedDuringTests();
        this.clearUDFsCreatedDuringTests();
        this.clearKeysCreatedInTests();
        File cleanupFile = new File(this.cleanupScript);
        if (cleanupFile.isFile()) {
            String cleanupCommands = this.readEntireFileIntoString(cleanupFile);
            LOG.info("Cleanup (" + this.cleanupScript + "):\n" + cleanupCommands);
            if (this.cliDriver == null) {
                this.cliDriver = new CliDriver();
            }
            SessionState.get().getConf().setBoolean("hive.test.shutdown.phase", true);
            int result = this.cliDriver.processLine(cleanupCommands);
            if (result != 0) {
                LOG.error("Failed during cleanup processLine with code={}. Ignoring", (Object)result);
            }
            SessionState.get().getConf().setBoolean("hive.test.shutdown.phase", false);
        } else {
            LOG.info("No cleanup script detected. Skipping.");
        }
        org.apache.hadoop.fs.Path p = new org.apache.hadoop.fs.Path(this.testWarehouse);
        FileSystem fs = p.getFileSystem((Configuration)this.conf);
        try {
            FileStatus[] ls = fs.listStatus(p);
            for (int i = 0; ls != null && i < ls.length; ++i) {
                fs.delete(ls[i].getPath(), true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        FunctionRegistry.unregisterTemporaryUDF((String)"test_udaf");
        FunctionRegistry.unregisterTemporaryUDF((String)"test_error");
    }

    protected void runCreateTableCmd(String createTableCmd) throws Exception {
        int ecode = 0;
        ecode = HiveCompatUtil.getDriverResponseCode((Object)this.drv, (String)createTableCmd);
        if (ecode != 0) {
            throw new Exception("create table command: " + createTableCmd + " failed with exit code= " + ecode);
        }
    }

    protected void runCmd(String cmd) throws Exception {
        int ecode = 0;
        ecode = HiveCompatUtil.getDriverResponseCode((Object)this.drv, (String)cmd);
        HiveCompatUtil.closeDriver((Object)this.drv);
        if (ecode != 0) {
            throw new Exception("command: " + cmd + " failed with exit code= " + ecode);
        }
    }

    public void createSources() throws Exception {
        this.createSources(null);
    }

    public void createSources(String tname) throws Exception {
        boolean canReuseSession;
        boolean bl = canReuseSession = tname == null || !this.qNoSessionReuseQuerySet.contains(tname);
        if (!this.isSessionStateStarted) {
            this.startSessionState(canReuseSession);
        }
        if (this.cliDriver == null) {
            this.cliDriver = new CliDriver();
        }
        this.cliDriver.processLine("set test.data.dir=" + this.testFiles + ";");
        File scriptFile = new File(this.initScript);
        if (!scriptFile.isFile()) {
            LOG.info("No init script detected. Skipping");
            return;
        }
        this.conf.setBoolean("hive.test.init.phase", true);
        String initCommands = this.readEntireFileIntoString(scriptFile);
        LOG.info("Initial setup (" + this.initScript + "):\n" + initCommands);
        int result = this.cliDriver.processLine(initCommands);
        LOG.info("Result from cliDrriver.processLine in createSources=" + result);
        if (result != 0) {
            Assert.fail((String)("Failed during createSources processLine with code=" + result));
        }
        this.conf.setBoolean("hive.test.init.phase", false);
    }

    public void init() throws Exception {
        if (this.mr != null) {
            this.createRemoteDirs();
        }
        if (CompatUtil.isPhoenix5()) {
            HiveCompatUtil.initHiveMaterializedViewsRegistry();
        }
        this.testWarehouse = this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        String execEngine = this.conf.get("hive.execution.engine");
        this.conf.set("hive.execution.engine", "mr");
        SessionState.start((HiveConf)this.conf);
        this.conf.set("hive.execution.engine", execEngine);
        this.db = Hive.get((HiveConf)this.conf);
        this.drv = HiveCompatUtil.getDriver((HiveConf)this.conf);
        if (CompatUtil.isPhoenix4()) {
            HiveCompatUtil.initHiveMaterializedViewsRegistry((Hive)this.db);
        }
        this.pd = new ParseDriver();
        this.sem = new SemanticAnalyzer(this.queryState);
    }

    public void init(String tname) throws Exception {
        this.cleanUp(tname);
        this.createSources(tname);
        this.cliDriver.processCmd("set hive.cli.print.header=true;");
    }

    public void cliInit(String tname) throws Exception {
        this.cliInit(tname, true);
    }

    public String cliInit(String tname, boolean recreate) throws Exception {
        boolean canReuseSession;
        if (recreate) {
            this.cleanUp(tname);
            this.createSources(tname);
        }
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER, (String)"org.apache.hadoop.hive.ql.security.DummyAuthenticator");
        Utilities.clearWorkMap((Configuration)this.conf);
        CliSessionState ss = new CliSessionState(this.conf);
        assert (ss != null);
        ss.in = System.in;
        String outFileExtension = this.getOutFileExtension(tname);
        String stdoutName = null;
        if (this.outDir != null) {
            File qf = new File(this.outDir, tname);
            stdoutName = qf.getName().concat(outFileExtension);
        } else {
            stdoutName = tname + outFileExtension;
        }
        File outf = new File(this.logDir, stdoutName);
        BufferedOutputStream fo = new BufferedOutputStream(new FileOutputStream(outf));
        ss.out = this.qSortQuerySet.contains(tname) ? new SortPrintStream((OutputStream)fo, UTF_8) : (this.qHashQuerySet.contains(tname) ? new DigestPrintStream((OutputStream)fo, UTF_8) : (this.qSortNHashQuerySet.contains(tname) ? new SortAndDigestPrintStream((OutputStream)fo, UTF_8) : new PrintStream((OutputStream)fo, true, UTF_8)));
        ss.err = new CachingPrintStream((OutputStream)fo, true, UTF_8);
        ss.setIsSilent(true);
        SessionState oldSs = SessionState.get();
        boolean bl = canReuseSession = !this.qNoSessionReuseQuerySet.contains(tname);
        if (oldSs != null && canReuseSession && this.clusterType.getCoreClusterType() == CoreClusterType.TEZ) {
            TezSessionState tezSessionState = oldSs.getTezSession();
            oldSs.setTezSession(null);
            ss.setTezSession(tezSessionState);
            oldSs.close();
        }
        if (oldSs != null && this.clusterType.getCoreClusterType() == CoreClusterType.SPARK) {
            this.sparkSession = oldSs.getSparkSession();
            ss.setSparkSession(this.sparkSession);
            oldSs.setSparkSession(null);
            oldSs.close();
        }
        if (oldSs != null && oldSs.out != null && oldSs.out != System.out) {
            oldSs.out.close();
        }
        if (oldSs != null) {
            oldSs.close();
        }
        SessionState.start((SessionState)ss);
        this.cliDriver = new CliDriver();
        if (tname.equals("init_file.q")) {
            ss.initFiles.add(HIVE_ROOT + "/data/scripts/test_init_file.sql");
        }
        this.cliDriver.processInitFiles(ss);
        return outf.getAbsolutePath();
    }

    private CliSessionState startSessionState(boolean canReuseSession) throws IOException {
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER, (String)"org.apache.hadoop.hive.ql.security.DummyAuthenticator");
        String execEngine = this.conf.get("hive.execution.engine");
        this.conf.set("hive.execution.engine", "mr");
        CliSessionState ss = new CliSessionState(this.conf);
        assert (ss != null);
        ss.in = System.in;
        ss.out = System.out;
        ss.err = System.out;
        SessionState oldSs = SessionState.get();
        if (oldSs != null && canReuseSession && this.clusterType.getCoreClusterType() == CoreClusterType.TEZ) {
            TezSessionState tezSessionState = oldSs.getTezSession();
            ss.setTezSession(tezSessionState);
            oldSs.setTezSession(null);
            oldSs.close();
        }
        if (oldSs != null && this.clusterType.getCoreClusterType() == CoreClusterType.SPARK) {
            this.sparkSession = oldSs.getSparkSession();
            ss.setSparkSession(this.sparkSession);
            oldSs.setSparkSession(null);
            oldSs.close();
        }
        if (oldSs != null && oldSs.out != null && oldSs.out != System.out) {
            oldSs.out.close();
        }
        if (oldSs != null) {
            oldSs.close();
        }
        SessionState.start((SessionState)ss);
        this.isSessionStateStarted = true;
        this.conf.set("hive.execution.engine", execEngine);
        return ss;
    }

    public int executeAdhocCommand(String q) {
        if (!q.contains(";")) {
            return -1;
        }
        String q1 = q.split(";")[0] + ";";
        LOG.debug("Executing " + q1);
        return this.cliDriver.processLine(q1);
    }

    public int executeOne(String tname) {
        String q = this.qMap.get(tname);
        if (q.indexOf(";") == -1) {
            return -1;
        }
        String q1 = q.substring(0, q.indexOf(";") + 1);
        String qrest = q.substring(q.indexOf(";") + 1);
        this.qMap.put(tname, qrest);
        System.out.println("Executing " + q1);
        return this.cliDriver.processLine(q1);
    }

    public int execute(String tname) {
        return HiveCompatUtil.getDriverResponseCode((Object)this.drv, (String)this.qMap.get(tname));
    }

    public int executeClient(String tname1, String tname2) {
        String commands = this.getCommand(tname1) + CRLF + this.getCommand(tname2);
        return this.executeClientInternal(commands);
    }

    public int executeClient(String tname) {
        return this.executeClientInternal(this.getCommand(tname));
    }

    private int executeClientInternal(String commands) {
        List cmds = CliDriver.splitSemiColon((String)commands);
        int rc = 0;
        String command = "";
        for (String oneCmd : cmds) {
            if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
                command = command + org.apache.commons.lang3.StringUtils.chop((String)oneCmd) + "\\;";
                continue;
            }
            command = this.isHiveCommand(oneCmd) ? oneCmd : command + oneCmd;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)command)) continue;
            rc = this.isCommandUsedForTesting(command) ? this.executeTestCommand(command) : this.cliDriver.processLine(command);
            if (rc != 0 && !this.ignoreErrors()) break;
            command = "";
        }
        if (rc == 0 && SessionState.get() != null) {
            SessionState.get().setLastCommand(null);
        }
        return rc;
    }

    private boolean ignoreErrors() {
        return this.conf.getBoolVar(HiveConf.ConfVars.CLIIGNOREERRORS);
    }

    private boolean isHiveCommand(String command) {
        String[] cmd = command.trim().split("\\s+");
        if (HiveCommand.find((String[])cmd) != null) {
            return true;
        }
        return HiveCommand.find((String[])cmd, (boolean)true) != null;
    }

    private int executeTestCommand(String command) {
        String commandName = command.trim().split("\\s+")[0];
        String commandArgs = command.trim().substring(commandName.length());
        if (commandArgs.endsWith(";")) {
            commandArgs = org.apache.commons.lang3.StringUtils.chop((String)commandArgs);
        }
        String wareHouseDir = SessionState.get().getConf().getVar(HiveConf.ConfVars.METASTOREWAREHOUSE).replaceAll("^[a-zA-Z]+://.*?:\\d+", "");
        commandArgs = commandArgs.replaceAll("\\$\\{hiveconf:hive\\.metastore\\.warehouse\\.dir\\}", wareHouseDir);
        if (SessionState.get() != null) {
            SessionState.get().setLastCommand(commandName + " " + commandArgs.trim());
        }
        this.enableTestOnlyCmd(SessionState.get().getConf());
        try {
            CommandProcessor proc = this.getTestCommand(commandName);
            if (proc != null) {
                CommandProcessorResponse response = proc.run(commandArgs.trim());
                int rc = response.getResponseCode();
                if (rc != 0) {
                    SessionState.getConsole().printError(response.toString(), response.getException() != null ? Throwables.getStackTraceAsString((Throwable)response.getException()) : "");
                }
                return rc;
            }
            throw new RuntimeException("Could not get CommandProcessor for command: " + commandName);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute test command", e);
        }
    }

    private CommandProcessor getTestCommand(String commandName) throws SQLException {
        HiveCommand testCommand = HiveCommand.find((String[])new String[]{commandName}, (boolean)true);
        if (testCommand == null) {
            return null;
        }
        return CommandProcessorFactory.getForHiveCommandInternal((String[])new String[]{commandName}, (HiveConf)SessionState.get().getConf(), (boolean)testCommand.isOnlyForTesting());
    }

    private void enableTestOnlyCmd(HiveConf conf) {
        StringBuilder securityCMDs = new StringBuilder(conf.getVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST));
        for (String c : this.testOnlyCommands) {
            securityCMDs.append(",");
            securityCMDs.append(c);
        }
        conf.set(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.toString(), securityCMDs.toString());
    }

    private boolean isCommandUsedForTesting(String command) {
        String commandName = command.trim().split("\\s+")[0];
        HiveCommand testCommand = HiveCommand.find((String[])new String[]{commandName}, (boolean)true);
        return testCommand != null;
    }

    private String getCommand(String tname) {
        String commands = this.qMap.get(tname);
        StringBuilder newCommands = new StringBuilder(commands.length());
        int lastMatchEnd = 0;
        Matcher commentMatcher = Pattern.compile("^--.*$", 8).matcher(commands);
        while (commentMatcher.find()) {
            newCommands.append(commands.substring(lastMatchEnd, commentMatcher.start()));
            lastMatchEnd = commentMatcher.end();
        }
        newCommands.append(commands.substring(lastMatchEnd, commands.length()));
        commands = newCommands.toString();
        return commands;
    }

    public boolean shouldBeSkipped(String tname) {
        return this.qSkipSet.contains(tname);
    }

    private String getOutFileExtension(String fname) {
        String outFileExtension = ".out";
        if (this.qJavaVersionSpecificOutput.contains(fname)) {
            outFileExtension = ".java" + javaVersion + ".out";
        }
        return outFileExtension;
    }

    public void convertSequenceFileToTextFile() throws Exception {
        this.testWarehouse = this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        this.db = Hive.get((HiveConf)this.conf);
        HiveCompatUtil.getDriverResponseCode((Object)this.drv, (String)"FROM dest4_sequencefile INSERT OVERWRITE TABLE dest4 SELECT dest4_sequencefile.*");
        this.db.dropTable(DEFAULT_DATABASE_NAME, "dest4_sequencefile", true, true);
    }

    public QTestProcessExecResult checkNegativeResults(String tname, Exception e) throws Exception {
        String outFileExtension = this.getOutFileExtension(tname);
        File qf = new File(this.outDir, tname);
        String expf = this.outPath(this.outDir.toString(), tname.concat(outFileExtension));
        File outf = null;
        outf = new File(this.logDir);
        outf = new File(outf, qf.getName().concat(outFileExtension));
        FileWriter outfd = new FileWriter(outf);
        if (e instanceof ParseException) {
            outfd.write("Parse Error: ");
        } else if (e instanceof SemanticException) {
            outfd.write("Semantic Exception: \n");
        } else {
            throw e;
        }
        outfd.write(e.getMessage());
        outfd.close();
        QTestProcessExecResult result = QTestUtil.executeDiffCommand(outf.getPath(), expf, false, this.qSortSet.contains(qf.getName()));
        if (this.overWrite) {
            QTestUtil.overwriteResults(outf.getPath(), expf);
            return QTestProcessExecResult.createWithoutOutput(0);
        }
        return result;
    }

    public QTestProcessExecResult checkParseResults(String tname, ASTNode tree) throws Exception {
        if (tree != null) {
            String outFileExtension = this.getOutFileExtension(tname);
            File parseDir = new File(this.outDir, "parse");
            String expf = this.outPath(parseDir.toString(), tname.concat(outFileExtension));
            File outf = null;
            outf = new File(this.logDir);
            outf = new File(outf, tname.concat(outFileExtension));
            FileWriter outfd = new FileWriter(outf);
            outfd.write(tree.toStringTree());
            outfd.close();
            QTestProcessExecResult exitVal = QTestUtil.executeDiffCommand(outf.getPath(), expf, false, false);
            if (this.overWrite) {
                QTestUtil.overwriteResults(outf.getPath(), expf);
                return QTestProcessExecResult.createWithoutOutput(0);
            }
            return exitVal;
        }
        throw new Exception("Parse tree is null");
    }

    public String outPath(String outDir, String testName) {
        String ret = new File(outDir, testName).getPath();
        ArrayList<String> configs = new ArrayList<String>();
        configs.add(this.clusterType.toString());
        configs.add(this.hadoopVer);
        LinkedList<String> stack = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(testName);
        stack.push(sb.toString());
        for (String s : configs) {
            sb.append('_');
            sb.append(s);
            stack.push(sb.toString());
        }
        while (stack.size() > 0) {
            String fileName = (String)stack.pop();
            File f = new File(outDir, fileName);
            if (!f.exists()) continue;
            ret = f.getPath();
            break;
        }
        return ret;
    }

    private Pattern[] toPattern(String[] patternStrs) {
        Pattern[] patterns = new Pattern[patternStrs.length];
        for (int i = 0; i < patternStrs.length; ++i) {
            patterns[i] = Pattern.compile(patternStrs[i]);
        }
        return patterns;
    }

    private void maskPatterns(Pattern[] patterns, String fname) throws Exception {
        String line;
        String maskPattern = "#### A masked pattern was here ####";
        String partialMaskPattern = "#### A PARTIAL masked pattern was here ####";
        File file = new File(fname);
        File fileOrig = new File(fname + ".orig");
        FileUtils.copyFile((File)file, (File)fileOrig);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileOrig), UTF_8));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8));
        boolean lastWasMasked = false;
        boolean partialMaskWasMatched = false;
        while (null != (line = in.readLine())) {
            Matcher matcher;
            if (this.fsType == FsType.encrypted_hdfs) {
                for (Pattern pattern : this.partialReservedPlanMask) {
                    matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    line = partialMaskPattern + " " + matcher.group(0);
                    partialMaskWasMatched = true;
                    break;
                }
            } else {
                for (PatternReplacementPair patternReplacementPair : this.partialPlanMask) {
                    matcher = patternReplacementPair.pattern.matcher(line);
                    if (!matcher.find()) continue;
                    line = line.replaceAll(patternReplacementPair.pattern.pattern(), patternReplacementPair.replacement);
                    partialMaskWasMatched = true;
                }
            }
            if (!partialMaskWasMatched) {
                for (Pair pair : this.patternsWithMaskComments) {
                    Pattern pattern = (Pattern)pair.getLeft();
                    String string = (String)pair.getRight();
                    matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    line = matcher.replaceAll(string);
                    partialMaskWasMatched = true;
                    break;
                }
                for (Pattern pattern : patterns) {
                    line = pattern.matcher(line).replaceAll(maskPattern);
                }
            }
            if (line.equals(maskPattern)) {
                if (lastWasMasked) continue;
                out.write(line);
                out.write("\n");
                lastWasMasked = true;
                partialMaskWasMatched = false;
                continue;
            }
            out.write(line);
            out.write("\n");
            lastWasMasked = false;
            partialMaskWasMatched = false;
        }
        in.close();
        out.close();
    }

    private Pair<Pattern, String> toPatternPair(String patternStr, String maskComment) {
        return ImmutablePair.of((Object)Pattern.compile(patternStr), (Object)maskComment);
    }

    public void addPatternWithMaskComment(String patternStr, String maskComment) {
        this.patternsWithMaskComments.add(this.toPatternPair(patternStr, maskComment));
    }

    public QTestProcessExecResult checkCliDriverResults(String tname) throws Exception {
        assert (this.qMap.containsKey(tname));
        String outFileExtension = this.getOutFileExtension(tname);
        String outFileName = this.outPath(this.outDir, tname + outFileExtension);
        File f = new File(this.logDir, tname + outFileExtension);
        this.maskPatterns(this.planMask, f.getPath());
        QTestProcessExecResult exitVal = QTestUtil.executeDiffCommand(f.getPath(), outFileName, false, this.qSortSet.contains(tname));
        if (this.overWrite) {
            QTestUtil.overwriteResults(f.getPath(), outFileName);
            return QTestProcessExecResult.createWithoutOutput(0);
        }
        return exitVal;
    }

    public QTestProcessExecResult checkCompareCliDriverResults(String tname, List<String> outputs) throws Exception {
        assert (outputs.size() > 1);
        this.maskPatterns(this.planMask, outputs.get(0));
        for (int i = 1; i < outputs.size(); ++i) {
            this.maskPatterns(this.planMask, outputs.get(i));
            QTestProcessExecResult result = QTestUtil.executeDiffCommand(outputs.get(i - 1), outputs.get(i), false, this.qSortSet.contains(tname));
            if (result.getReturnCode() == 0) continue;
            System.out.println("Files don't match: " + outputs.get(i - 1) + " and " + outputs.get(i));
            return result;
        }
        return QTestProcessExecResult.createWithoutOutput(0);
    }

    private static void overwriteResults(String inFileName, String outFileName) throws Exception {
        System.out.println("Overwriting results " + inFileName + " to " + outFileName);
        int result = QTestUtil.executeCmd(new String[]{"cp", QTestUtil.getQuotedString(inFileName), QTestUtil.getQuotedString(outFileName)}).getReturnCode();
        if (result != 0) {
            throw new IllegalStateException("Unexpected error while overwriting " + inFileName + " with " + outFileName);
        }
    }

    private static QTestProcessExecResult executeDiffCommand(String inFileName, String outFileName, boolean ignoreWhiteSpace, boolean sortResults) throws Exception {
        if (sortResults) {
            SessionState ss = SessionState.get();
            if (ss != null && ss.out != null && ss.out != System.out) {
                ss.out.close();
            }
            String inSorted = inFileName + SORT_SUFFIX;
            String outSorted = outFileName + SORT_SUFFIX;
            QTestUtil.sortFiles(inFileName, inSorted);
            QTestUtil.sortFiles(outFileName, outSorted);
            inFileName = inSorted;
            outFileName = outSorted;
        }
        ArrayList<String> diffCommandArgs = new ArrayList<String>();
        diffCommandArgs.add("diff");
        diffCommandArgs.add("-a");
        if (ignoreWhiteSpace) {
            diffCommandArgs.add("-b");
        }
        diffCommandArgs.add(QTestUtil.getQuotedString(inFileName));
        diffCommandArgs.add(QTestUtil.getQuotedString(outFileName));
        QTestProcessExecResult result = QTestUtil.executeCmd(diffCommandArgs);
        if (sortResults) {
            new File(inFileName).delete();
            new File(outFileName).delete();
        }
        return result;
    }

    private static void sortFiles(String in, String out) throws Exception {
        int result = QTestUtil.executeCmd(new String[]{"sort", QTestUtil.getQuotedString(in)}, out, null).getReturnCode();
        if (result != 0) {
            throw new IllegalStateException("Unexpected error while sorting " + in);
        }
    }

    private static QTestProcessExecResult executeCmd(Collection<String> args) throws Exception {
        return QTestUtil.executeCmd(args, null, null);
    }

    private static QTestProcessExecResult executeCmd(String[] args) throws Exception {
        return QTestUtil.executeCmd(args, null, null);
    }

    private static QTestProcessExecResult executeCmd(Collection<String> args, String outFile, String errFile) throws Exception {
        String[] cmdArray = args.toArray(new String[args.size()]);
        return QTestUtil.executeCmd(cmdArray, outFile, errFile);
    }

    private static QTestProcessExecResult executeCmd(String[] args, String outFile, String errFile) throws Exception {
        System.out.println("Running: " + org.apache.commons.lang3.StringUtils.join((Object[])args, (char)' '));
        PrintStream out = outFile == null ? SessionState.getConsole().getChildOutStream() : new PrintStream((OutputStream)new FileOutputStream(outFile), true, UTF_8);
        PrintStream err = errFile == null ? SessionState.getConsole().getChildErrStream() : new PrintStream((OutputStream)new FileOutputStream(errFile), true, UTF_8);
        Process executor = Runtime.getRuntime().exec(args);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream str = new PrintStream((OutputStream)bos, true, UTF_8);
        StreamPrinter errPrinter = new StreamPrinter(executor.getErrorStream(), null, new PrintStream[]{err});
        StreamPrinter outPrinter = new StreamPrinter(executor.getInputStream(), null, new PrintStream[]{out, str});
        outPrinter.start();
        errPrinter.start();
        int result = executor.waitFor();
        outPrinter.join();
        errPrinter.join();
        if (outFile != null) {
            out.close();
        }
        if (errFile != null) {
            err.close();
        }
        return QTestProcessExecResult.create(result, new String(bos.toByteArray(), StandardCharsets.UTF_8));
    }

    private static String getQuotedString(String str) {
        return str;
    }

    public ASTNode parseQuery(String tname) throws Exception {
        return this.pd.parse(this.qMap.get(tname));
    }

    public void resetParser() throws SemanticException {
        this.pd = new ParseDriver();
        this.queryState = HiveCompatUtil.getQueryState((HiveConf)this.conf);
        this.sem = new SemanticAnalyzer(this.queryState);
    }

    public List<Task<? extends Serializable>> analyzeAST(ASTNode ast) throws Exception {
        Context ctx = new Context((Configuration)this.conf);
        while (ast.getToken() == null && ast.getChildCount() > 0) {
            ast = (ASTNode)ast.getChild(0);
        }
        this.sem.getOutputs().clear();
        this.sem.getInputs().clear();
        this.sem.analyze(ast, ctx);
        ctx.clear();
        return this.sem.getRootTasks();
    }

    public TreeMap<String, String> getQMap() {
        return this.qMap;
    }

    public static QTestUtil[] queryListRunnerSetup(File[] qfiles, String resDir, String logDir, String initScript, String cleanupScript) throws Exception {
        QTestUtil[] qt = new QTestUtil[qfiles.length];
        for (int i = 0; i < qfiles.length; ++i) {
            qt[i] = new QTestUtil(resDir, logDir, MiniClusterType.none, null, "0.20", initScript == null ? defaultInitScript : initScript, cleanupScript == null ? defaultCleanupScript : cleanupScript, false);
            qt[i].addFile(qfiles[i]);
            qt[i].clearTestSideEffects();
        }
        return qt;
    }

    public static boolean queryListRunnerSingleThreaded(File[] qfiles, QTestUtil[] qt) throws Exception {
        boolean failed = false;
        qt[0].cleanUp();
        qt[0].createSources();
        for (int i = 0; i < qfiles.length && !failed; ++i) {
            qt[i].clearTestSideEffects();
            qt[i].cliInit(qfiles[i].getName(), false);
            qt[i].executeClient(qfiles[i].getName());
            QTestProcessExecResult result = qt[i].checkCliDriverResults(qfiles[i].getName());
            if (result.getReturnCode() != 0) {
                failed = true;
                StringBuilder builder = new StringBuilder();
                builder.append("Test ").append(qfiles[i].getName()).append(" results check failed with error code ").append(result.getReturnCode());
                if (Strings.isNotEmpty((CharSequence)result.getCapturedOutput())) {
                    builder.append(" and diff value ").append(result.getCapturedOutput());
                }
                System.err.println(builder.toString());
                QTestUtil.outputTestFailureHelpMessage();
            }
            qt[i].clearPostTestEffects();
        }
        return !failed;
    }

    public static boolean queryListRunnerMultiThreaded(File[] qfiles, QTestUtil[] qt) throws Exception {
        int i;
        boolean failed = false;
        qt[0].cleanUp();
        qt[0].createSources();
        qt[0].clearTestSideEffects();
        QTRunner[] qtRunners = new QTRunner[qfiles.length];
        Thread[] qtThread = new Thread[qfiles.length];
        for (i = 0; i < qfiles.length; ++i) {
            qtRunners[i] = new QTRunner(qt[i], qfiles[i].getName());
            qtThread[i] = new Thread(qtRunners[i]);
        }
        for (i = 0; i < qfiles.length; ++i) {
            qtThread[i].start();
        }
        for (i = 0; i < qfiles.length; ++i) {
            qtThread[i].join();
            QTestProcessExecResult result = qt[i].checkCliDriverResults(qfiles[i].getName());
            if (result.getReturnCode() == 0) continue;
            failed = true;
            StringBuilder builder = new StringBuilder();
            builder.append("Test ").append(qfiles[i].getName()).append(" results check failed with error code ").append(result.getReturnCode());
            if (Strings.isNotEmpty((CharSequence)result.getCapturedOutput())) {
                builder.append(" and diff value ").append(result.getCapturedOutput());
            }
            System.err.println(builder.toString());
            QTestUtil.outputTestFailureHelpMessage();
        }
        return !failed;
    }

    public static void outputTestFailureHelpMessage() {
        System.err.println("See ./ql/target/tmp/log/hive.log or ./itests/qtest/target/tmp/log/hive.log, or check ./ql/target/surefire-reports or ./itests/qtest/target/surefire-reports/ for specific test cases logs.");
        System.err.flush();
    }

    public static List<String> getVersionFiles(String queryDir, String tname) {
        QTestUtil.ensureQvFileList(queryDir);
        List<String> result = QTestUtil.getVersionFilesInternal(tname);
        if (result == null) {
            result = cachedDefaultQvFileList;
        }
        return result;
    }

    private static void ensureQvFileList(String queryDir) {
        if (cachedQvFileList != null) {
            return;
        }
        System.out.println("Getting versions from " + queryDir);
        cachedQvFileList = new File(queryDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".qv");
            }
        });
        if (cachedQvFileList == null) {
            return;
        }
        Arrays.sort(cachedQvFileList, String.CASE_INSENSITIVE_ORDER);
        List<String> defaults = QTestUtil.getVersionFilesInternal("default");
        cachedDefaultQvFileList = defaults != null ? ImmutableList.copyOf(defaults) : ImmutableList.of();
    }

    private static List<String> getVersionFilesInternal(String tname) {
        String candidate;
        if (cachedQvFileList == null) {
            return new ArrayList<String>();
        }
        int pos = Arrays.binarySearch(cachedQvFileList, tname, String.CASE_INSENSITIVE_ORDER);
        if (pos >= 0) {
            throw new BuildException("Unexpected file list element: " + cachedQvFileList[pos]);
        }
        ArrayList<String> result = null;
        for (pos = -pos - 1; pos < cachedQvFileList.length && (candidate = cachedQvFileList[pos]).length() > tname.length() && tname.equalsIgnoreCase(candidate.substring(0, tname.length())) && qvSuffix.matcher(candidate.substring(tname.length())).matches(); ++pos) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(candidate);
        }
        return result;
    }

    public void failed(int ecode, String fname, String debugHint) {
        String command = SessionState.get() != null ? SessionState.get().getLastCommand() : null;
        String message = "Client execution failed with error code = " + ecode + (command != null ? " running \"" + command : "") + "\" fname=" + fname + " " + (debugHint != null ? debugHint : "");
        LOG.error(message);
        Assert.fail((String)message);
    }

    public void failed(String fname, String debugHint) {
        Assert.fail((String)("Client Execution was expected to fail, but succeeded with error code 0 for fname=" + fname + (debugHint != null ? " " + debugHint : "")));
    }

    public void failedDiff(int ecode, String fname, String debugHint) {
        String message = "Client Execution succeeded but contained differences (error code = " + ecode + ") after executing " + fname + (debugHint != null ? " " + debugHint : "");
        LOG.error(message);
        Assert.fail((String)message);
    }

    public void failed(Exception e, String fname, String debugHint) {
        String command = SessionState.get() != null ? SessionState.get().getLastCommand() : null;
        System.err.println("Failed query: " + fname);
        System.err.flush();
        Assert.fail((String)("Unexpected exception " + StringUtils.stringifyException((Throwable)e) + "\n" + (command != null ? " running " + command : "") + (debugHint != null ? debugHint : "")));
    }

    public static void addTestsToSuiteFromQfileNames(String qFileNamesFile, Set<String> qFilesToExecute, TestSuite suite, Object setup, SuiteAddTestFunctor suiteAddTestCallback) {
        try {
            File qFileNames = new File(qFileNamesFile);
            FileReader fr = new FileReader(qFileNames.getCanonicalFile());
            BufferedReader br = new BufferedReader(fr);
            String fName = null;
            while ((fName = br.readLine()) != null) {
                int eIdx;
                if (fName.isEmpty() || fName.trim().equals("") || (eIdx = fName.indexOf(46)) == -1) continue;
                String tName = fName.substring(0, eIdx);
                if (!qFilesToExecute.isEmpty() && !qFilesToExecute.contains(fName)) continue;
                suiteAddTestCallback.addTestToSuite(suite, setup, tName);
            }
            br.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupMetaStoreTableColumnStatsFor30TBTPCDSWorkload(HiveConf conf) {
        Connection conn = null;
        ArrayList<PreparedStatement> statements = new ArrayList<PreparedStatement>();
        try {
            String command;
            Properties props = new Properties();
            props.put("user", conf.get("javax.jdo.option.ConnectionUserName"));
            props.put("password", conf.get("javax.jdo.option.ConnectionPassword"));
            conn = DriverManager.getConnection(conf.get("javax.jdo.option.ConnectionURL"), props);
            ResultSet rs = null;
            Statement s = conn.createStatement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected to metastore database ");
            }
            String mdbPath = HIVE_ROOT + "/data/files/tpcds-perf/metastore_export/";
            BufferedReader br = new BufferedReader(new FileReader(new File(HIVE_ROOT + "/metastore/scripts/upgrade/derby/022-HIVE-11107.derby.sql")));
            s.execute("DROP TABLE APP.TABLE_PARAMS");
            s.execute("DROP TABLE APP.TAB_COL_STATS");
            while ((command = br.readLine()) != null) {
                if (!command.endsWith(";")) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to run command : " + command);
                }
                try {
                    PreparedStatement psCommand = conn.prepareStatement(command.substring(0, command.length() - 1));
                    statements.add(psCommand);
                    psCommand.execute();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("successfully completed " + command);
                }
                catch (SQLException e) {
                    LOG.info("Got SQL Exception " + e.getMessage());
                }
            }
            br.close();
            Path tabColStatsCsv = FileSystems.getDefault().getPath(mdbPath, "csv", "TAB_COL_STATS.txt.bz2");
            Path tabParamsCsv = FileSystems.getDefault().getPath(mdbPath, "csv", "TABLE_PARAMS.txt.bz2");
            String tmpBaseDir = System.getProperty(TEST_TMP_DIR_PROPERTY);
            Path tmpFileLoc1 = FileSystems.getDefault().getPath(tmpBaseDir, "TAB_COL_STATS.txt");
            Path tmpFileLoc2 = FileSystems.getDefault().getPath(tmpBaseDir, "TABLE_PARAMS.txt");
            class MyComp
            implements Comparator<String> {
                MyComp() {
                }

                @Override
                public int compare(String str1, String str2) {
                    if (str2.length() != str1.length()) {
                        return str2.length() - str1.length();
                    }
                    return str1.compareTo(str2);
                }
            }
            TreeMap<String, Integer> tableNameToID = new TreeMap<String, Integer>(new MyComp());
            rs = s.executeQuery("SELECT * FROM APP.TBLS");
            while (rs.next()) {
                String tblName = rs.getString("TBL_NAME");
                Integer tblId = rs.getInt("TBL_ID");
                tableNameToID.put(tblName, tblId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Resultset : " + tblName + " | " + tblId);
            }
            HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>();
            rs = s.executeQuery("select TBLS.TBL_NAME, a.COLUMN_NAME, a.TYPE_NAME from  (select COLUMN_NAME, TYPE_NAME, SDS.SD_ID from APP.COLUMNS_V2 join APP.SDS on SDS.CD_ID = COLUMNS_V2.CD_ID) a join APP.TBLS on  TBLS.SD_ID = a.SD_ID");
            while (rs.next()) {
                String tblName = rs.getString(1);
                String colName = rs.getString(2);
                String typeName = rs.getString(3);
                HashMap<String, String> cols = (HashMap<String, String>)data.get(tblName);
                if (null == cols) {
                    cols = new HashMap<String, String>();
                }
                cols.put(colName, typeName);
                data.put(tblName, cols);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BZip2CompressorInputStream(Files.newInputStream(tabColStatsCsv, StandardOpenOption.READ))));
            Stream<String> replaced = ((Stream)reader.lines().parallel()).map(str -> {
                String[] splits = str.split(",");
                String tblName = splits[0];
                String colName = splits[1];
                Integer tblID = (Integer)tableNameToID.get(tblName);
                StringBuilder sb = new StringBuilder("default@" + tblName + "@" + colName + "@" + (String)((Map)data.get(tblName)).get(colName) + "@");
                for (int i = 2; i < splits.length; ++i) {
                    sb.append(splits[i] + "@");
                }
                return sb.append(tblID).append("@").toString();
            });
            Files.write(tmpFileLoc1, replaced::iterator, new OpenOption[0]);
            replaced.close();
            reader.close();
            BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new BZip2CompressorInputStream(Files.newInputStream(tabParamsCsv, StandardOpenOption.READ))));
            ConcurrentHashMap colStats = new ConcurrentHashMap();
            Stream<String> replacedStream = ((Stream)reader2.lines().parallel()).map(str -> {
                String[] splits = str.split("_@");
                String tblName = splits[0];
                Integer tblId = (Integer)tableNameToID.get(tblName);
                Map cols = (Map)data.get(tblName);
                StringBuilder sb = new StringBuilder();
                sb.append("{\"COLUMN_STATS\":{");
                for (String colName : cols.keySet()) {
                    sb.append("\"" + colName + "\":\"true\",");
                }
                sb.append("},\"BASIC_STATS\":\"true\"}");
                colStats.put(tblId.toString(), sb.toString());
                return tblId.toString() + "@" + splits[1];
            });
            Files.write(tmpFileLoc2, replacedStream::iterator, new OpenOption[0]);
            Files.write(tmpFileLoc2, colStats.entrySet().stream().map(map -> (String)map.getKey() + "@COLUMN_STATS_ACCURATE@" + (String)map.getValue())::iterator, StandardOpenOption.APPEND);
            replacedStream.close();
            reader2.close();
            String importStatement1 = "CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, 'TAB_COL_STATS', '" + tmpFileLoc1.toAbsolutePath().toString() + "', '@', null, 'UTF-8', 1)";
            String importStatement2 = "CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, 'TABLE_PARAMS', '" + tmpFileLoc2.toAbsolutePath().toString() + "', '@', null, 'UTF-8', 1)";
            try {
                PreparedStatement psImport1 = conn.prepareStatement(importStatement1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute : " + importStatement1);
                }
                statements.add(psImport1);
                psImport1.execute();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("successfully completed " + importStatement1);
                }
                PreparedStatement psImport2 = conn.prepareStatement(importStatement2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute : " + importStatement2);
                }
                statements.add(psImport2);
                psImport2.execute();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("successfully completed " + importStatement2);
                }
            }
            catch (SQLException e) {
                LOG.info("Got SQL Exception  " + e.getMessage());
            }
        }
        catch (FileNotFoundException e1) {
            LOG.info("Got File not found Exception " + e1.getMessage());
        }
        catch (IOException e1) {
            LOG.info("Got IOException " + e1.getMessage());
        }
        catch (SQLException e1) {
            LOG.info("Got SQLException " + e1.getMessage());
        }
        finally {
            int i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                try {
                    if (st == null) continue;
                    st.close();
                    st = null;
                }
                catch (SQLException sQLException) {}
            }
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException st) {}
        }
    }

    private static String getHiveRoot() {
        String path;
        if (System.getProperty("hive.root") != null) {
            try {
                path = new File(System.getProperty("hive.root")).getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("error getting hive.root", e);
            }
        } else {
            path = new File("target").getAbsolutePath();
        }
        return QTestUtil.ensurePathEndsInSlash(new File(path).getAbsolutePath());
    }

    public static String ensurePathEndsInSlash(String path) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null");
        }
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public static class QTRunner
    implements Runnable {
        private final QTestUtil qt;
        private final String fname;

        public QTRunner(QTestUtil qt, String fname) {
            this.qt = qt;
            this.fname = fname;
        }

        @Override
        public void run() {
            try {
                this.qt.cliInit(this.fname, false);
                this.qt.executeClient(this.fname);
            }
            catch (Throwable e) {
                System.err.println("Query file " + this.fname + " failed with exception " + e.getMessage());
                e.printStackTrace();
                QTestUtil.outputTestFailureHelpMessage();
            }
        }
    }

    public static class QTestSetup {
        private MiniZooKeeperCluster zooKeeperCluster = null;
        private int zkPort;
        private ZooKeeper zooKeeper;

        public void preTest(HiveConf conf) throws Exception {
            if (this.zooKeeperCluster == null) {
                String tmpBaseDir = System.getProperty(QTestUtil.TEST_TMP_DIR_PROPERTY);
                File tmpDir = Utilities.createTempDir((String)tmpBaseDir);
                this.zooKeeperCluster = new MiniZooKeeperCluster();
                this.zkPort = this.zooKeeperCluster.startup(tmpDir);
            }
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
            }
            int sessionTimeout = (int)conf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
            this.zooKeeper = new ZooKeeper("localhost:" + this.zkPort, sessionTimeout, new Watcher(){

                public void process(WatchedEvent arg0) {
                }
            });
            String zkServer = "localhost";
            conf.set("hive.zookeeper.quorum", zkServer);
            conf.set("hive.zookeeper.client.port", "" + this.zkPort);
        }

        public void postTest(HiveConf conf) throws Exception {
            if (this.zooKeeperCluster == null) {
                return;
            }
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
            }
            ZooKeeperHiveLockManager.releaseAllLocks((HiveConf)conf);
        }

        public void tearDown() throws Exception {
            CuratorFrameworkSingleton.closeAndReleaseInstance();
            if (this.zooKeeperCluster != null) {
                this.zooKeeperCluster.shutdown();
                this.zooKeeperCluster = null;
            }
        }
    }

    private static final class PatternReplacementPair {
        private final Pattern pattern;
        private final String replacement;

        PatternReplacementPair(Pattern p, String r) {
            this.pattern = p;
            this.replacement = r;
        }
    }

    public static enum MiniClusterType {
        mr(CoreClusterType.MR, FsType.hdfs),
        tez(CoreClusterType.TEZ, FsType.hdfs),
        tez_local(CoreClusterType.TEZ, FsType.local),
        spark(CoreClusterType.SPARK, FsType.local),
        miniSparkOnYarn(CoreClusterType.SPARK, FsType.hdfs),
        llap(CoreClusterType.TEZ, FsType.hdfs),
        llap_local(CoreClusterType.TEZ, FsType.local),
        none(CoreClusterType.MR, FsType.local),
        druid(CoreClusterType.DRUID, FsType.hdfs);

        private final CoreClusterType coreClusterType;
        private final FsType defaultFsType;

        private MiniClusterType(CoreClusterType coreClusterType, FsType defaultFsType) {
            this.coreClusterType = coreClusterType;
            this.defaultFsType = defaultFsType;
        }

        public CoreClusterType getCoreClusterType() {
            return this.coreClusterType;
        }

        public FsType getDefaultFsType() {
            return this.defaultFsType;
        }

        public static MiniClusterType valueForString(String type) {
            if (type.equals("miniMR")) {
                return mr;
            }
            if (type.equals("tez")) {
                return tez;
            }
            if (type.equals("tez_local")) {
                return tez_local;
            }
            if (type.equals("spark")) {
                return spark;
            }
            if (type.equals("miniSparkOnYarn")) {
                return miniSparkOnYarn;
            }
            if (type.equals("llap")) {
                return llap;
            }
            if (type.equals("llap_local")) {
                return llap_local;
            }
            if (type.equals("druid")) {
                return druid;
            }
            return none;
        }
    }

    public static enum FsType {
        local,
        hdfs,
        encrypted_hdfs;

    }

    private static enum CoreClusterType {
        MR,
        TEZ,
        SPARK,
        DRUID;

    }

    public static interface SuiteAddTestFunctor {
        public void addTestToSuite(TestSuite var1, Object var2, String var3);
    }
}

