/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPolicies {
    public static final Logger LOG = LoggerFactory.getLogger(RetryPolicies.class);
    public static final RetryPolicy TRY_ONCE_THEN_FAIL = new TryOnceThenFail();
    public static final RetryPolicy RETRY_FOREVER = new RetryForever();

    public static final RetryPolicy retryForeverWithFixedSleep(long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(Integer.MAX_VALUE, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumTimeWithFixedSleep(maxTime, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithProportionalSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy exponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new ExponentialBackoffRetry(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryByException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new ExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy retryByRemoteException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new RemoteExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy retryOtherThanRemoteException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new OtherThanRemoteExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy failoverOnNetworkException(int maxFailovers) {
        return RetryPolicies.failoverOnNetworkException(TRY_ONCE_THEN_FAIL, maxFailovers);
    }

    public static final RetryPolicy failoverOnNetworkException(RetryPolicy fallbackPolicy, int maxFailovers) {
        return RetryPolicies.failoverOnNetworkException(fallbackPolicy, maxFailovers, 0L, 0L);
    }

    public static final RetryPolicy failoverOnNetworkException(RetryPolicy fallbackPolicy, int maxFailovers, long delayMillis, long maxDelayBase) {
        return new FailoverOnNetworkExceptionRetry(fallbackPolicy, maxFailovers, delayMillis, maxDelayBase);
    }

    public static final RetryPolicy failoverOnNetworkException(RetryPolicy fallbackPolicy, int maxFailovers, int maxRetries, long delayMillis, long maxDelayBase) {
        return new FailoverOnNetworkExceptionRetry(fallbackPolicy, maxFailovers, maxRetries, delayMillis, maxDelayBase);
    }

    private static long calculateExponentialTime(long time, int retries, long cap) {
        long baseTime = Math.min(time * (1L << retries), cap);
        return (long)((double)baseTime * (ThreadLocalRandom.current().nextDouble() + 0.5));
    }

    private static long calculateExponentialTime(long time, int retries) {
        return RetryPolicies.calculateExponentialTime(time, retries, Long.MAX_VALUE);
    }

    private static boolean shouldFailoverOnException(Exception e) {
        if (!(e instanceof RemoteException)) {
            return false;
        }
        IOException unwrapped = ((RemoteException)e).unwrapRemoteException(StandbyException.class, ObserverRetryOnActiveException.class);
        return unwrapped instanceof StandbyException;
    }

    private static boolean isSaslFailure(Exception e) {
        Throwable current = e;
        do {
            if (!(current instanceof SaslException)) continue;
            return true;
        } while ((current = current.getCause()) != null);
        return false;
    }

    static RetriableException getWrappedRetriableException(Exception e) {
        if (!(e instanceof RemoteException)) {
            return null;
        }
        IOException unwrapped = ((RemoteException)e).unwrapRemoteException(RetriableException.class);
        return unwrapped instanceof RetriableException ? (RetriableException)unwrapped : null;
    }

    private static boolean hasWrappedAccessControlException(Exception e) {
        Throwable throwable = e;
        while (!(throwable instanceof AccessControlException) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable instanceof AccessControlException;
    }

    static class FailoverOnNetworkExceptionRetry
    implements RetryPolicy {
        private RetryPolicy fallbackPolicy;
        private int maxFailovers;
        private int maxRetries;
        private long delayMillis;
        private long maxDelayBase;

        public FailoverOnNetworkExceptionRetry(RetryPolicy fallbackPolicy, int maxFailovers) {
            this(fallbackPolicy, maxFailovers, 0, 0L, 0L);
        }

        public FailoverOnNetworkExceptionRetry(RetryPolicy fallbackPolicy, int maxFailovers, long delayMillis, long maxDelayBase) {
            this(fallbackPolicy, maxFailovers, 0, delayMillis, maxDelayBase);
        }

        public FailoverOnNetworkExceptionRetry(RetryPolicy fallbackPolicy, int maxFailovers, int maxRetries, long delayMillis, long maxDelayBase) {
            this.fallbackPolicy = fallbackPolicy;
            this.maxFailovers = maxFailovers;
            this.maxRetries = maxRetries;
            this.delayMillis = delayMillis;
            this.maxDelayBase = maxDelayBase;
        }

        private long getFailoverOrRetrySleepTime(int times) {
            return times == 0 ? 0L : RetryPolicies.calculateExponentialTime(this.delayMillis, times, this.maxDelayBase);
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            if (failovers >= this.maxFailovers) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "failovers (" + failovers + ") exceeded maximum allowed (" + this.maxFailovers + ")");
            }
            if (retries - failovers > this.maxRetries) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "retries (" + retries + ") exceeded maximum allowed (" + this.maxRetries + ")");
            }
            if (RetryPolicies.isSaslFailure(e)) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "SASL failure");
            }
            if (e instanceof ConnectException || e instanceof EOFException || e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof StandbyException || e instanceof ConnectTimeoutException || RetryPolicies.shouldFailoverOnException(e)) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, this.getFailoverOrRetrySleepTime(failovers));
            }
            if (e instanceof RetriableException || RetryPolicies.getWrappedRetriableException(e) != null) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, this.getFailoverOrRetrySleepTime(retries));
            }
            if (e instanceof SecretManager.InvalidToken) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "Invalid or Cancelled Token");
            }
            if (e instanceof AccessControlException || RetryPolicies.hasWrappedAccessControlException(e)) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "Access denied");
            }
            if (e instanceof SocketException || e instanceof IOException && !(e instanceof RemoteException)) {
                if (isIdempotentOrAtMostOnce) {
                    return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, this.getFailoverOrRetrySleepTime(retries));
                }
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "the invoked method is not idempotent, and unable to determine whether it was invoked");
            }
            return this.fallbackPolicy.shouldRetry(e, retries, failovers, isIdempotentOrAtMostOnce);
        }
    }

    static class ExponentialBackoffRetry
    extends RetryLimited {
        public ExponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (maxRetries >= 63) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " >= " + 63);
            }
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return RetryPolicies.calculateExponentialTime(this.sleepTime, retries + 1);
        }
    }

    static class OtherThanRemoteExceptionDependentRetry
    implements RetryPolicy {
        private RetryPolicy defaultPolicy;
        private Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap;

        public OtherThanRemoteExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionToPolicyMap = exceptionToPolicyMap;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            RetryPolicy policy = null;
            if (!(e instanceof RemoteException)) {
                policy = this.exceptionToPolicyMap.get(e.getClass());
            }
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries, failovers, isIdempotentOrAtMostOnce);
        }
    }

    static class RemoteExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<String, RetryPolicy> exceptionNameToPolicyMap;

        public RemoteExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionNameToPolicyMap = new HashMap<String, RetryPolicy>();
            for (Map.Entry<Class<? extends Exception>, RetryPolicy> e : exceptionToPolicyMap.entrySet()) {
                this.exceptionNameToPolicyMap.put(e.getKey().getName(), e.getValue());
            }
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            RetryPolicy policy = null;
            if (e instanceof RemoteException) {
                policy = this.exceptionNameToPolicyMap.get(((RemoteException)e).getClassName());
            }
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries, failovers, isIdempotentOrAtMostOnce);
        }
    }

    static class ExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap;

        public ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionToPolicyMap = exceptionToPolicyMap;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            RetryPolicy policy = this.exceptionToPolicyMap.get(e.getClass());
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries, failovers, isIdempotentOrAtMostOnce);
        }
    }

    public static class MultipleLinearRandomRetry
    implements RetryPolicy {
        private final List<Pair> pairs;
        private String myString;

        public MultipleLinearRandomRetry(List<Pair> pairs) {
            if (pairs == null || pairs.isEmpty()) {
                throw new IllegalArgumentException("pairs must be neither null nor empty.");
            }
            this.pairs = Collections.unmodifiableList(pairs);
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int curRetry, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            Pair p = this.searchPair(curRetry);
            if (p == null) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "Retry all pairs in MultipleLinearRandomRetry: " + this.pairs);
            }
            double ratio = ThreadLocalRandom.current().nextDouble() + 0.5;
            long sleepTime = Math.round((double)p.sleepMillis * ratio);
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, sleepTime);
        }

        private Pair searchPair(int curRetry) {
            int i;
            for (i = 0; i < this.pairs.size() && curRetry > this.pairs.get((int)i).numRetries; curRetry -= this.pairs.get((int)i).numRetries, ++i) {
            }
            return i == this.pairs.size() ? null : this.pairs.get(i);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + this.pairs;
            }
            return this.myString;
        }

        public static MultipleLinearRandomRetry parseCommaSeparatedString(String s) {
            String[] elements = s.split(",");
            if (elements.length == 0) {
                LOG.warn("Illegal value: there is no element in \"" + s + "\".");
                return null;
            }
            if (elements.length % 2 != 0) {
                LOG.warn("Illegal value: the number of elements in \"" + s + "\" is " + elements.length + " but an even number of elements is expected.");
                return null;
            }
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            int i = 0;
            while (i < elements.length) {
                int retries;
                int sleep;
                if ((sleep = MultipleLinearRandomRetry.parsePositiveInt(elements, i++, s)) == -1) {
                    return null;
                }
                if ((retries = MultipleLinearRandomRetry.parsePositiveInt(elements, i++, s)) == -1) {
                    return null;
                }
                pairs.add(new Pair(retries, sleep));
            }
            return new MultipleLinearRandomRetry(pairs);
        }

        private static int parsePositiveInt(String[] elements, int i, String originalString) {
            int n;
            String s = elements[i].trim();
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Failed to parse \"" + s + "\", which is the index " + i + " element in \"" + originalString + "\"", nfe);
                return -1;
            }
            if (n <= 0) {
                LOG.warn("The value " + n + " <= 0: it is parsed from the string \"" + s + "\" which is the index " + i + " element in \"" + originalString + "\"");
                return -1;
            }
            return n;
        }

        public static class Pair {
            final int numRetries;
            final int sleepMillis;

            public Pair(int numRetries, int sleepMillis) {
                if (numRetries < 0) {
                    throw new IllegalArgumentException("numRetries = " + numRetries + " < 0");
                }
                if (sleepMillis < 0) {
                    throw new IllegalArgumentException("sleepMillis = " + sleepMillis + " < 0");
                }
                this.numRetries = numRetries;
                this.sleepMillis = sleepMillis;
            }

            public String toString() {
                return this.numRetries + "x" + this.sleepMillis + "ms";
            }
        }
    }

    static class RetryUpToMaximumCountWithProportionalSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime * (long)(retries + 1);
        }
    }

    static class RetryUpToMaximumTimeWithFixedSleep
    extends RetryUpToMaximumCountWithFixedSleep {
        private long maxTime = 0L;
        private TimeUnit timeUnit;

        public RetryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
            super((int)(maxTime / sleepTime), sleepTime, timeUnit);
            this.maxTime = maxTime;
            this.timeUnit = timeUnit;
        }

        @Override
        protected String getReason() {
            return RetryUpToMaximumTimeWithFixedSleep.constructReasonString(this.maxTime, this.timeUnit);
        }

        @VisibleForTesting
        public static String constructReasonString(long maxTime, TimeUnit timeUnit) {
            return "retries get failed due to exceeded maximum allowed time (in " + timeUnit.toString() + "): " + maxTime;
        }
    }

    static class RetryUpToMaximumCountWithFixedSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime;
        }
    }

    static abstract class RetryLimited
    implements RetryPolicy {
        final int maxRetries;
        final long sleepTime;
        final TimeUnit timeUnit;
        private String myString;

        RetryLimited(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (sleepTime < 0L) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime + " < 0");
            }
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
            this.timeUnit = timeUnit;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            if (retries >= this.maxRetries) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, this.getReason());
            }
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, this.timeUnit.toMillis(this.calculateSleepTime(retries)), this.getReason());
        }

        protected String getReason() {
            return RetryLimited.constructReasonString(this.maxRetries);
        }

        @VisibleForTesting
        public static String constructReasonString(int retries) {
            return "retries get failed due to exceeded maximum allowed retries number: " + retries;
        }

        protected abstract long calculateSleepTime(int var1);

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxRetries=" + this.maxRetries + ", sleepTime=" + this.sleepTime + " " + (Object)((Object)this.timeUnit) + ")";
            }
            return this.myString;
        }
    }

    static class RetryForever
    implements RetryPolicy {
        RetryForever() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            return RetryPolicy.RetryAction.RETRY;
        }
    }

    static class TryOnceThenFail
    implements RetryPolicy {
        TryOnceThenFail() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "try once and fail.");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

