/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FutureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FutureUtils.class);

    private FutureUtils() {
    }

    public static <T> void addListener(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        future.whenComplete((resp, error) -> {
            try {
                action.accept(resp, FutureUtils.unwrapCompletionException(error));
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing CompletableFuture", t);
            }
        });
    }

    public static <T> void addListener(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        future.whenCompleteAsync((resp, error) -> {
            try {
                action.accept(resp, FutureUtils.unwrapCompletionException(error));
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing CompletableFuture", t);
            }
        }, executor);
    }

    public static void consume(CompletableFuture<?> future) {
        FutureUtils.addListener(future, (r, e) -> {
            if (e != null) {
                LOG.warn("Async operation fails", (Throwable)e);
            }
        });
    }

    public static <T> CompletableFuture<T> wrapFuture(CompletableFuture<T> future, Executor executor) {
        CompletableFuture wrappedFuture = new CompletableFuture();
        FutureUtils.addListener(future, (r, e) -> {
            if (e != null) {
                wrappedFuture.completeExceptionally((Throwable)e);
            } else {
                wrappedFuture.complete(r);
            }
        }, executor);
        return wrappedFuture;
    }

    public static Throwable unwrapCompletionException(Throwable error) {
        Throwable cause;
        if (error instanceof CompletionException && (cause = error.getCause()) != null) {
            return cause;
        }
        return error;
    }

    private static void setStackTrace(Throwable error) {
        StackTraceElement[] localStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] originalStackTrace = error.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localStackTrace.length + originalStackTrace.length + 1];
        System.arraycopy(localStackTrace, 0, newStackTrace, 0, localStackTrace.length);
        newStackTrace[localStackTrace.length] = new StackTraceElement("--------Future", "get--------", null, -1);
        System.arraycopy(originalStackTrace, 0, newStackTrace, localStackTrace.length + 1, originalStackTrace.length);
        error.setStackTrace(newStackTrace);
    }

    public static IOException rethrow(Throwable error) throws IOException {
        if (error instanceof IOException) {
            FutureUtils.setStackTrace(error);
            throw (IOException)error;
        }
        if (error instanceof RuntimeException) {
            FutureUtils.setStackTrace(error);
            throw (RuntimeException)error;
        }
        if (error instanceof Error) {
            FutureUtils.setStackTrace(error);
            throw (Error)error;
        }
        throw new IOException(error);
    }

    public static <T> T get(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw FutureUtils.rethrow(e.getCause());
        }
    }

    public static <T> T get(Future<T> future, long timeout, TimeUnit unit) throws IOException {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw FutureUtils.rethrow(e.getCause());
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    public static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(f -> f.getNow(null)).collect(Collectors.toList()));
    }
}

