/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.DynamicIOStatisticsBuilder;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.StatisticDurationTracker;
import org.apache.hadoop.fs.statistics.impl.WrappedIOStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IOStatisticsStoreImpl
extends WrappedIOStatistics
implements IOStatisticsStore {
    private static final Logger LOG = LoggerFactory.getLogger(IOStatisticsStoreImpl.class);
    private final Map<String, AtomicLong> counterMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> gaugeMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> minimumMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> maximumMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, MeanStatistic> meanStatisticMap = new ConcurrentHashMap<String, MeanStatistic>();

    IOStatisticsStoreImpl(List<String> counters, List<String> gauges, List<String> minimums, List<String> maximums, List<String> meanStatistics) {
        super(null);
        DynamicIOStatisticsBuilder builder = IOStatisticsBinding.dynamicIOStatistics();
        if (counters != null) {
            for (String key : counters) {
                AtomicLong counter = new AtomicLong();
                this.counterMap.put(key, counter);
                builder.withAtomicLongCounter(key, counter);
            }
        }
        if (gauges != null) {
            for (String key : gauges) {
                AtomicLong gauge = new AtomicLong();
                this.gaugeMap.put(key, gauge);
                builder.withAtomicLongGauge(key, gauge);
            }
        }
        if (maximums != null) {
            for (String key : maximums) {
                AtomicLong maximum = new AtomicLong(-1L);
                this.maximumMap.put(key, maximum);
                builder.withAtomicLongMaximum(key, maximum);
            }
        }
        if (minimums != null) {
            for (String key : minimums) {
                AtomicLong minimum = new AtomicLong(-1L);
                this.minimumMap.put(key, minimum);
                builder.withAtomicLongMinimum(key, minimum);
            }
        }
        if (meanStatistics != null) {
            for (String key : meanStatistics) {
                this.meanStatisticMap.put(key, new MeanStatistic());
                builder.withMeanStatisticFunction(key, k -> this.meanStatisticMap.get(k));
            }
        }
        this.setWrapped(builder.build());
    }

    private void setAtomicLong(AtomicLong aLong, long value) {
        if (aLong != null) {
            aLong.set(value);
        }
    }

    private long incAtomicLong(AtomicLong aLong, long increment) {
        if (aLong != null) {
            return increment != 0L ? aLong.addAndGet(increment) : aLong.get();
        }
        return 0L;
    }

    @Override
    public void setCounter(String key, long value) {
        this.setAtomicLong(this.counterMap.get(key), value);
        LOG.debug("Setting counter {} to {}", (Object)key, (Object)value);
    }

    @Override
    public long incrementCounter(String key, long value) {
        AtomicLong counter = this.counterMap.get(key);
        if (counter == null) {
            LOG.debug("Ignoring counter increment for unknown counter {}", (Object)key);
            return 0L;
        }
        if (value < 0L) {
            LOG.debug("Ignoring negative increment value {} for counter {}", (Object)value, (Object)key);
            return counter.get();
        }
        long l = this.incAtomicLong(counter, value);
        LOG.trace("Incrementing counter {} by {} with final value {}", key, value, l);
        return l;
    }

    @Override
    public void setMaximum(String key, long value) {
        this.setAtomicLong(this.maximumMap.get(key), value);
    }

    @Override
    public long incrementMaximum(String key, long value) {
        return this.incAtomicLong(this.maximumMap.get(key), value);
    }

    @Override
    public void setMinimum(String key, long value) {
        this.setAtomicLong(this.minimumMap.get(key), value);
    }

    @Override
    public long incrementMinimum(String key, long value) {
        return this.incAtomicLong(this.minimumMap.get(key), value);
    }

    @Override
    public void addMinimumSample(String key, long value) {
        AtomicLong min = this.minimumMap.get(key);
        if (min != null) {
            IOStatisticsBinding.maybeUpdateMinimum(min, value);
        }
    }

    @Override
    public void addMaximumSample(String key, long value) {
        AtomicLong max = this.maximumMap.get(key);
        if (max != null) {
            IOStatisticsBinding.maybeUpdateMaximum(max, value);
        }
    }

    @Override
    public void setGauge(String key, long value) {
        this.setAtomicLong(this.gaugeMap.get(key), value);
    }

    @Override
    public long incrementGauge(String key, long value) {
        return this.incAtomicLong(this.gaugeMap.get(key), value);
    }

    @Override
    public void setMeanStatistic(String key, MeanStatistic value) {
        MeanStatistic ref = this.meanStatisticMap.get(key);
        if (ref != null) {
            ref.set(value);
        }
    }

    @Override
    public void addMeanStatisticSample(String key, long value) {
        MeanStatistic ref = this.meanStatisticMap.get(key);
        if (ref != null) {
            ref.addSample(value);
        }
    }

    @Override
    public synchronized void reset() {
        this.counterMap.values().forEach(a -> a.set(0L));
        this.gaugeMap.values().forEach(a -> a.set(0L));
        this.minimumMap.values().forEach(a -> a.set(0L));
        this.maximumMap.values().forEach(a -> a.set(0L));
        this.meanStatisticMap.values().forEach(a -> a.clear());
    }

    @Override
    public synchronized boolean aggregate(@Nullable IOStatistics source) {
        if (source == null) {
            return false;
        }
        Map<String, Long> sourceCounters = source.counters();
        this.counterMap.entrySet().forEach(e -> {
            Long sourceValue = (Long)IOStatisticsStoreImpl.lookupQuietly(sourceCounters, (String)e.getKey());
            if (sourceValue != null) {
                ((AtomicLong)e.getValue()).addAndGet(sourceValue);
            }
        });
        Map<String, Long> sourceGauges = source.gauges();
        this.gaugeMap.entrySet().forEach(e -> {
            Long sourceGauge = (Long)IOStatisticsStoreImpl.lookupQuietly(sourceGauges, (String)e.getKey());
            if (sourceGauge != null && sourceGauge > 0L) {
                ((AtomicLong)e.getValue()).addAndGet(sourceGauge);
            }
        });
        Map<String, Long> sourceMinimums = source.minimums();
        this.minimumMap.entrySet().forEach(e -> {
            Long sourceValue = (Long)IOStatisticsStoreImpl.lookupQuietly(sourceMinimums, (String)e.getKey());
            if (sourceValue != null) {
                AtomicLong dest = (AtomicLong)e.getValue();
                dest.set(IOStatisticsBinding.aggregateMaximums(dest.get(), sourceValue));
                dest.set(IOStatisticsBinding.aggregateMinimums(dest.get(), sourceValue));
            }
        });
        Map<String, Long> sourceMaximums = source.maximums();
        this.maximumMap.entrySet().forEach(e -> {
            Long sourceValue = (Long)IOStatisticsStoreImpl.lookupQuietly(sourceMaximums, (String)e.getKey());
            if (sourceValue != null) {
                AtomicLong dest = (AtomicLong)e.getValue();
                dest.set(IOStatisticsBinding.aggregateMaximums(dest.get(), sourceValue));
            }
        });
        Map<String, MeanStatistic> sourceMeans = source.meanStatistics();
        this.meanStatisticMap.entrySet().forEach(e -> {
            MeanStatistic current = (MeanStatistic)e.getValue();
            MeanStatistic sourceValue = (MeanStatistic)IOStatisticsStoreImpl.lookupQuietly(sourceMeans, (String)e.getKey());
            if (sourceValue != null) {
                current.add(sourceValue);
            }
        });
        return true;
    }

    private static <T> T lookup(Map<String, T> map, String key) {
        T val = map.get(key);
        Objects.requireNonNull(val, () -> "unknown statistic " + key);
        return val;
    }

    private static <T> T lookupQuietly(Map<String, T> map, String key) {
        return map.get(key);
    }

    @Override
    public AtomicLong getCounterReference(String key) {
        return IOStatisticsStoreImpl.lookup(this.counterMap, key);
    }

    @Override
    public AtomicLong getMaximumReference(String key) {
        return IOStatisticsStoreImpl.lookup(this.maximumMap, key);
    }

    @Override
    public AtomicLong getMinimumReference(String key) {
        return IOStatisticsStoreImpl.lookup(this.minimumMap, key);
    }

    @Override
    public AtomicLong getGaugeReference(String key) {
        return IOStatisticsStoreImpl.lookup(this.gaugeMap, key);
    }

    @Override
    public MeanStatistic getMeanStatistic(String key) {
        return IOStatisticsStoreImpl.lookup(this.meanStatisticMap, key);
    }

    @Override
    public void addTimedOperation(String prefix, long durationMillis) {
        this.addMeanStatisticSample(prefix + ".mean", durationMillis);
        this.addMinimumSample(prefix + ".min", durationMillis);
        this.addMaximumSample(prefix + ".max", durationMillis);
    }

    @Override
    public void addTimedOperation(String prefix, Duration duration) {
        this.addTimedOperation(prefix, duration.toMillis());
    }

    @Override
    public DurationTracker trackDuration(String key, long count) {
        if (this.counterMap.containsKey(key)) {
            return new StatisticDurationTracker(this, key, count);
        }
        return IOStatisticsSupport.stubDurationTracker();
    }
}

