/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.shaded.org.apache.hc.core5.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.concurrent.Cancellable;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.TimeoutValueException;

public class BasicFuture<T>
implements Future<T>,
Cancellable {
    private final FutureCallback<T> callback;
    private volatile boolean completed;
    private volatile boolean cancelled;
    private volatile T result;
    private volatile Exception ex;
    private final ReentrantLock lock;
    private final Condition condition;

    public BasicFuture(FutureCallback<T> callback) {
        this.callback = callback;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    private T getResult() throws ExecutionException {
        if (this.ex != null) {
            throw new ExecutionException(this.ex);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.completed) {
                this.condition.await();
            }
            T t = this.getResult();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Args.notNull(unit, "Time unit");
        long msecs = unit.toMillis(timeout);
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        try {
            this.lock.lock();
            if (this.completed) {
                T t = this.getResult();
                return t;
            }
            if (waitTime <= 0L) {
                throw TimeoutValueException.fromMilliseconds(msecs, msecs + Math.abs(waitTime));
            }
            do {
                this.condition.await(waitTime, TimeUnit.MILLISECONDS);
                if (!this.completed) continue;
                T t = this.getResult();
                return t;
            } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
            throw TimeoutValueException.fromMilliseconds(msecs, msecs + Math.abs(waitTime));
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean completed(T result) {
        this.lock.lock();
        try {
            if (this.completed) {
                boolean bl = false;
                return bl;
            }
            this.completed = true;
            this.result = result;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.completed(result);
        }
        return true;
    }

    public boolean failed(Exception exception) {
        this.lock.lock();
        try {
            if (this.completed) {
                boolean bl = false;
                return bl;
            }
            this.completed = true;
            this.ex = exception;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.failed(exception);
        }
        return true;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            if (this.completed) {
                boolean bl = false;
                return bl;
            }
            this.completed = true;
            this.cancelled = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.cancelled();
        }
        return true;
    }

    @Override
    public boolean cancel() {
        return this.cancel(true);
    }
}

