/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.Subject;
import org.apache.calcite.avatica.util.SecurityUtils;

class SubjectPreservingPrivilegedThreadFactory
implements ThreadFactory {
    SubjectPreservingPrivilegedThreadFactory() {
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        final Subject subject = SecurityUtils.currentSubject();
        return SecurityUtils.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SecurityUtils.callAs(subject, new Callable<Thread>(){

                    @Override
                    public Thread call() {
                        Thread thread = new Thread(runnable);
                        thread.setDaemon(true);
                        thread.setName("avatica_qtp" + this.hashCode() + "-" + thread.getId());
                        thread.setContextClassLoader(this.getClass().getClassLoader());
                        return thread;
                    }
                });
            }
        });
    }
}

