/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.ServerCustomizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.apache.phoenix.queryserver.server.ServerCustomizersFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.eclipse.jetty.server.Server;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerCustomizersTest {
    @Before
    @After
    public void clearSingletons() {
        InstanceResolver.clearSingletons();
    }

    @Test
    public void testDefaultFactory() {
        QueryServer queryServer = new QueryServer();
        AvaticaServerConfiguration avaticaServerConfiguration = null;
        List customizers = queryServer.createServerCustomizers(new Configuration(), avaticaServerConfiguration);
        Assert.assertEquals((long)1L, (long)customizers.size());
    }

    @Test
    public void testUseProvidedCustomizers() {
        AvaticaServerConfiguration avaticaServerConfiguration = null;
        final List<1> expected = Collections.singletonList(new ServerCustomizer<Server>(){

            public void customize(Server server) {
            }
        });
        InstanceResolver.getSingleton(ServerCustomizersFactory.class, (Object)new ServerCustomizersFactory(){

            public List<ServerCustomizer<Server>> createServerCustomizers(Configuration conf, AvaticaServerConfiguration avaticaServerConfiguration) {
                return expected;
            }
        });
        Configuration conf = new Configuration(false);
        QueryServer queryServer = new QueryServer();
        List actual = queryServer.createServerCustomizers(conf, avaticaServerConfiguration);
        Assert.assertEquals((String)"Customizers are different", expected, (Object)actual);
    }
}

