/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryServerTest {
    private static String EXPECTED_HOSTNAME;
    private QueryServer qs;
    private Configuration conf;

    private static String getSpnegoPrincipal(String instance) {
        return "HTTP/" + instance + "@EXAMPLE.COM";
    }

    @BeforeClass
    public static void setupOnce() throws IOException {
        EXPECTED_HOSTNAME = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
    }

    @Before
    public void setup() {
        this.conf = new Configuration(false);
        this.qs = new QueryServer();
    }

    @Test
    public void testHostExpansion() throws IOException {
        this.conf.set("phoenix.queryserver.http.kerberos.principal", QueryServerTest.getSpnegoPrincipal("_HOST"));
        Assert.assertEquals((Object)QueryServerTest.getSpnegoPrincipal(EXPECTED_HOSTNAME), (Object)this.qs.getSpnegoPrincipal(this.conf));
    }

    @Test
    public void testHostExpansionWithOldName() throws IOException {
        this.conf.set("phoenix.queryserver.kerberos.http.principal", QueryServerTest.getSpnegoPrincipal("_HOST"));
        Assert.assertEquals((Object)QueryServerTest.getSpnegoPrincipal(EXPECTED_HOSTNAME), (Object)this.qs.getSpnegoPrincipal(this.conf));
    }

    @Test
    public void testHostExpansionWithOldAndNewNames() throws IOException {
        this.conf.set("phoenix.queryserver.http.kerberos.principal", QueryServerTest.getSpnegoPrincipal("_HOST"));
        this.conf.set("phoenix.queryserver.kerberos.http.principal", "fake_" + QueryServerTest.getSpnegoPrincipal("_HOST"));
        Assert.assertEquals((Object)QueryServerTest.getSpnegoPrincipal(EXPECTED_HOSTNAME), (Object)this.qs.getSpnegoPrincipal(this.conf));
    }
}

