/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.server.RemoteUserExtractor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRemoteUserExtractorTest {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixRemoteUserExtractorTest.class);

    @Test
    public void testWithRemoteUserExtractorSuccess() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"proxyserver");
        Mockito.when((Object)request.getParameter("doAs")).thenReturn((Object)"enduser");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"localhost:1234");
        Configuration conf = new Configuration(false);
        conf.set("hadoop.proxyuser.proxyserver.groups", "*");
        conf.set("hadoop.proxyuser.proxyserver.hosts", "*");
        conf.set("phoenix.queryserver.withRemoteUserExtractor", "true");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        QueryServer.PhoenixRemoteUserExtractor extractor = new QueryServer.PhoenixRemoteUserExtractor(conf);
        try {
            Assert.assertEquals((Object)"enduser", (Object)extractor.extract(request));
        }
        catch (RemoteUserExtractionException e) {
            LOG.info(e.getMessage());
        }
    }

    @Test
    public void testNoRemoteUserExtractorParam() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"proxyserver");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"localhost:1234");
        Configuration conf = new Configuration(false);
        conf.set("hadoop.proxyuser.proxyserver.groups", "*");
        conf.set("hadoop.proxyuser.proxyserver.hosts", "*");
        conf.set("phoenix.queryserver.withRemoteUserExtractor", "true");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        QueryServer.PhoenixRemoteUserExtractor extractor = new QueryServer.PhoenixRemoteUserExtractor(conf);
        try {
            Assert.assertEquals((Object)"proxyserver", (Object)extractor.extract(request));
        }
        catch (RemoteUserExtractionException e) {
            LOG.info(e.getMessage());
        }
    }

    @Test
    public void testDoNotUseRemoteUserExtractor() {
        HttpServer.Builder builder = (HttpServer.Builder)Mockito.mock(HttpServer.Builder.class);
        Configuration conf = new Configuration(false);
        QueryServer queryServer = new QueryServer();
        queryServer.setRemoteUserExtractorIfNecessary(builder, conf);
        ((HttpServer.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).withRemoteUserExtractor((RemoteUserExtractor)ArgumentMatchers.any(QueryServer.PhoenixRemoteUserExtractor.class));
    }

    @Test
    public void testUseRemoteUserExtractor() {
        HttpServer.Builder builder = (HttpServer.Builder)Mockito.mock(HttpServer.Builder.class);
        Configuration conf = new Configuration(false);
        conf.set("phoenix.queryserver.withRemoteUserExtractor", "true");
        QueryServer queryServer = new QueryServer();
        queryServer.setRemoteUserExtractorIfNecessary(builder, conf);
        ((HttpServer.Builder)Mockito.verify((Object)builder)).withRemoteUserExtractor((RemoteUserExtractor)ArgumentMatchers.any(QueryServer.PhoenixRemoteUserExtractor.class));
    }
}

