/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixDoAsCallbackTest {
    @Test
    public void ugiInstancesAreCached() throws Exception {
        Configuration conf = new Configuration(false);
        UserGroupInformation serverUgi = UserGroupInformation.createUserForTesting((String)"server", (String[])new String[0]);
        QueryServer.PhoenixDoAsCallback callback = new QueryServer.PhoenixDoAsCallback(serverUgi, conf);
        UserGroupInformation ugi1 = callback.createProxyUser("user1");
        Assert.assertEquals((long)1L, (long)callback.getCache().size());
        Assert.assertTrue((ugi1.getRealUser() == serverUgi ? 1 : 0) != 0);
        UserGroupInformation ugi2 = callback.createProxyUser("user2");
        Assert.assertEquals((long)2L, (long)callback.getCache().size());
        Assert.assertTrue((ugi2.getRealUser() == serverUgi ? 1 : 0) != 0);
        UserGroupInformation ugi1Reference = callback.createProxyUser("user1");
        Assert.assertTrue((ugi1 == ugi1Reference ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)callback.getCache().size());
    }

    @Test
    public void proxyingUsersAreCached() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("hadoop.proxyuser.server.groups", "*");
        conf.set("hadoop.proxyuser.server.hosts", "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation serverUgi = UserGroupInformation.createUserForTesting((String)"server", (String[])new String[0]);
        QueryServer.PhoenixDoAsCallback callback = new QueryServer.PhoenixDoAsCallback(serverUgi, conf);
        UserGroupInformation user1 = (UserGroupInformation)callback.doAsRemoteUser("user1", "localhost:1234", (Callable)new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        UserGroupInformation user2 = (UserGroupInformation)callback.doAsRemoteUser("user2", "localhost:1235", (Callable)new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        UserGroupInformation user1Reference = (UserGroupInformation)callback.doAsRemoteUser("user1", "localhost:1234", (Callable)new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertNotEquals((long)user1.hashCode(), (long)user2.hashCode());
        Assert.assertEquals((String)"These should be the same (cached) instance", (long)user1.hashCode(), (long)user1Reference.hashCode());
        Assert.assertEquals((String)"These should be the same (cached) instance", (Object)user1, (Object)user1Reference);
    }
}

