/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.queryserver.client.Driver;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ThinClientUtil;
import org.junit.Assert;
import org.junit.Test;

public class DriverCohabitationTest {
    @Test
    public void testDriverCohabitation() throws SQLException {
        java.sql.Driver thickDriver = null;
        java.sql.Driver thinDriver = null;
        for (java.sql.Driver d : Collections.list(DriverManager.getDrivers())) {
            if (d instanceof PhoenixDriver) {
                thickDriver = d;
                continue;
            }
            if (!(d instanceof Driver)) continue;
            thinDriver = d;
        }
        Assert.assertNotNull((String)"Thick driver not registered with DriverManager.", thickDriver);
        Assert.assertNotNull((String)"Thin driver not registered with DriverManager.", thinDriver);
        String thickUrl = QueryUtil.getUrl((String)"localhost");
        String thinUrl = ThinClientUtil.getConnectionUrl((String)"localhost", (int)1234);
        Assert.assertTrue((String)("Thick driver should accept connections like " + thickUrl), (boolean)thickDriver.acceptsURL(thickUrl));
        Assert.assertFalse((String)("Thick driver should reject connections like " + thinUrl), (boolean)thickDriver.acceptsURL(thinUrl));
        Assert.assertTrue((String)("Thin driver should accept connections like " + thinUrl), (boolean)thinDriver.acceptsURL(thinUrl));
        Assert.assertFalse((String)("Thin driver should reject connections like " + thickUrl), (boolean)thinDriver.acceptsURL(thickUrl));
    }
}

