/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.DoAsRemoteUserCallback;
import org.apache.calcite.avatica.server.HttpQueryStringParameterRemoteUserExtractor;
import org.apache.calcite.avatica.server.HttpRequestRemoteUserExtractor;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.server.RemoteUserExtractor;
import org.apache.calcite.avatica.server.ServerCustomizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.queryserver.QueryServerOptions;
import org.apache.phoenix.queryserver.register.Registry;
import org.apache.phoenix.queryserver.server.AvaticaServerConfigurationFactory;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactory;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactoryImpl;
import org.apache.phoenix.queryserver.server.RemoteUserExtractorFactory;
import org.apache.phoenix.queryserver.server.ServerCustomizersFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.SimpleLRUCache;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryServer
extends Configured
implements Tool,
Runnable {
    protected static final Logger LOG = LoggerFactory.getLogger(QueryServer.class);
    private final String[] argv;
    private final CountDownLatch runningLatch = new CountDownLatch(1);
    private HttpServer server = null;
    private int retCode = 0;
    private Throwable t = null;
    private Registry registry;
    private static final RemoteUserExtractorFactory DEFAULT_USER_EXTRACTOR = new RemoteUserExtractorFactory.RemoteUserExtractorFactoryImpl();
    private static final ServerCustomizersFactory DEFAULT_SERVER_CUSTOMIZERS = new ServerCustomizersFactory.ServerCustomizersFactoryImpl();
    private static final AvaticaServerConfigurationFactory DEFAULT_SERVER_CONFIG = new AvaticaServerConfigurationFactory.AvaticaServerConfigurationFactoryImpl();

    public static void logJVMInfo() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        if (runtime != null) {
            LOG.info("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion());
            LOG.info("vmInputArguments=" + runtime.getInputArguments());
        }
    }

    public static void logProcessInfo(Configuration conf) {
        if (conf == null || !conf.getBoolean("phoenix.queryserver.envvars.logging.disabled", false)) {
            String[] confSkipWords;
            HashSet<String> skipWords = new HashSet<String>(QueryServerOptions.DEFAULT_QUERY_SERVER_SKIP_WORDS);
            if (conf != null && (confSkipWords = conf.getStrings("phoenix.queryserver.envvars.logging.skipwords")) != null) {
                skipWords.addAll(Arrays.asList(confSkipWords));
            }
            block0: for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey().toLowerCase();
                String value = entry.getValue().toLowerCase();
                for (String skipWord : skipWords) {
                    if (!key.contains(skipWord) && !value.contains(skipWord)) continue;
                    continue block0;
                }
                LOG.info("env:" + entry);
            }
        }
        QueryServer.logJVMInfo();
    }

    public QueryServer() {
        this(null, null);
    }

    public QueryServer(String[] argv, Configuration conf) {
        this.argv = argv;
        this.setConf(conf);
    }

    public int getPort() {
        if (this.server == null) {
            return -1;
        }
        return this.server.getPort();
    }

    public int getRetCode() {
        return this.retCode;
    }

    public Throwable getThrowable() {
        return this.t;
    }

    public void awaitRunning() throws InterruptedException {
        this.runningLatch.await();
    }

    public void awaitRunning(long timeout, TimeUnit unit) throws InterruptedException {
        this.runningLatch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        QueryServer.logProcessInfo(this.getConf());
        boolean loadBalancerEnabled = this.getConf().getBoolean("phoenix.queryserver.loadbalancer.enabled", false);
        try {
            String hostname;
            boolean isKerberos = "kerberos".equalsIgnoreCase(this.getConf().get("hbase.security.authentication"));
            boolean isHadoopKerberos = "kerberos".equalsIgnoreCase(this.getConf().get("hadoop.security.authentication"));
            boolean disableSpnego = this.getConf().getBoolean("phoenix.queryserver.spnego.auth.disabled", false);
            boolean disableLogin = this.getConf().getBoolean("phoenix.queryserver.disable.kerberos.login", false);
            if (isKerberos && !disableLogin) {
                if (!isHadoopKerberos) {
                    LOG.error("HBase and Hadoop security config inconsistent, hbase.security.authentication was configured as kerberos, but hadoop.security.authentication not!");
                    int n = -1;
                    return n;
                }
                hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)this.getConf().get("phoenix.queryserver.dns.interface", "default"), (String)this.getConf().get("phoenix.queryserver.dns.nameserver", "default")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Login to " + hostname + " using " + this.getConf().get("phoenix.queryserver.keytab.file") + " and principal " + this.getConf().get("phoenix.queryserver.kerberos.principal") + ".");
                }
                SecurityUtil.login((Configuration)this.getConf(), (String)"phoenix.queryserver.keytab.file", (String)"phoenix.queryserver.kerberos.principal", (String)hostname);
                LOG.info("Kerberos login successful.");
            } else {
                hostname = InetAddress.getLocalHost().getHostName();
                LOG.info("Kerberos is off and hostname is : " + hostname);
            }
            int port = this.getConf().getInt("phoenix.queryserver.http.port", 8765);
            LOG.debug("Listening on port " + port);
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.getConf());
            HttpServer.Builder<Server> builder = HttpServer.Builder.newBuilder().withPort(port);
            UserGroupInformation ugi = this.getUserGroupInformation();
            AvaticaServerConfiguration avaticaServerConfiguration = null;
            if (this.getConf().getBoolean("phoenix.queryserver.custom.auth.enabled", false)) {
                avaticaServerConfiguration = this.enableCustomAuth(builder, this.getConf(), ugi);
            } else {
                if (isKerberos) {
                    this.configureClientAuthentication(builder, disableSpnego, ugi);
                }
                this.setRemoteUserExtractorIfNecessary(builder, this.getConf());
                this.setTlsIfNeccessary(builder, this.getConf());
                this.setHandler(args, builder);
            }
            this.enableServerCustomizersIfNecessary(builder, this.getConf(), avaticaServerConfiguration);
            this.server = builder.build();
            this.server.start();
            if (loadBalancerEnabled) {
                this.registerToServiceProvider(hostname);
            }
            this.runningLatch.countDown();
            this.server.join();
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            LOG.error("Unrecoverable service error. Shutting down.", t);
            this.t = t;
            int n = -1;
            return n;
        }
        finally {
            if (loadBalancerEnabled) {
                this.unRegister();
            }
        }
    }

    private void setTlsIfNeccessary(HttpServer.Builder<Server> builder, Configuration conf) throws Exception {
        boolean useTls = this.getConf().getBoolean("phoenix.queryserver.tls.enabled", false);
        if (useTls) {
            String tlsKeystore = this.getConf().get("phoenix.queryserver.tls.keystore");
            String keystoreType = this.getConf().get("phoenix.queryserver.tls.keystore.type", "jks");
            String tlsKeystorePassword = this.getConf().get("phoenix.queryserver.tls.keystore.password", "");
            String tlsTruststore = this.getConf().get("phoenix.queryserver.tls.truststore");
            String tlsTruststorePassword = this.getConf().get("phoenix.queryserver.tls.truststore.password", "");
            if (tlsKeystore == null) {
                throw new Exception(String.format("if %s is enabled, %s must be specfified", "phoenix.queryserver.tls.enabled", "phoenix.queryserver.tls.keystore"));
            }
            File tlsKeystoreFile = new File(tlsKeystore);
            if (tlsTruststore == null) {
                throw new Exception(String.format("if %s is enabled, %s must be specfified", "phoenix.queryserver.tls.enabled", "phoenix.queryserver.tls.truststore"));
            }
            File tlsTruststoreFile = new File(tlsTruststore);
            builder.withTLS(tlsKeystoreFile, tlsKeystorePassword, tlsTruststoreFile, tlsTruststorePassword, keystoreType);
        }
    }

    void configureClientAuthentication(HttpServer.Builder builder, boolean disableSpnego, UserGroupInformation ugi) throws IOException {
        if (!disableSpnego) {
            this.configureSpnegoAuthentication(builder, ugi);
        }
        this.configureCallBack(builder, ugi);
    }

    void configureSpnegoAuthentication(HttpServer.Builder builder, UserGroupInformation ugi) throws IOException {
        String keytabPath = this.getConf().get("phoenix.queryserver.keytab.file");
        File keytab = new File(keytabPath);
        String httpKeytabPath = this.getConf().get("phoenix.queryserver.http.keytab.file", null);
        String httpPrincipal = this.getSpnegoPrincipal(this.getConf());
        File httpKeytab = null;
        if (null != httpKeytabPath) {
            httpKeytab = new File(httpKeytabPath);
        }
        String realmsString = this.getConf().get("phoenix.queryserver.kerberos.allowed.realms", null);
        String[] additionalAllowedRealms = null;
        if (null != realmsString) {
            additionalAllowedRealms = StringUtils.split((String)realmsString, (char)',');
        }
        if (null != httpKeytabPath && null != httpPrincipal) {
            builder.withSpnego(httpPrincipal, additionalAllowedRealms).withAutomaticLogin(httpKeytab);
        } else {
            builder.withSpnego(ugi.getUserName(), additionalAllowedRealms).withAutomaticLogin(keytab);
        }
    }

    String getSpnegoPrincipal(Configuration conf) throws IOException {
        String httpPrincipal = conf.get("phoenix.queryserver.http.kerberos.principal", null);
        if (httpPrincipal == null) {
            httpPrincipal = conf.get("phoenix.queryserver.kerberos.http.principal", null);
        }
        String hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("phoenix.queryserver.dns.interface", "default"), (String)conf.get("phoenix.queryserver.dns.nameserver", "default")));
        return SecurityUtil.getServerPrincipal((String)httpPrincipal, (String)hostname);
    }

    UserGroupInformation getUserGroupInformation() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        LOG.debug("Current user is " + ugi);
        if (!ugi.hasKerberosCredentials()) {
            ugi = UserGroupInformation.getLoginUser();
            LOG.debug("Current user does not have Kerberos credentials, using instead " + ugi);
        }
        return ugi;
    }

    void configureCallBack(HttpServer.Builder<Server> builder, UserGroupInformation ugi) {
        builder.withImpersonation(new PhoenixDoAsCallback(ugi, this.getConf()));
    }

    private void setHandler(String[] args, HttpServer.Builder<Server> builder) throws Exception {
        Class factoryClass = this.getConf().getClass("phoenix.queryserver.metafactory.class", PhoenixMetaFactoryImpl.class, PhoenixMetaFactory.class);
        PhoenixMetaFactory factory = (PhoenixMetaFactory)factoryClass.getDeclaredConstructor(Configuration.class).newInstance(this.getConf());
        Meta meta = factory.create(Arrays.asList(args));
        LocalService service = new LocalService(meta);
        builder.withHandler(service, this.getSerialization(this.getConf()));
    }

    public synchronized void stop() {
        this.server.stop();
    }

    public boolean registerToServiceProvider(String hostName) {
        boolean success = true;
        try {
            LoadBalanceZookeeperConf loadBalanceConfiguration = this.getLoadBalanceConfiguration();
            if (loadBalanceConfiguration == null) {
                throw new NullPointerException();
            }
            this.registry = this.getRegistry();
            if (this.registry == null) {
                throw new NullPointerException();
            }
            String zkConnectString = loadBalanceConfiguration.getZkConnectString();
            this.registry.registerServer(loadBalanceConfiguration, this.getPort(), zkConnectString, hostName);
        }
        catch (Throwable ex) {
            LOG.debug("Caught an error trying to register with the load balancer", ex);
            success = false;
        }
        return success;
    }

    public LoadBalanceZookeeperConf getLoadBalanceConfiguration() {
        ServiceLoader<LoadBalanceZookeeperConf> serviceLocator = ServiceLoader.load(LoadBalanceZookeeperConf.class);
        LoadBalanceZookeeperConf zookeeperConfig = null;
        try {
            if (serviceLocator.iterator().hasNext()) {
                zookeeperConfig = serviceLocator.iterator().next();
            }
        }
        catch (ServiceConfigurationError ex) {
            LOG.debug("Unable to locate the service provider for load balancer configuration", ex);
        }
        return zookeeperConfig;
    }

    public Registry getRegistry() {
        ServiceLoader<Registry> serviceLocator = ServiceLoader.load(Registry.class);
        Registry registry = null;
        try {
            if (serviceLocator.iterator().hasNext()) {
                registry = serviceLocator.iterator().next();
            }
        }
        catch (ServiceConfigurationError ex) {
            LOG.debug("Unable to locate the zookeeper registry for the load balancer", ex);
        }
        return registry;
    }

    public boolean unRegister() {
        boolean success = true;
        try {
            this.registry.unRegisterServer();
        }
        catch (Throwable ex) {
            LOG.debug("Caught an error while de-registering the query server from the load balancer", ex);
            success = false;
        }
        return success;
    }

    Driver.Serialization getSerialization(Configuration conf) {
        Driver.Serialization serialization;
        String serializationName = conf.get("phoenix.queryserver.serialization", "PROTOBUF");
        try {
            serialization = Driver.Serialization.valueOf(serializationName);
        }
        catch (Exception e) {
            LOG.error("Unknown message serialization type for " + serializationName);
            throw e;
        }
        return serialization;
    }

    @Override
    public void run() {
        try {
            this.retCode = this.run(this.argv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRemoteUserExtractorIfNecessary(HttpServer.Builder builder, Configuration conf) {
        if (conf.getBoolean("phoenix.queryserver.withRemoteUserExtractor", false)) {
            builder.withRemoteUserExtractor(this.createRemoteUserExtractor(conf));
        }
    }

    public void enableServerCustomizersIfNecessary(HttpServer.Builder<Server> builder, Configuration conf, AvaticaServerConfiguration avaticaServerConfiguration) {
        List customizers = this.createServerCustomizers(conf, avaticaServerConfiguration);
        if (customizers != null && !customizers.isEmpty()) {
            builder.withServerCustomizers(customizers, Server.class);
        }
    }

    public AvaticaServerConfiguration enableCustomAuth(HttpServer.Builder<Server> builder, Configuration conf, UserGroupInformation ugi) {
        AvaticaServerConfiguration avaticaServerConfiguration = this.createAvaticaServerConfig(conf, ugi);
        builder.withCustomAuthentication(avaticaServerConfiguration);
        return avaticaServerConfiguration;
    }

    RemoteUserExtractor createRemoteUserExtractor(Configuration conf) {
        RemoteUserExtractorFactory factory = InstanceResolver.getSingleton(RemoteUserExtractorFactory.class, DEFAULT_USER_EXTRACTOR);
        return factory.createRemoteUserExtractor(conf);
    }

    List<ServerCustomizer<Server>> createServerCustomizers(Configuration conf, AvaticaServerConfiguration avaticaServerConfiguration) {
        ServerCustomizersFactory factory = InstanceResolver.getSingleton(ServerCustomizersFactory.class, DEFAULT_SERVER_CUSTOMIZERS);
        return factory.createServerCustomizers(conf, avaticaServerConfiguration);
    }

    AvaticaServerConfiguration createAvaticaServerConfig(Configuration conf, UserGroupInformation ugi) {
        AvaticaServerConfigurationFactory factory = InstanceResolver.getSingleton(AvaticaServerConfigurationFactory.class, DEFAULT_SERVER_CONFIG);
        return factory.getAvaticaServerConfiguration(conf, ugi);
    }

    private static String stripHostNameFromPrincipal(String remoteUserName) {
        int atSignIndex = remoteUserName.indexOf(64);
        int separatorIndex = remoteUserName.indexOf(47);
        if (atSignIndex == -1 && separatorIndex > 0) {
            remoteUserName = remoteUserName.substring(0, separatorIndex);
        }
        return remoteUserName;
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new QueryServer(), (String[])argv);
        System.exit(ret);
    }

    public static class PhoenixDoAsCallback
    implements DoAsRemoteUserCallback {
        private final UserGroupInformation serverUgi;
        private final SimpleLRUCache<String, UserGroupInformation> ugiCache;

        public PhoenixDoAsCallback(UserGroupInformation serverUgi, Configuration conf) {
            this.serverUgi = Objects.requireNonNull(serverUgi);
            this.ugiCache = new SimpleLRUCache(conf.getLong("phoenix.queryserver.ugi.cache.max.size", 1000L), conf.getInt("phoenix.queryserver.ugi.cache.concurrency", 10));
        }

        @Override
        public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, final Callable<T> action) throws Exception {
            UserGroupInformation proxyUser = this.createProxyUser(QueryServer.stripHostNameFromPrincipal(remoteUserName));
            return (T)proxyUser.doAs(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return action.call();
                }
            });
        }

        UserGroupInformation createProxyUser(String remoteUserName) throws ExecutionException {
            return this.ugiCache.computeIfAbsent(remoteUserName, f -> UserGroupInformation.createProxyUser((String)f, (UserGroupInformation)this.serverUgi));
        }

        SimpleLRUCache<String, UserGroupInformation> getCache() {
            return this.ugiCache;
        }
    }

    static class PhoenixRemoteUserExtractor
    implements RemoteUserExtractor {
        private final HttpQueryStringParameterRemoteUserExtractor paramRemoteUserExtractor;
        private final HttpRequestRemoteUserExtractor requestRemoteUserExtractor = new HttpRequestRemoteUserExtractor();
        private final String userExtractParam;

        public PhoenixRemoteUserExtractor(Configuration conf) {
            this.userExtractParam = conf.get("phoenix.queryserver.remoteUserExtractor.param", "doAs");
            this.paramRemoteUserExtractor = new HttpQueryStringParameterRemoteUserExtractor(this.userExtractParam);
        }

        @Override
        public String extract(HttpServletRequest request) throws RemoteUserExtractionException {
            if (request.getParameter(this.userExtractParam) != null) {
                String extractedUser = this.paramRemoteUserExtractor.extract(request);
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)QueryServer.stripHostNameFromPrincipal(request.getRemoteUser()));
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)extractedUser, (UserGroupInformation)ugi);
                try {
                    ProxyUsers.authorize((UserGroupInformation)proxyUser, (String)request.getRemoteAddr());
                    return extractedUser;
                }
                catch (AuthorizationException e) {
                    throw new RemoteUserExtractionException(e.getMessage(), e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("The parameter (" + this.userExtractParam + ") used to extract the remote user doesn't exist in the request.");
            }
            return this.requestRemoteUserExtractor.extract(request);
        }
    }
}

