/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.shaded.org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Internal;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.EntityDetails;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.Header;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpException;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpRequest;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.ProtocolException;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2RequestConformance
implements HttpRequestInterceptor {
    public static final H2RequestConformance INSTANCE = new H2RequestConformance();
    private final String[] illegalHeaderNames;

    @Internal
    public H2RequestConformance(String ... illegalHeaderNames) {
        this.illegalHeaderNames = illegalHeaderNames;
    }

    public H2RequestConformance() {
        this("Connection", "Keep-Alive", "Proxy-Connection", "Transfer-Encoding", "Upgrade", "TE");
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext localContext) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        for (int i = 0; i < this.illegalHeaderNames.length; ++i) {
            String headerName = this.illegalHeaderNames[i];
            Header header = request.getFirstHeader(headerName);
            if (header == null) continue;
            if (headerName.equalsIgnoreCase("TE")) {
                String value = header.getValue();
                if ("trailers".equalsIgnoreCase(value)) continue;
                throw new ProtocolException("Header '%s: %s' is illegal for HTTP/2 messages", "TE", value);
            }
            throw new ProtocolException("Header '%s' is illegal for HTTP/2 messages", headerName);
        }
    }
}

