/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.shaded.org.apache.hc.core5.http2.hpack;

import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.Header;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http2.hpack.FifoBuffer;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http2.hpack.StaticTable;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Asserts;

final class InboundDynamicTable {
    private final StaticTable staticTable;
    private final FifoBuffer headers;
    private int maxSize;
    private int currentSize;

    InboundDynamicTable(int maxSize, StaticTable staticTable) {
        this.staticTable = staticTable;
        this.headers = new FifoBuffer(256);
        this.maxSize = maxSize;
        this.currentSize = 0;
    }

    InboundDynamicTable(int maxSize) {
        this(maxSize, StaticTable.INSTANCE);
    }

    InboundDynamicTable() {
        this(Integer.MAX_VALUE);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.evict();
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    int staticLength() {
        return this.staticTable.length();
    }

    int dynamicLength() {
        return this.headers.size();
    }

    Header getDynamicEntry(int index) {
        return this.headers.get(index);
    }

    public int length() {
        return this.staticTable.length() + this.headers.size();
    }

    public HPackHeader getHeader(int index) {
        int length = this.length();
        Args.check(index >= 1, "index %s cannot be less than 1", (Object)index);
        Args.check(index <= length, "length %s cannot be greater than index %s", length, index);
        return index <= this.staticTable.length() ? this.staticTable.get(index) : this.headers.get(index - this.staticTable.length() - 1);
    }

    public void add(HPackHeader header) {
        int entrySize = header.getTotalSize();
        if (entrySize > this.maxSize) {
            this.clear();
            return;
        }
        this.headers.addFirst(header);
        this.currentSize += entrySize;
        this.evict();
    }

    private void clear() {
        this.currentSize = 0;
        this.headers.clear();
    }

    private void evict() {
        while (this.currentSize > this.maxSize) {
            HPackHeader header = this.headers.removeLast();
            if (header != null) {
                this.currentSize -= header.getTotalSize();
                continue;
            }
            Asserts.check(this.currentSize == 0, "Current table size must be zero");
            break;
        }
    }
}

