/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.impl;

import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestConformance;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.RequestValidateHost;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.ResponseConformance;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.ResponseServer;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.TextUtils;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(ResponseConformance.INSTANCE, ResponseDate.INSTANCE, new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.calcite.avatica.shaded.org.apache.hc.core5", HttpProcessors.class)), ResponseContent.INSTANCE, ResponseConnControl.INSTANCE).addAll(RequestValidateHost.INSTANCE, RequestConformance.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestTargetHost.INSTANCE, RequestContent.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.calcite.avatica.shaded.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

