/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.protocol;

import org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.EntityDetails;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.FormattedHeader;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.Header;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpResponse;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.message.ParserCursor;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.TextUtils;
import org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Tokenizer;

@Contract(threading=ThreadingBehavior.STATELESS)
public class NextNonceInterceptor
implements HttpResponseInterceptor {
    public static final HttpResponseInterceptor INSTANCE = new NextNonceInterceptor();
    private final Tokenizer tokenParser = Tokenizer.INSTANCE;
    private static final String AUTHENTICATION_INFO_HEADER = "Authentication-Info";
    private static final Tokenizer.Delimiter TOKEN_DELIMS = Tokenizer.delimiters('=', ',');
    private static final Tokenizer.Delimiter VALUE_DELIMS = Tokenizer.delimiters(',');

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        Header header = response.getFirstHeader(AUTHENTICATION_INFO_HEADER);
        if (header != null) {
            String nextNonce;
            if (header instanceof FormattedHeader) {
                CharArrayBuffer buf = ((FormattedHeader)header).getBuffer();
                ParserCursor cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buf.length());
                nextNonce = this.parseNextNonce(buf, cursor);
            } else {
                String headerValue = header.getValue();
                ParserCursor cursor = new ParserCursor(0, headerValue.length());
                nextNonce = this.parseNextNonce(headerValue, cursor);
            }
            if (!TextUtils.isBlank(nextNonce)) {
                HttpClientContext.castOrCreate(context).setNextNonce(nextNonce);
            }
        }
    }

    private String parseNextNonce(CharSequence buffer, ParserCursor cursor) {
        while (!cursor.atEnd()) {
            String name = this.tokenParser.parseToken(buffer, (Tokenizer.Cursor)cursor, TOKEN_DELIMS);
            if ("nextnonce".equals(name)) {
                cursor.updatePos(cursor.getPos() + 1);
                return this.tokenParser.parseValue(buffer, (Tokenizer.Cursor)cursor, VALUE_DELIMS);
            }
            if (cursor.atEnd()) continue;
            cursor.updatePos(cursor.getPos() + 1);
        }
        return null;
    }
}

