/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server.customizers;

import java.io.File;
import org.apache.phoenix.queryserver.server.customizers.HostedClientJarsServerCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HostedClientJarsServerCustomizerTest {
    @Test
    public void testHandlerIsPrefixed() {
        Handler handler1 = (Handler)Mockito.mock(Handler.class);
        Handler handler2 = (Handler)Mockito.mock(Handler.class);
        Server svr = new Server();
        svr.setHandler((Handler)new HandlerList(new Handler[]{handler1, handler2}));
        File f = new File("/for-test");
        String context = "/my-context";
        HostedClientJarsServerCustomizer customizer = new HostedClientJarsServerCustomizer(f, context);
        customizer.customize(svr);
        Assert.assertEquals((long)1L, (long)svr.getHandlers().length);
        Handler actualHandler = svr.getHandler();
        Assert.assertTrue((String)("Handler was " + actualHandler.getClass()), (boolean)(actualHandler instanceof HandlerList));
        HandlerList actualHandlerList = (HandlerList)actualHandler;
        Assert.assertEquals((long)3L, (long)actualHandlerList.getHandlers().length);
        Assert.assertEquals((Object)handler1, (Object)actualHandlerList.getHandlers()[1]);
        Assert.assertEquals((Object)handler2, (Object)actualHandlerList.getHandlers()[2]);
        Handler injectedHandler = actualHandlerList.getHandlers()[0];
        Assert.assertTrue((String)("Handler was " + injectedHandler.getClass()), (boolean)(injectedHandler instanceof ContextHandler));
        ContextHandler ctx = (ContextHandler)injectedHandler;
        Assert.assertTrue((String)("Handler was " + ctx.getHandler().getClass()), (boolean)(ctx.getHandler() instanceof ResourceHandler));
        Assert.assertEquals((Object)context, (Object)ctx.getContextPath());
        ResourceHandler res = (ResourceHandler)ctx.getHandler();
        Assert.assertEquals((Object)("file://" + f.getAbsolutePath()), (Object)res.getResourceBase());
    }
}

