/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.io.File;
import java.io.IOException;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.DoAsRemoteUserCallback;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueryServerConfigurationTest {
    private static final Configuration CONF = HBaseConfiguration.create();
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    private HttpServer.Builder builder;
    private QueryServer queryServer;
    private UserGroupInformation ugi;

    @Before
    public void setup() throws IOException {
        this.builder = (HttpServer.Builder)Mockito.mock(HttpServer.Builder.class);
        this.queryServer = new QueryServer(new String[0], CONF);
        this.ugi = this.queryServer.getUserGroupInformation();
    }

    @Test
    public void testSpnegoEnabled() throws IOException {
        this.setupKeytabForSpnego();
        ((HttpServer.Builder)Mockito.doReturn((Object)this.builder).when((Object)this.builder)).withSpnego(ArgumentMatchers.anyString(), (String[])ArgumentMatchers.nullable(String[].class));
        this.configureAndVerifyImpersonation(this.builder, false);
        ((HttpServer.Builder)Mockito.verify((Object)this.builder)).withAutomaticLogin((File)ArgumentMatchers.any(File.class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withCustomAuthentication((AvaticaServerConfiguration)ArgumentMatchers.any(AvaticaServerConfiguration.class));
    }

    @Test
    public void testSpnegoDisabled() throws IOException {
        this.setupKeytabForSpnego();
        this.configureAndVerifyImpersonation(this.builder, true);
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withSpnego(ArgumentMatchers.anyString(), (String[])ArgumentMatchers.any(String[].class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withAutomaticLogin((File)ArgumentMatchers.any(File.class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withCustomAuthentication((AvaticaServerConfiguration)ArgumentMatchers.any(AvaticaServerConfiguration.class));
    }

    @Test
    public void testCustomServerConfiguration() {
        this.queryServer.enableCustomAuth(this.builder, CONF, this.ugi);
        ((HttpServer.Builder)Mockito.verify((Object)this.builder)).withCustomAuthentication((AvaticaServerConfiguration)ArgumentMatchers.nullable(AvaticaServerConfiguration.class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withSpnego(ArgumentMatchers.anyString(), (String[])ArgumentMatchers.nullable(String[].class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withAutomaticLogin((File)ArgumentMatchers.any(File.class));
        ((HttpServer.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).withImpersonation((DoAsRemoteUserCallback)ArgumentMatchers.any(DoAsRemoteUserCallback.class));
    }

    private void setupKeytabForSpnego() throws IOException {
        File keytabFile = this.testFolder.newFile("test.keytab");
        CONF.set("phoenix.queryserver.keytab.file", keytabFile.getAbsolutePath());
    }

    private void configureAndVerifyImpersonation(HttpServer.Builder builder, boolean disableSpnego) throws IOException {
        this.queryServer.configureClientAuthentication(builder, disableSpnego, this.ugi);
        ((HttpServer.Builder)Mockito.verify((Object)builder)).withImpersonation((DoAsRemoteUserCallback)ArgumentMatchers.any(DoAsRemoteUserCallback.class));
    }
}

