/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.tool.CanaryTestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixCanaryTool
extends Configured
implements Tool {
    private static String TEST_SCHEMA_NAME = "TEST";
    private static String TEST_TABLE_NAME = "PQSTEST";
    private static String FQ_TABLE_NAME = "TEST.PQSTEST";
    private static Timestamp timestamp;
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private final int FIRST_TIME_RETRY_TIMEOUT = 5000;
    private Sink sink = new StdOutSink();
    public static final String propFileName = "phoenix-canary-file-sink.properties";
    private static final Logger LOGGER;
    private CanaryTestResult appInfo = new CanaryTestResult();
    private Connection connection = null;

    private static String getCurrentTimestamp() {
        return new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.ms").format(new Date());
    }

    private static Namespace parseArgs(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"Phoenix Canary Test Tool").build().description("Phoenix Canary Test Tool");
        parser.addArgument(new String[]{"--hostname", "-hn"}).type(String.class).nargs("?").help("Hostname on which Phoenix is running.");
        parser.addArgument(new String[]{"--port", "-p"}).type(String.class).nargs("?").help("Port on which Phoenix is running.");
        parser.addArgument(new String[]{"--constring", "-cs"}).type(String.class).nargs("?").help("Pass an explicit connection String to connect to Phoenix. default: jdbc:phoenix:thin:serialization=PROTOBUF;url=[hostName:port]");
        parser.addArgument(new String[]{"--timeout", "-t"}).type(String.class).nargs("?").setDefault((Object)"60").help("Maximum time for which the app should run before returning error. default: 60 sec");
        parser.addArgument(new String[]{"--testschema", "-ts"}).type(String.class).nargs("?").setDefault((Object)TEST_SCHEMA_NAME).help("Custom name for the test table. default: " + TEST_SCHEMA_NAME);
        parser.addArgument(new String[]{"--testtable", "-tt"}).type(String.class).nargs("?").setDefault((Object)TEST_TABLE_NAME).help("Custom name for the test table. default: " + TEST_TABLE_NAME);
        parser.addArgument(new String[]{"--logsinkclass", "-lsc"}).type(String.class).nargs("?").setDefault((Object)"org.apache.phoenix.tool.PhoenixCanaryTool$StdOutSink").help("Path to a Custom implementation for log sink class. default: stdout");
        Namespace res = null;
        try {
            res = parser.parseKnownArgs(args, null);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        try {
            Namespace cArgs = PhoenixCanaryTool.parseArgs(args);
            if (cArgs == null) {
                LOGGER.error("Argument parsing failed.");
                throw new RuntimeException("Argument parsing failed");
            }
            String hostName = cArgs.getString("hostname");
            String port = cArgs.getString("port");
            String timeout = cArgs.getString("timeout");
            String conString = cArgs.getString("constring");
            String testSchemaName = cArgs.getString("testschema");
            String testTableName = cArgs.getString("testtable");
            String logSinkClass = cArgs.getString("logsinkclass");
            TEST_TABLE_NAME = testTableName;
            TEST_SCHEMA_NAME = testSchemaName;
            FQ_TABLE_NAME = testSchemaName + "." + testTableName;
            if ((hostName == null || port == null) && conString == null) {
                throw new RuntimeException("Provide at least one from host+port or constring");
            }
            int timeoutVal = Integer.parseInt(timeout);
            this.sink = (Sink)ClassLoader.getSystemClassLoader().loadClass(logSinkClass).newInstance();
            long startTime = System.currentTimeMillis();
            String connectionURL = conString != null ? conString : "jdbc:phoenix:thin:serialization=PROTOBUF;url=" + hostName + ":" + port;
            this.appInfo.setTestName("appInfo");
            this.appInfo.setMiscellaneous(connectionURL);
            this.connection = this.getConnectionWithRetry(connectionURL);
            if (this.connection == null) {
                LOGGER.error("Failed to get connection after multiple retries; the connection is null");
            }
            ExecutorService executor = Executors.newFixedThreadPool(1);
            Future<Void> future = executor.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    PhoenixCanaryTool.this.sink.clearResults();
                    LOGGER.info("Starting UpsertTableTest");
                    PhoenixCanaryTool.this.sink.updateResults(new UpsertTableTest().runTest(PhoenixCanaryTool.this.connection));
                    LOGGER.info("Starting ReadTableTest");
                    PhoenixCanaryTool.this.sink.updateResults(new ReadTableTest().runTest(PhoenixCanaryTool.this.connection));
                    return null;
                }
            });
            try {
                future.get(timeoutVal, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                future.cancel(true);
                throw e;
            }
            long estimatedTime = System.currentTimeMillis() - startTime;
            this.appInfo.setExecutionTime(estimatedTime);
            this.appInfo.setSuccessful(true);
        }
        catch (Exception e) {
            LOGGER.error("error running tests", (Throwable)e);
            this.appInfo.setMessage(PhoenixCanaryTool.getStackTrace(e));
            this.appInfo.setSuccessful(false);
        }
        finally {
            this.sink.updateResults(this.appInfo);
            this.sink.publishResults();
            this.connection.close();
        }
        return 0;
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private Connection getConnectionWithRetry(String connectionURL) {
        Connection connection = null;
        try {
            connection = this.getConnectionWithRetry(connectionURL, true);
        }
        catch (Exception e) {
            LOGGER.info("Failed to get connection with namespace enabled", (Throwable)e);
            try {
                connection = this.getConnectionWithRetry(connectionURL, false);
            }
            catch (Exception ex) {
                LOGGER.info("Failed to get connection without namespace enabled", (Throwable)ex);
            }
        }
        return connection;
    }

    private Connection getConnectionWithRetry(String connectionURL, boolean namespaceFlag) throws Exception {
        Properties connProps = new Properties();
        Connection connection = null;
        connProps.setProperty("phoenix.schema.mapSystemTablesToNamespace", String.valueOf(namespaceFlag));
        connProps.setProperty("phoenix.schema.isNamespaceMappingEnabled", String.valueOf(namespaceFlag));
        RetryCounter retrier = new RetryCounter(5, 5000L, TimeUnit.MILLISECONDS);
        LOGGER.info("Trying to get the connection with " + retrier.getMaxAttempts() + " attempts with connectionURL :" + connectionURL + "connProps :" + connProps);
        while (retrier.shouldRetry()) {
            try {
                connection = DriverManager.getConnection(connectionURL, connProps);
            }
            catch (SQLException e) {
                LOGGER.info("Trying to establish connection with " + retrier.getAttemptTimes() + " attempts", (Throwable)e);
            }
            if (connection != null) {
                LOGGER.info("Successfully established connection within " + retrier.getAttemptTimes() + " attempts");
                break;
            }
            retrier.sleepUntilNextRetry();
        }
        return connection;
    }

    public static void main(String[] args) {
        try {
            LOGGER.info("Starting Phoenix Canary Test tool...");
            ToolRunner.run((Tool)new PhoenixCanaryTool(), (String[])args);
        }
        catch (Exception e) {
            LOGGER.error("Error in running Phoenix Canary Test tool. " + e);
        }
        LOGGER.info("Exiting Phoenix Canary Test tool...");
    }

    static {
        LOGGER = LoggerFactory.getLogger(PhoenixCanaryTool.class);
    }

    public static interface Sink {
        public List<CanaryTestResult> getResults();

        public void updateResults(CanaryTestResult var1);

        public void publishResults() throws Exception;

        public void clearResults();
    }

    public static class StdOutSink
    implements Sink {
        private List<CanaryTestResult> results = new ArrayList<CanaryTestResult>();

        @Override
        public void updateResults(CanaryTestResult result) {
            this.results.add(result);
        }

        @Override
        public List<CanaryTestResult> getResults() {
            return this.results;
        }

        @Override
        public void publishResults() {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String resultJson = gson.toJson(this.results);
            System.out.println(resultJson);
        }

        @Override
        public void clearResults() {
            this.results.clear();
        }
    }

    public static class FileOutSink
    implements Sink {
        private List<CanaryTestResult> results = new ArrayList<CanaryTestResult>();
        File dir;
        String logfileName;

        public FileOutSink() throws Exception {
            Properties prop = new Properties();
            InputStream input = ClassLoader.getSystemResourceAsStream(PhoenixCanaryTool.propFileName);
            if (input == null) {
                throw new Exception("Cannot load phoenix-canary-file-sink.properties file for FileOutSink.");
            }
            prop.load(input);
            this.logfileName = prop.getProperty("file.name");
            this.dir = new File(prop.getProperty("file.location"));
            this.dir.mkdirs();
        }

        @Override
        public void updateResults(CanaryTestResult result) {
            this.results.add(result);
        }

        @Override
        public List<CanaryTestResult> getResults() {
            return this.results;
        }

        @Override
        public void publishResults() throws Exception {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String resultJson = gson.toJson(this.results);
            String fileName = this.logfileName + "-" + new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date()) + ".log";
            File file = new File(this.dir, fileName);
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(Bytes.toBytes((String)resultJson));
            }
        }

        @Override
        public void clearResults() {
            this.results.clear();
        }
    }

    static class ReadTableTest
    extends CanaryTest {
        ReadTableTest() {
        }

        @Override
        void onExecute() throws Exception {
            this.result.setTestName("readTable");
            PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM " + FQ_TABLE_NAME + " WHERE INSERT_DATE = ?");
            ps.setTimestamp(1, timestamp);
            ResultSet rs = ps.executeQuery();
            int totalRows = 0;
            while (rs.next()) {
                ++totalRows;
                Integer myKey = rs.getInt(1);
                String myColumn = rs.getString(2);
                if (myKey == 1 && myColumn.equals("Hello World")) continue;
                throw new Exception("Retrieved values do not match the inserted values");
            }
            if (totalRows != 1) {
                throw new Exception(totalRows + " rows fetched instead of just one.");
            }
            ps.close();
            rs.close();
        }
    }

    static class UpsertTableTest
    extends CanaryTest {
        UpsertTableTest() {
        }

        @Override
        void onExecute() throws Exception {
            this.result.setTestName("upsertTable");
            timestamp = new Timestamp(System.currentTimeMillis());
            String stmt = "UPSERT INTO " + FQ_TABLE_NAME + "(mykey, mycolumn, insert_date) VALUES (?, ?, ?)";
            PreparedStatement ps = this.connection.prepareStatement(stmt);
            ps.setInt(1, 1);
            ps.setString(2, "Hello World");
            ps.setTimestamp(3, timestamp);
            ps.executeUpdate();
            this.connection.commit();
        }
    }

    private static abstract class CanaryTest {
        CanaryTestResult result = new CanaryTestResult();
        Connection connection = null;

        private CanaryTest() {
        }

        private void onCreate(Connection connection) {
            this.result.setTimestamp(PhoenixCanaryTool.getCurrentTimestamp());
            this.result.setStartTime(System.currentTimeMillis());
            this.connection = connection;
        }

        abstract void onExecute() throws Exception;

        private void onExit() {
            this.result.setExecutionTime(System.currentTimeMillis() - this.result.getStartTime());
        }

        CanaryTestResult runTest(Connection connection) {
            try {
                this.onCreate(connection);
                this.onExecute();
                this.result.setSuccessful(true);
                this.result.setMessage("Test " + this.result.getTestName() + " successful");
            }
            catch (Exception e) {
                this.result.setSuccessful(false);
                this.result.setMessage(PhoenixCanaryTool.getStackTrace(e));
            }
            finally {
                this.onExit();
            }
            return this.result;
        }
    }
}

