/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.orchestrator;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.phoenix.queryserver.orchestrator.TestExecutorClient;
import org.apache.phoenix.queryserver.orchestrator.ToolWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServerCanaryOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServerCanaryOrchestrator.class);
    private static String ZK_PATH = "/pqs/leader";

    private static Namespace parseArgs(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"PQS Canary Orchestrator").build().description("PQS Canary Orchestrator");
        parser.addArgument(new String[]{"--zkurl", "-zk"}).type(String.class).help("URL for Zookeeper");
        parser.addArgument(new String[]{"--zkpath", "-zkp"}).type(String.class).nargs("?").setDefault((Object)ZK_PATH).help("ZKNode path default: " + ZK_PATH);
        parser.addArgument(new String[]{"--hostname", "-hn"}).type(String.class).nargs("?").setDefault((Object)"localhost").help("Hostname on which PQS is running.");
        parser.addArgument(new String[]{"--port", "-p"}).type(String.class).nargs("?").setDefault((Object)"8765").help("Port on which PQS is running.");
        parser.addArgument(new String[]{"--constring", "-cs"}).type(String.class).nargs("?").help("Pass an explicit connection String to connect to PQS. default: null");
        parser.addArgument(new String[]{"--timeout", "-t"}).type(String.class).nargs("?").setDefault((Object)"120").help("Maximum time for which the app should run before returning error. default: 120 sec");
        parser.addArgument(new String[]{"--testtable", "-tt"}).type(String.class).nargs("?").setDefault((Object)"PQSTEST").help("Custom name for the test table. default: PQSTEST");
        parser.addArgument(new String[]{"--testschema", "-ts"}).type(String.class).nargs("?").setDefault((Object)"TEST").help("Custom name for the test table. default: TEST");
        parser.addArgument(new String[]{"--logsinkclass", "-lsc"}).type(String.class).nargs("?").setDefault((Object)"org.apache.phoenix.tool.PhoenixCanaryTool$StdOutSink").help("Path to a Custom implementation for log sink class. default: stdout");
        parser.addArgument(new String[]{"--interval", "-in"}).type(String.class).nargs("?").setDefault((Object)"900").help("Time interval between 2 consecutive test suite runs");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
        return res;
    }

    public static Map<String, String> getArgs(Namespace cArgs) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : cArgs.getAttrs().entrySet()) {
            params.put((String)entry.getKey(), (String)entry.getValue());
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOGGER.info("Starting PQS Canary Orchestrator...");
        ToolWrapper tool = new ToolWrapper();
        try {
            Namespace cArgs = QueryServerCanaryOrchestrator.parseArgs(args);
            if (cArgs == null) {
                throw new RuntimeException("Argument parsing failed");
            }
            Map<String, String> params = QueryServerCanaryOrchestrator.getArgs(cArgs);
            ZK_PATH = params.get("zkpath");
            CuratorFramework curatorClient = CuratorFrameworkFactory.newClient((String)params.get("zkurl"), (RetryPolicy)new BoundedExponentialBackoffRetry(1000, 60000, 50000));
            curatorClient.start();
            TestExecutorClient testExecutorClient = new TestExecutorClient(curatorClient, ZK_PATH, params, tool);
            try {
                testExecutorClient.start();
                while (!testExecutorClient.isDone()) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception ex) {
                LOGGER.error("The Main thread was interrupted", (Throwable)ex);
            }
            finally {
                LOGGER.info("Shutdown Hook for PQS Canary Orchestrator running...");
                CloseableUtils.closeQuietly((Closeable)testExecutorClient);
                CloseableUtils.closeQuietly((Closeable)curatorClient);
                LOGGER.info("Closed Curator Client");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in PQS Canary Orchestrator. ", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOGGER.info("Exiting PQS Canary Orchestrator...");
    }
}

