/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.orchestrator;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.CancelLeadershipException;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.phoenix.queryserver.orchestrator.ToolWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutorClient
extends LeaderSelectorListenerAdapter
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestExecutorClient.class);
    private final LeaderSelector leaderSelector;
    private Map<String, String> params;
    private ToolWrapper toolWrapper;
    private Boolean isRunning = false;

    public TestExecutorClient(CuratorFramework client, String path, Map<String, String> params, ToolWrapper tool) {
        this.leaderSelector = new LeaderSelector(client, path, (LeaderSelectorListener)this);
        this.leaderSelector.autoRequeue();
        this.params = params;
        this.toolWrapper = tool;
    }

    @Override
    public void close() {
        this.leaderSelector.close();
    }

    public void start() {
        this.leaderSelector.start();
        this.isRunning = true;
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        LOGGER.info("Took leadership.");
        while (true) {
            LOGGER.info("Starting test case suite execution.");
            this.executeQueryServerCanaryTool();
            LOGGER.info("Test suite execution completed. Waiting for " + this.params.get("interval") + " secs before executing next run.");
            TimeUnit.SECONDS.sleep(Integer.parseInt(this.params.get("interval")));
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        LOGGER.info("ZK Connection State Changed to [{}]", (Object)newState.name());
        switch (newState) {
            case CONNECTED: {
                LOGGER.info("The host is connected at" + System.currentTimeMillis());
                break;
            }
            case LOST: {
                LOGGER.info("The host lost connection at " + System.currentTimeMillis());
                this.isRunning = false;
                throw new CancelLeadershipException();
            }
            case READ_ONLY: {
                LOGGER.info("The connection state is Read only since " + System.currentTimeMillis());
                break;
            }
            case RECONNECTED: {
                LOGGER.info("Reconnected to the ZK Path at " + System.currentTimeMillis());
                break;
            }
            case SUSPENDED: {
                this.isRunning = false;
                throw new CancelLeadershipException();
            }
        }
    }

    public void executeQueryServerCanaryTool() {
        ArrayList<String> cmd = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (entry.getValue() == null) continue;
            cmd.add("--" + entry.getKey());
            cmd.add(entry.getValue());
        }
        LOGGER.info("Test Suit execution started.");
        this.toolWrapper.executeMain(cmd.toArray(new String[cmd.size()]));
    }

    public boolean isDone() {
        return this.isRunning == false;
    }
}

