/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.loadbalancer.service;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.util.HostAndPort;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class LoadBalanceZookeeperConfImpl
implements LoadBalanceZookeeperConf {
    private Configuration configuration;

    public LoadBalanceZookeeperConfImpl() {
        this.configuration = HBaseConfiguration.create();
    }

    public LoadBalanceZookeeperConfImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getQueryServerBasePath() {
        return this.configuration.get("phoenix.queryserver.base.path", "/phoenix");
    }

    public String getServiceName() {
        return this.configuration.get("phoenix.queryserver.service.name", "queryserver");
    }

    public String getZkConnectString() {
        return ZKConfig.standardizeZKQuorumServerString((String)this.configuration.get("hbase.zookeeper.quorum", "localhost"), (String)this.configuration.get("hbase.zookeeper.property.clientPort", "2181"));
    }

    private String getZkLbUserName() {
        return this.configuration.get("phoenix.queryserver.zookeeper.acl.username", "phoenix");
    }

    private String getZkLbPassword() {
        return this.configuration.get("phoenix.queryserver.zookeeper.acl.password", "phoenix");
    }

    public List<ACL> getAcls() {
        ACL acl = new ACL();
        acl.setId(new Id("digest", this.getZkLbUserName() + ":" + this.getZkLbPassword()));
        acl.setPerms(1);
        return Arrays.asList(acl);
    }

    public String getParentPath() {
        String path = String.format("%s/%s", this.getQueryServerBasePath(), this.getServiceName());
        return path;
    }

    public String getFullPathToNode(HostAndPort hostAndPort) {
        String path = String.format("%s/%s", this.getParentPath(), hostAndPort.toString());
        return path;
    }
}

