/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.CloseableUtils;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConfImpl;
import org.apache.phoenix.loadbalancer.service.LoadBalancer;
import org.apache.phoenix.queryserver.register.Registry;
import org.apache.phoenix.queryserver.register.ZookeeperRegistry;
import org.apache.phoenix.util.HostAndPort;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerEnd2EndIT {
    private static TestingServer testingServer;
    private static CuratorFramework curatorFramework;
    private static final Logger LOG;
    private static final LoadBalanceZookeeperConf LOAD_BALANCER_CONFIGURATION;
    private static String path;
    private static LoadBalancer loadBalancer;
    private static HostAndPort pqs1;
    private static HostAndPort pqs2;
    private static HostAndPort pqs3;
    public static String zkConnectString;
    public static Registry registry;

    @BeforeClass
    public static synchronized void setup() throws Exception {
        registry = new ZookeeperRegistry();
        zkConnectString = LOAD_BALANCER_CONFIGURATION.getZkConnectString();
        int port = Integer.parseInt(zkConnectString.split(":")[1]);
        testingServer = new TestingServer(port);
        testingServer.start();
        path = LOAD_BALANCER_CONFIGURATION.getParentPath();
        curatorFramework = CuratorFrameworkFactory.newClient((String)zkConnectString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        curatorFramework.start();
        LoadBalancerEnd2EndIT.createNodeForTesting(Arrays.asList(pqs1, pqs2, pqs3));
        curatorFramework.setACL().withACL(LOAD_BALANCER_CONFIGURATION.getAcls());
        loadBalancer = LoadBalancer.getLoadBalancer();
    }

    @AfterClass
    public static synchronized void tearDown() throws Exception {
        CloseableUtils.closeQuietly((Closeable)curatorFramework);
        CloseableUtils.closeQuietly((Closeable)testingServer);
    }

    private static void createNodeForTesting(List<HostAndPort> pqsNodes) throws Exception {
        for (HostAndPort pqs : pqsNodes) {
            registry.registerServer(LOAD_BALANCER_CONFIGURATION, pqs.getPort(), zkConnectString, pqs.getHostText());
        }
        ((List)curatorFramework.getChildren().forPath(LOAD_BALANCER_CONFIGURATION.getParentPath())).size();
    }

    @Test
    public void testGetAllServiceLocation() throws Exception {
        Assert.assertNotNull((Object)loadBalancer);
        List serviceLocations = loadBalancer.getAllServiceLocation();
        Assert.assertTrue((String)" must contains 3 service location", (serviceLocations.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSingleServiceLocation() throws Exception {
        Assert.assertNotNull((Object)loadBalancer);
        HostAndPort serviceLocation = loadBalancer.getSingleServiceLocation();
        Assert.assertNotNull((Object)serviceLocation);
    }

    @Test(expected=Exception.class)
    public void testZookeeperDown() throws Exception {
        testingServer.stop();
        CuratorZookeeperClient zookeeperClient = curatorFramework.getZookeeperClient();
        while (zookeeperClient.isConnected()) {
            Thread.sleep(1000L);
        }
        loadBalancer.getSingleServiceLocation();
    }

    @Test(expected=KeeperException.NoNodeException.class)
    public void testNoPhoenixQueryServerNodeInZookeeper() throws Exception {
        List<HostAndPort> hostAndPorts = Arrays.asList(pqs1, pqs2, pqs3);
        for (HostAndPort pqs : hostAndPorts) {
            String fullPathToNode = LOAD_BALANCER_CONFIGURATION.getFullPathToNode(pqs);
            curatorFramework.delete().deletingChildrenIfNeeded().forPath(fullPathToNode);
            while (curatorFramework.checkExists().forPath(fullPathToNode) != null) {
                Thread.sleep(1000L);
            }
        }
        curatorFramework.delete().forPath(path);
        try {
            loadBalancer.getSingleServiceLocation();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            LoadBalancerEnd2EndIT.createNodeForTesting(hostAndPorts);
        }
    }

    @Test
    public void testSingletonPropertyForLoadBalancer() {
        LoadBalancer anotherloadBalancerRef = LoadBalancer.getLoadBalancer();
        Assert.assertTrue((String)" the load balancer is not singleton", (loadBalancer == anotherloadBalancerRef ? 1 : 0) != 0);
    }

    static {
        LOG = LoggerFactory.getLogger(LoadBalancerEnd2EndIT.class);
        LOAD_BALANCER_CONFIGURATION = new LoadBalanceZookeeperConfImpl();
        pqs1 = HostAndPort.fromParts((String)"localhost", (int)1000);
        pqs2 = HostAndPort.fromParts((String)"localhost", (int)2000);
        pqs3 = HostAndPort.fromParts((String)"localhost", (int)3000);
    }
}

