/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.register;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.queryserver.register.Registry;
import org.apache.phoenix.util.HostAndPort;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistry
implements Registry {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperRegistry.class);
    private CuratorFramework client;

    public void registerServer(LoadBalanceZookeeperConf configuration, int pqsPort, String zookeeperConnectString, String pqsHost) throws Exception {
        this.client = CuratorFrameworkFactory.newClient((String)zookeeperConnectString, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
        this.client.start();
        HostAndPort hostAndPort = HostAndPort.fromParts((String)pqsHost, (int)pqsPort);
        String path = configuration.getFullPathToNode(hostAndPort);
        String node = hostAndPort.toString();
        ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, node.getBytes(StandardCharsets.UTF_8));
        Stat stat = (Stat)((BackgroundPathable)this.client.setACL().withACL(configuration.getAcls())).forPath(path);
        if (stat == null) {
            LOG.error("could not create node with right ACL. So, system would exit now.");
            throw new RuntimeException(" Unable to connect to Zookeeper");
        }
        LOG.info(" node created with right ACL");
    }

    public void unRegisterServer() throws Exception {
        CloseableUtils.closeQuietly((Closeable)this.client);
    }
}

