/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.loadbalancer.service;

import java.io.Closeable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConfImpl;
import org.apache.phoenix.util.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancer {
    private static final LoadBalanceZookeeperConf CONFIG = new LoadBalanceZookeeperConfImpl(HBaseConfiguration.create());
    private static CuratorFramework curaFramework = null;
    protected static final Logger LOG = LoggerFactory.getLogger(LoadBalancer.class);
    private static PathChildrenCache cache = null;
    private static final LoadBalancer loadBalancer = new LoadBalancer();
    private ConnectionStateListener connectionStateListener = null;
    private UnhandledErrorListener unhandledErrorListener = null;
    private List<Closeable> closeAbles = new ArrayList<Closeable>();

    private LoadBalancer() {
        try {
            this.start();
        }
        catch (Exception ex) {
            LOG.error("Exception while creating a zookeeper clients and cache", (Throwable)ex);
            if (curaFramework != null && this.connectionStateListener != null) {
                curaFramework.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
            }
            if (curaFramework != null && this.unhandledErrorListener != null) {
                curaFramework.getUnhandledErrorListenable().removeListener((Object)this.unhandledErrorListener);
            }
            for (Closeable closeable : this.closeAbles) {
                CloseableUtils.closeQuietly((Closeable)closeable);
            }
        }
    }

    public static LoadBalancer getLoadBalancer() {
        return loadBalancer;
    }

    public HostAndPort getSingleServiceLocation() throws Exception {
        List<HostAndPort> childNodes = this.conductSanityCheckAndReturn();
        int i = ThreadLocalRandom.current().nextInt(0, childNodes.size());
        return childNodes.get(i);
    }

    public List<HostAndPort> getAllServiceLocation() throws Exception {
        return this.conductSanityCheckAndReturn();
    }

    private List<HostAndPort> conductSanityCheckAndReturn() throws Exception {
        if (curaFramework == null) {
            throw new NullPointerException(String.valueOf(" curator framework in not initialized "));
        }
        if (cache == null) {
            throw new NullPointerException(String.valueOf(" cache value is not initialized"));
        }
        boolean connected = curaFramework.getZookeeperClient().isConnected();
        if (!connected) {
            String message = " Zookeeper seems to be down. The data is stale ";
            ConnectException exception = new ConnectException(message);
            LOG.error(message, (Throwable)exception);
            throw exception;
        }
        List currentNodes = (List)curaFramework.getChildren().forPath(CONFIG.getParentPath());
        ArrayList<HostAndPort> returnNodes = new ArrayList<HostAndPort>();
        String nodeAsString = null;
        for (String node : currentNodes) {
            try {
                returnNodes.add(HostAndPort.fromString((String)node));
            }
            catch (Throwable ex) {
                LOG.error(" something wrong with node string " + nodeAsString, ex);
            }
        }
        return returnNodes;
    }

    private String getZkConnectString() {
        return CONFIG.getZkConnectString();
    }

    private ConnectionStateListener getConnectionStateListener() {
        return new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (!newState.isConnected()) {
                    LOG.error(" connection to zookeeper broken. It is in  " + newState.name() + " state.");
                }
            }
        };
    }

    private UnhandledErrorListener getUnhandledErrorListener() {
        return new UnhandledErrorListener(){

            public void unhandledError(String message, Throwable e) {
                LOG.error("unhandled exception:  " + message, e);
            }
        };
    }

    private void start() throws Exception {
        curaFramework = CuratorFrameworkFactory.newClient((String)this.getZkConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        curaFramework.start();
        curaFramework.setACL().withACL(CONFIG.getAcls());
        this.connectionStateListener = this.getConnectionStateListener();
        curaFramework.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.unhandledErrorListener = this.getUnhandledErrorListener();
        curaFramework.getUnhandledErrorListenable().addListener((Object)this.unhandledErrorListener);
        cache = new PathChildrenCache(curaFramework, CONFIG.getParentPath(), true);
        cache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        this.closeAbles.add((Closeable)cache);
        this.closeAbles.add((Closeable)curaFramework);
    }
}

