/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.calcite.avatica.shaded.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.calcite.avatica.util.Base64;

public class ByteString
implements Comparable<ByteString>,
Serializable {
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0], false);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ByteString(byte[] bytes) {
        this((byte[])bytes.clone(), false);
    }

    private ByteString(byte[] bytes, boolean dummy) {
        this.bytes = bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteString && Arrays.equals(this.bytes, ((ByteString)obj).bytes);
    }

    @Override
    public int compareTo(ByteString that) {
        byte[] v1 = this.bytes;
        byte[] v2 = that.bytes;
        int n = Math.min(v1.length, v2.length);
        for (int i = 0; i < n; ++i) {
            int c1 = v1[i] & 0xFF;
            int c2 = v2[i] & 0xFF;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return v1.length - v2.length;
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int base) {
        return ByteString.toString(this.bytes, base);
    }

    public static String toString(byte[] bytes, int base) {
        char[] chars;
        int j = 0;
        switch (base) {
            case 2: {
                chars = new char[bytes.length * 8];
                for (byte b : bytes) {
                    chars[j++] = DIGITS[(b & 0x80) >> 7];
                    chars[j++] = DIGITS[(b & 0x40) >> 6];
                    chars[j++] = DIGITS[(b & 0x20) >> 5];
                    chars[j++] = DIGITS[(b & 0x10) >> 4];
                    chars[j++] = DIGITS[(b & 8) >> 3];
                    chars[j++] = DIGITS[(b & 4) >> 2];
                    chars[j++] = DIGITS[(b & 2) >> 1];
                    chars[j++] = DIGITS[b & 1];
                }
                break;
            }
            case 16: {
                chars = new char[bytes.length * 2];
                for (byte b : bytes) {
                    chars[j++] = DIGITS[(b & 0xF0) >> 4];
                    chars[j++] = DIGITS[b & 0xF];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad base " + base);
            }
        }
        return String.valueOf(chars, 0, j);
    }

    public String toBase64String() {
        return Base64.encodeBytes(this.bytes);
    }

    public static ByteString of(String string, int base) {
        byte[] bytes = ByteString.parse(string, base);
        return new ByteString(bytes, false);
    }

    public static byte[] parse(String string, int base) {
        byte[] bytes;
        char[] chars = string.toCharArray();
        int j = 0;
        int b = 0;
        switch (base) {
            case 2: {
                bytes = new byte[chars.length / 8];
                for (char c : chars) {
                    b = (byte)(b << 1);
                    if (c == '1') {
                        b = (byte)(b | 1);
                    }
                    if (j % 8 == 7) {
                        bytes[j / 8] = b;
                        b = 0;
                    }
                    ++j;
                }
                break;
            }
            case 16: {
                if (chars.length % 2 != 0) {
                    throw new IllegalArgumentException("hex string has odd length");
                }
                bytes = new byte[chars.length / 2];
                for (char c : chars) {
                    b = (byte)(b << 4);
                    byte i = ByteString.decodeHex(c);
                    b = (byte)(b | i & 0xF);
                    if (j % 2 == 1) {
                        bytes[j / 2] = b;
                        b = 0;
                    }
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad base " + base);
            }
        }
        return bytes;
    }

    private static byte decodeHex(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new IllegalArgumentException("invalid hex character: " + c);
    }

    public static ByteString ofBase64(String string) {
        byte[] bytes = ByteString.parseBase64(string);
        return new ByteString(bytes, false);
    }

    public static byte[] parseBase64(String string) {
        try {
            return Base64.decode(string);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("bad base64 string", e);
        }
    }

    public Object clone() {
        return this;
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int i) {
        return this.bytes[i];
    }

    public ByteString substring(int start, int end) {
        byte[] bytes = Arrays.copyOfRange(this.bytes, start, end);
        return new ByteString(bytes, false);
    }

    public ByteString substring(int start) {
        return this.substring(start, this.length());
    }

    @JsonValue
    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public ByteString concat(ByteString other) {
        int otherLen = other.length();
        if (otherLen == 0) {
            return this;
        }
        int len = this.bytes.length;
        byte[] buf = Arrays.copyOf(this.bytes, len + otherLen);
        System.arraycopy(other.bytes, 0, buf, len, other.bytes.length);
        return new ByteString(buf, false);
    }

    public int indexOf(ByteString seek) {
        return this.indexOf(seek, 0);
    }

    public int indexOf(ByteString seek, int start) {
        block0: for (int i = start; i < this.bytes.length - seek.bytes.length + 1; ++i) {
            int j = 0;
            while (j != seek.bytes.length) {
                if (this.bytes[i + j] != seek.bytes[j]) continue block0;
                ++j;
            }
            return i;
        }
        return -1;
    }

    public boolean startsWith(ByteString prefix, int offset) {
        if (offset < 0 || offset > this.bytes.length - prefix.bytes.length) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (j < prefix.bytes.length) {
            if (this.bytes[i++] == prefix.bytes[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteString prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(ByteString suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }
}

