/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.sql.Connection;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Ddl;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.BaseOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.PreScenarioOperation;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreScenarioOperationSupplier
extends BaseOperationSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreScenarioOperationSupplier.class);

    public PreScenarioOperationSupplier(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario) {
        super(phoenixUtil, model, scenario);
    }

    @Override
    public Function<TenantOperationInfo, OperationStats> get() {
        return new Function<TenantOperationInfo, OperationStats>(){

            @Override
            public OperationStats apply(TenantOperationInfo input) {
                Preconditions.checkNotNull(input);
                PreScenarioOperation operation = (PreScenarioOperation)input.getOperation();
                String tenantGroup = input.getTenantGroupId();
                String opGroup = input.getOperationGroupId();
                String tableName = input.getTableName();
                String scenarioName = input.getScenarioName();
                boolean isTenantGroupGlobal = tenantGroup.compareTo("GLOBAL") == 0;
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                int status = 0;
                if (!operation.getPreScenarioDdls().isEmpty()) {
                    for (Ddl ddl : operation.getPreScenarioDdls()) {
                        String tenantId = isTenantGroupGlobal || ddl.isUseGlobalConnection() ? null : input.getTenantId();
                        String opName = String.format("%s:%s:%s:%s:%s", scenarioName, tableName, opGroup, tenantGroup, input.getTenantId());
                        try (Connection conn = PreScenarioOperationSupplier.this.phoenixUtil.getConnection(tenantId);){
                            LOGGER.info("\nExecuting DDL:" + ddl + ", OPERATION:" + opName);
                            String sql = ddl.toString();
                            PreScenarioOperationSupplier.this.phoenixUtil.executeStatement(sql, conn);
                            PhoenixUtil cfr_ignored_0 = PreScenarioOperationSupplier.this.phoenixUtil;
                            if (!ddl.getStatement().toUpperCase().contains("ASYNC")) continue;
                            PreScenarioOperationSupplier.this.phoenixUtil.waitForAsyncIndexToFinish(ddl.getTableName());
                        }
                        catch (Exception e) {
                            LOGGER.error("Operation " + opName + " failed with exception ", (Throwable)e);
                            status = -1;
                        }
                    }
                }
                long totalDuration = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                return new OperationStats(input, startTime, status, operation.getPreScenarioDdls().size(), totalDuration);
            }
        };
    }
}

