/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.util;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.mapreduce.index.automation.PhoenixMRJobSubmitter;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Ddl;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.result.DataLoadTimeSummary;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixUtil {
    public static final String ASYNC_KEYWORD = "ASYNC";
    public static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixUtil.class);
    private static String zookeeper;
    private static int rowCountOverride;
    private boolean testEnabled;
    private static PhoenixUtil instance;
    private static boolean useThinDriver;
    private static String queryServerUrl;
    private static final int ONE_MIN_IN_MS = 60000;
    private static String CurrentSCN;

    private PhoenixUtil() {
        this(false);
    }

    private PhoenixUtil(boolean testEnabled) {
        this.testEnabled = testEnabled;
    }

    public static PhoenixUtil create() {
        return PhoenixUtil.create(false);
    }

    public static PhoenixUtil create(boolean testEnabled) {
        instance = instance != null ? instance : new PhoenixUtil(testEnabled);
        return instance;
    }

    public static void useThinDriver(String queryServerUrl) {
        useThinDriver = true;
        PhoenixUtil.queryServerUrl = Objects.requireNonNull(queryServerUrl);
    }

    public static String getQueryServerUrl() {
        return queryServerUrl;
    }

    public static boolean isThinDriver() {
        return useThinDriver;
    }

    public static Gson getGSON() {
        return GSON;
    }

    public Connection getConnection() throws Exception {
        return this.getConnection(null);
    }

    public Connection getConnection(String tenantId) throws Exception {
        return this.getConnection(tenantId, this.testEnabled, null);
    }

    public Connection getConnection(String tenantId, Properties properties) throws Exception {
        Map<String, String> propertyHashMap = this.getPropertyHashMap(properties);
        return this.getConnection(tenantId, this.testEnabled, propertyHashMap);
    }

    public Connection getConnection(String tenantId, Map<String, String> propertyHashMap) throws Exception {
        return this.getConnection(tenantId, this.testEnabled, propertyHashMap);
    }

    public Connection getConnection(String tenantId, boolean testEnabled, Map<String, String> propertyHashMap) throws Exception {
        if (useThinDriver) {
            if (null == queryServerUrl) {
                throw new IllegalArgumentException("QueryServer URL must be set before initializing connection");
            }
            Properties props = new Properties();
            if (null != tenantId) {
                props.setProperty("TenantId", tenantId);
                LOGGER.debug("\nSetting tenantId to " + tenantId);
            }
            String url = "jdbc:phoenix:thin:url=" + queryServerUrl + ";serialization=PROTOBUF";
            return DriverManager.getConnection(url, props);
        }
        if (null == zookeeper) {
            throw new IllegalArgumentException("Zookeeper must be set before initializing connection!");
        }
        Properties props = new Properties();
        if (null != tenantId) {
            props.setProperty("TenantId", tenantId);
            LOGGER.debug("\nSetting tenantId to " + tenantId);
        }
        if (propertyHashMap != null) {
            for (Map.Entry entry : propertyHashMap.entrySet()) {
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
                LOGGER.debug("Setting connection property " + (String)entry.getKey() + " to " + (String)entry.getValue());
            }
        }
        String url = "jdbc:phoenix:" + zookeeper + (testEnabled ? ";test=true" : "");
        return DriverManager.getConnection(url, props);
    }

    private Map<String, String> getPropertyHashMap(Properties props) {
        HashMap<String, String> propsMaps = new HashMap<String, String>();
        for (String prop : props.stringPropertyNames()) {
            propsMaps.put(prop, props.getProperty(prop));
        }
        return propsMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatement(String sql, Scenario scenario) throws Exception {
        boolean result = false;
        try (Connection connection = null;){
            connection = this.getConnection(scenario.getTenantId());
            result = this.executeStatement(sql, connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatementThrowException(String sql, Connection connection) throws SQLException {
        boolean result = false;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement(sql);
            result = preparedStatement.execute();
            connection.commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatement(String sql, Connection connection) throws SQLException {
        boolean result = false;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            result = preparedStatement.execute();
            connection.commit();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean executeStatement(PreparedStatement preparedStatement, Connection connection) {
        boolean result = false;
        try {
            result = preparedStatement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTables(String regexMatch) throws Exception {
        regexMatch = regexMatch.toUpperCase().replace("ALL", ".*");
        try (Connection conn = this.getConnection();){
            ResultSet resultSet = this.getTableMetaData("PHERF", null, conn);
            while (resultSet.next()) {
                Object tableName = resultSet.getString("TABLE_SCHEM") == null ? resultSet.getString("TABLE_NAME") : resultSet.getString("TABLE_SCHEM") + "." + resultSet.getString("TABLE_NAME");
                if (!((String)tableName).matches(regexMatch)) continue;
                LOGGER.info("\nDropping " + (String)tableName);
                try {
                    this.executeStatementThrowException("DROP TABLE " + (String)tableName + " CASCADE", conn);
                }
                catch (TableNotFoundException tnf) {
                    LOGGER.error("Table might be already be deleted via cascade. Schema: " + tnf.getSchemaName() + " Table: " + tnf.getTableName());
                }
            }
        }
    }

    public void dropChildView(RegionCoprocessorEnvironment taskRegionEnvironment, int depth) {
        TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(taskRegionEnvironment, 1800000L);
        for (int i = 0; i < depth; ++i) {
            task.run();
        }
    }

    public ResultSet getTableMetaData(String schemaName, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        ResultSet resultSet = dbmd.getTables(null, schemaName, tableName, null);
        return resultSet;
    }

    public ResultSet getColumnsMetaData(String schemaName, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        ResultSet resultSet = dbmd.getColumns(null, schemaName.toUpperCase(), tableName.toUpperCase(), null);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Column> getColumnsFromPhoenix(String schemaName, String tableName, Connection connection) throws SQLException {
        ArrayList<Column> columnList = new ArrayList<Column>();
        ResultSet resultSet = null;
        try {
            resultSet = this.getColumnsMetaData(schemaName, tableName, connection);
            while (resultSet.next()) {
                Column column = new Column();
                column.setName(resultSet.getString("COLUMN_NAME"));
                column.setType(DataTypeMapping.valueOf(resultSet.getString("TYPE_NAME").replace(" ", "_")));
                column.setLength(resultSet.getInt("COLUMN_SIZE"));
                columnList.add(column);
                LOGGER.debug(String.format("getColumnsMetaData for column name : %s", column.getName()));
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        return Collections.unmodifiableList(columnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuerySetDdls(QuerySet querySet) throws Exception {
        for (Query query : querySet.getQuery()) {
            if (null == query.getDdl()) continue;
            Connection conn = null;
            try {
                LOGGER.info("\nExecuting DDL:" + query.getDdl() + " on tenantId:" + query.getTenantId());
                conn = this.getConnection(query.getTenantId());
                this.executeStatement(query.getDdl(), conn);
            }
            finally {
                if (null == conn) continue;
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScenarioDdl(List<Ddl> ddls, String tenantId, DataLoadTimeSummary dataLoadTimeSummary) throws Exception {
        if (null != ddls) {
            Connection conn = null;
            try {
                for (Ddl ddl : ddls) {
                    LOGGER.info("\nExecuting DDL:" + ddl + " on tenantId:" + tenantId);
                    long startTime = EnvironmentEdgeManager.currentTimeMillis();
                    conn = this.getConnection(tenantId);
                    this.executeStatement(ddl.toString(), conn);
                    if (ddl.getStatement().toUpperCase().contains(ASYNC_KEYWORD)) {
                        this.waitForAsyncIndexToFinish(ddl.getTableName());
                    }
                    dataLoadTimeSummary.add(ddl.getTableName(), 0, (int)(EnvironmentEdgeManager.currentTimeMillis() - startTime));
                }
            }
            finally {
                if (null != conn) {
                    conn.close();
                }
            }
        }
    }

    public void waitForAsyncIndexToFinish(String tableName) throws InterruptedException {
        boolean jobStarted = false;
        for (int i = 0; i < 15; ++i) {
            if (this.isYarnJobInProgress(tableName)) {
                jobStarted = true;
                break;
            }
            Thread.sleep(60000L);
        }
        if (!jobStarted) {
            throw new IllegalStateException("ASYNC index build did not start within 15 mins");
        }
        while (this.isYarnJobInProgress(tableName)) {
            Thread.sleep(60000L);
        }
    }

    boolean isYarnJobInProgress(String tableName) {
        try {
            LOGGER.info("Fetching YARN apps...");
            Set response = new PhoenixMRJobSubmitter().getSubmittedYarnApps();
            for (String str : response) {
                LOGGER.info("Runnng YARN app: " + str);
                if (!str.toUpperCase().contains(tableName.toUpperCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getZookeeper() {
        return zookeeper;
    }

    public static void setZookeeper(String zookeeper) {
        LOGGER.info("Setting zookeeper: " + zookeeper);
        PhoenixUtil.useThickDriver(zookeeper);
    }

    public static void useThickDriver(String zookeeper) {
        useThinDriver = false;
        PhoenixUtil.zookeeper = Objects.requireNonNull(zookeeper);
    }

    public static int getRowCountOverride() {
        return rowCountOverride;
    }

    public static void setRowCountOverride(int rowCountOverride) {
        PhoenixUtil.rowCountOverride = rowCountOverride;
    }

    public void updatePhoenixStats(String tableName, Scenario scenario) throws Exception {
        LOGGER.info("Updating stats for " + tableName);
        this.executeStatement("UPDATE STATISTICS " + tableName, scenario);
    }

    public String getExplainPlan(Query query) throws SQLException {
        return this.getExplainPlan(query, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainPlan(Query query, Scenario scenario, RulesApplier ruleApplier) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        StringBuilder buf = new StringBuilder();
        try {
            conn = this.getConnection(query.getTenantId());
            String explainQuery = scenario != null && ruleApplier != null ? query.getDynamicStatement(ruleApplier, scenario) : query.getStatement();
            statement = conn.prepareStatement("EXPLAIN " + explainQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                buf.append(rs.getString(1).trim().replace(",", "-"));
            }
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return buf.toString();
    }

    public PreparedStatement buildStatement(RulesApplier rulesApplier, Scenario scenario, List<Column> columns, PreparedStatement statement, SimpleDateFormat simpleDateFormat) throws Exception {
        int count = 1;
        for (Column column : columns) {
            DataValue dataValue = rulesApplier.getDataForRule(scenario, column);
            switch (column.getType()) {
                case VARCHAR: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 12);
                        break;
                    }
                    statement.setString(count, dataValue.getValue());
                    break;
                }
                case JSON: 
                case BSON: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, -3);
                        break;
                    }
                    statement.setString(count, dataValue.getValue());
                    break;
                }
                case CHAR: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 1);
                        break;
                    }
                    statement.setString(count, dataValue.getValue());
                    break;
                }
                case DECIMAL: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 3);
                        break;
                    }
                    statement.setBigDecimal(count, new BigDecimal(dataValue.getValue()));
                    break;
                }
                case INTEGER: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 4);
                        break;
                    }
                    statement.setInt(count, Integer.parseInt(dataValue.getValue()));
                    break;
                }
                case UNSIGNED_LONG: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 1111);
                        break;
                    }
                    statement.setLong(count, Long.parseLong(dataValue.getValue()));
                    break;
                }
                case BIGINT: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, -5);
                        break;
                    }
                    statement.setLong(count, Long.parseLong(dataValue.getValue()));
                    break;
                }
                case TINYINT: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, -6);
                        break;
                    }
                    statement.setLong(count, Integer.parseInt(dataValue.getValue()));
                    break;
                }
                case DATE: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 91);
                        break;
                    }
                    Date date = new Date(simpleDateFormat.parse(dataValue.getValue()).getTime());
                    statement.setDate(count, date);
                    break;
                }
                case VARCHAR_ARRAY: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 2003);
                        break;
                    }
                    Array arr = statement.getConnection().createArrayOf("VARCHAR", dataValue.getValue().split(","));
                    statement.setArray(count, arr);
                    break;
                }
                case VARBINARY: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, -3);
                        break;
                    }
                    statement.setBytes(count, dataValue.getValue().getBytes());
                    break;
                }
                case TIMESTAMP: {
                    if (dataValue.getValue().equals("")) {
                        statement.setNull(count, 93);
                        break;
                    }
                    Timestamp ts = new Timestamp(simpleDateFormat.parse(dataValue.getValue()).getTime());
                    statement.setTimestamp(count, ts);
                    break;
                }
            }
            ++count;
        }
        return statement;
    }

    public String buildSql(List<Column> columns, String tableName) {
        StringBuilder builder = new StringBuilder();
        builder.append("upsert into ");
        builder.append(tableName);
        builder.append(" (");
        int count = 1;
        for (Column column : columns) {
            builder.append(column.getName());
            if (count < columns.size()) {
                builder.append(",");
            } else {
                builder.append(")");
            }
            ++count;
        }
        builder.append(" VALUES (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i < columns.size() - 1) {
                builder.append("?,");
                continue;
            }
            builder.append("?)");
        }
        return builder.toString();
    }

    public Pair<Long, Long> getResults(Query query, ResultSet rs, String queryIteration, boolean isSelectCountStatement, Long queryStartTime) throws Exception {
        Long resultRowCount = 0L;
        while (rs.next()) {
            long queryElapsedTime;
            if (isSelectCountStatement) {
                resultRowCount = rs.getLong(1);
            } else {
                Long l = resultRowCount;
                resultRowCount = resultRowCount + 1L;
            }
            if ((queryElapsedTime = EnvironmentEdgeManager.currentTimeMillis() - queryStartTime) < query.getTimeoutDuration()) continue;
            LOGGER.error("Query " + queryIteration + " exceeded timeout of " + query.getTimeoutDuration() + " ms at " + queryElapsedTime + " ms.");
            return new Pair((Object)resultRowCount, (Object)queryElapsedTime);
        }
        return new Pair((Object)resultRowCount, (Object)(EnvironmentEdgeManager.currentTimeMillis() - queryStartTime));
    }

    static {
        rowCountOverride = 0;
        CurrentSCN = null;
    }
}

