/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;

public abstract class DefaultResultHandler
implements ResultHandler {
    protected String resultFileName;
    protected ResultFileDetails resultFileDetails;
    protected final String resultDir;
    protected final ResultUtil util = new ResultUtil();

    public DefaultResultHandler() {
        PherfConstants constants = PherfConstants.create();
        this.resultDir = constants.getProperty("pherf.default.results.dir");
    }

    @Override
    public void setResultFileName(String resultFileName) {
        this.resultFileName = this.resultDir + "/RESULT_" + resultFileName + this.util.getSuffix() + this.getResultFileDetails().getExtension().toString();
    }

    @Override
    public void setResultFileDetails(ResultFileDetails details) {
        this.resultFileDetails = details;
    }

    @Override
    public String getResultFileName() {
        return this.resultFileName;
    }

    @Override
    public ResultFileDetails getResultFileDetails() {
        return this.resultFileDetails;
    }
}

